/*
 * Decompiled with CFR 0.152.
 */
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3f;

public class GeomUpdaterComic
implements GeometryUpdater {
    float[] original;
    float[] normals;
    Transform3D transform;
    Vector3f lightVec;

    public GeomUpdaterComic(float[] fArray, float[] fArray2) {
        this.original = fArray;
        this.normals = fArray2;
    }

    private void calcNewTexCoords(float[] fArray) {
        Vector3f vector3f = new Vector3f();
        int n = 0;
        while (n < this.original.length >> 1) {
            float f;
            float f2 = this.normals[n * 3];
            float f3 = this.normals[n * 3 + 1];
            float f4 = this.normals[n * 3 + 2];
            vector3f.x = f2;
            vector3f.y = f3;
            vector3f.z = f4;
            this.transform.transform(vector3f);
            fArray[n * 2] = f = (vector3f.x * this.lightVec.x + vector3f.y * this.lightVec.y + vector3f.z * this.lightVec.z) / (float)Math.sqrt(vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z);
            ++n;
        }
    }

    public void updateData(Geometry geometry) {
        float[] fArray = ((GeometryArray)geometry).getTexCoordRefFloat(0);
        this.calcNewTexCoords(fArray);
    }

    public void setUpdateData(Transform3D transform3D, Vector3f vector3f) {
        this.transform = transform3D;
        this.lightVec = vector3f;
    }
}

