/* horizontalstripes.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "effect.h"
#include "horizontalstripes.h"

#define getalpha(data) ((((data)&0xff000000)>>24)+1)
#define applyalpha(data, alpha) (0xff000000|(((((data)&0xff0000)*(alpha))>>8)&0xff0000)|(((((data)&0xff00)*(alpha))>>8)&0xff00)|(((((data)&0xff)*(alpha))>>8)&0xff))

void horizontalstripes_run(void *d, long time) {
  horizontalstripes_data *data=(horizontalstripes_data *)d;

  /* Get local copies of the parameters */
  unsigned long *dest=data->dest->data+((data->y)*data->dest->width+data->x);
  unsigned char *alphas=data->alphas;
  int width=data->width, height=data->height;
  int dx=data->dest->width-width, x, y;

  for(y=0; y<height; y++) {
    int alpha=(*alphas++)+1;
    if(alpha==256)
      dest+=width;
    else if(alpha==1)
      for(x=0; x<width; x++)
	*dest++=0xff000000;
    else
      for(x=0; x<width; x++) {
	*dest=applyalpha(*dest, alpha);
	dest++;
      }
    dest+=dx;
  }
}

void horizontalstripes_free(effect *effect) {
  horizontalstripes_data *data=(horizontalstripes_data *)(effect->data);
  if(data->alphas!=NULL)
    free(data->alphas);
  
  free(effect->data);
}

void horizontalstripes_new(effect *effect) {
  effect->run=horizontalstripes_run;
  effect->new=horizontalstripes_new;
  effect->parameters=NULL;
  effect->freee=horizontalstripes_free;
  effect->data=(horizontalstripes_data *)calloc(sizeof(horizontalstripes_data),
						1);
}
