/* assembly2002demo41.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Help on background, credits */
#include "assembly2002demo.h"

static void params_41_horizontalblur(void *d, long time) {
  horizontalblur_data *data=(horizontalblur_data *)d;
  time-=PART_41_START;
  if(time<0)
    time=0;

  data->amount=50+49*sin((double)time*2*M_PI/SONGPOSTOTIME(2, 48));
  data->source=pictures[HELP1+time/SONGPOSTOTIME(2, 0)];
}

static void params_41_verticalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  time-=PART_41_START;
  if(time<0)
    time=0;

  data->amount=50+49*cos((double)time*2*M_PI/SONGPOSTOTIME(2, 40));
}

static void params_41_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_41_START;
  if(time<0)
    time=0;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);

  if(time/8>255)
    data->color=0;
  else 
    data->color=((255-time/8)<<24|0xffffff);
}

static void params_41_copy_text1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[CREDITS];
    if(time<SONGPOSTOTIME(1, 32))
      data->destx=100+70*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
    else
      data->destx=170;
  } else if(time<SONGPOSTOTIME(5, 0)) {
    data->source=pictures[THANKS];
    if(time<SONGPOSTOTIME(3, 32))
      data->destx=100+70*sin((double)(time-SONGPOSTOTIME(3, 0))*M_PI/2/SONGPOSTOTIME(1, 32));
    else
      data->destx=170;
  }
    
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(3, 0))
    time-=SONGPOSTOTIME(3, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(3, 0));
}

static void params_41_copy_text2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[CREDITS];
    if(time<SONGPOSTOTIME(1, 32))
      data->destx=240-70*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
    else
      data->destx=170;
  } else if(time<SONGPOSTOTIME(5, 0)) {
    data->source=pictures[THANKS];
    if(time<SONGPOSTOTIME(3, 32))
      data->destx=240-70*sin((double)(time-SONGPOSTOTIME(3, 0))*M_PI/2/SONGPOSTOTIME(1, 32));
    else
      data->destx=170;
  }
    
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(3, 0))
    time-=SONGPOSTOTIME(3, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(3, 0));
}

static void params_41_copy_text3(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x=0;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[KODE];
    data->desty=135;
    x=115;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[GFX];
    data->desty=135;
    x=165;
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->source=pictures[INSPIRATION];
    data->desty=165;
    x=45;
  } else {
    data->source=pictures[SUPPORT];
    data->desty=165;
    x=45;
  } 

  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  if(time<SONGPOSTOTIME(1, 32))
    data->destx=x-80+80*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
  else
    data->destx=x;
}

static void params_41_copy_text4(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x=0;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[KODE];
    data->desty=135;
    x=115;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[GFX];
    data->desty=135;
    x=165;
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->source=pictures[INSPIRATION];
    data->desty=165;
    x=45;
  } else {
    data->source=pictures[SUPPORT];
    data->desty=165;
    x=45;
  } 

  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  if(time<SONGPOSTOTIME(1, 32))
    data->destx=x+80-80*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
  else
    data->destx=x;
}

static void params_41_copy_text5(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x=0;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[MUSIK];
    data->desty=190;
    x=155;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[DESIGN];
    data->desty=180;
    x=115;
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->source=pictures[GMUNK];
    data->desty=125;
    x=170;
  } else {
    data->source=pictures[VIRNES];
    data->desty=125;
    x=230;
  } 

  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  if(time<SONGPOSTOTIME(1, 32))
    data->destx=x-80+80*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
  else
    data->destx=x;
}

static void params_41_copy_text6(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x=0;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[MUSIK];
    data->desty=190;
    x=155;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[DESIGN];
    data->desty=180;
    x=115;
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->source=pictures[GMUNK];
    data->desty=125;
    x=170;
  } else {
    data->source=pictures[VIRNES];
    data->desty=125;
    x=230;
  } 

  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  if(time<SONGPOSTOTIME(1, 32))
    data->destx=x+80-80*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
  else
    data->destx=x;
}

static void params_41_copy_text7(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x=0;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[VESURI];
    data->desty=155;
    x=225;
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->source=pictures[LIEVONEN];
    data->desty=185;
    x=230;
  } else {
    data->source=pictures[JRM];
    data->desty=185;
    x=150;
  }

  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  if(time<SONGPOSTOTIME(1, 32))
    data->destx=x-80+80*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
  else
    data->destx=x;
}

static void params_41_copy_text8(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x=0;
  time-=PART_41_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(3, 0)) {
    data->source=pictures[VESURI];
    data->desty=155;
    x=225;
  } else if(time<SONGPOSTOTIME(4, 0)) {
    data->source=pictures[LIEVONEN];
    data->desty=185;
    x=230;
  } else {
    data->source=pictures[JRM];
    data->desty=185;
    x=150;
  }

  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->source->width;
  data->destheight=data->source->height;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);
  data->alpha=63*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  if(time<SONGPOSTOTIME(1, 32))
    data->destx=x+80-80*sin((double)time*M_PI/2/SONGPOSTOTIME(1, 32));
  else
    data->destx=x;
}

void part_41() {
  copy_data *copydata;
  horizontalstretch_data *hsdata;
  horizontalblur_data *hbdata;
  verticalblur_data *vbdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 11. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_41_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 10. Copy text8 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text8),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 9. Copy text7 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text7),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Copy text6 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text6),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Copy text5 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text5),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Copy text4 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text4),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy text3 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text3),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=15;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy text2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=70;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy text1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_41_copy_text1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PEACEOFMIND];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=230;
  copydata->desty=70;
  copydata->sourcewidth=pictures[PEACEOFMIND]->width;
  copydata->sourceheight=pictures[PEACEOFMIND]->height;
  copydata->destwidth=pictures[PEACEOFMIND]->width;
  copydata->destheight=pictures[PEACEOFMIND]->height;
  copydata->alpha=31;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Blur the background vertically */
  effectlist=effectlistentry_new(effect_new(verticalblur_new,
					    params_41_verticalblur),
				 effectlist);
  vbdata=(verticalblur_data *)effectlist->effect->data;
  vbdata->source=pictures[TEMP];
  vbdata->dest=&screenbuffer;
  vbdata->amount=50;

  /* 1. Blur the background horizontally */
  effectlist=effectlistentry_new(effect_new(horizontalblur_new,
					    params_41_horizontalblur),
				 effectlist);
  hbdata=(horizontalblur_data *)effectlist->effect->data;
  hbdata->source=pictures[HELP1];
  hbdata->dest=pictures[TEMP];
  hbdata->amount=50;
}
