/*
**
**		The true, the original, the great, the unique Mistirassoni effect !!!
**
**		by FirEdge / Ethereal on 06.29.2001
**
*/



#include <windows.h>
#include <gl/gl.h>
#include <math.h>

#include "ijl.h"

#include "fxMistirassoni.hpp"


/*
**	The true original mistirassoni.
*/


#define MX 10000
#define MY 128000
#define MZ 65000


fxMistirassoni::fxMistirassoni()
{
	vertex A,B,C,D,E,F;

	weird = false;

	BlehX	=	1.0f;
	BlehZ	=	1.0f;

	A.x = 0.0f;
	A.y = 0.0f;
	A.z = BlehZ;

	B.x = BlehX / 3.0f;
	B.y = -0.5f;
	B.z = BlehZ / 3.0f;

	C.x = BlehX;
	C.y = 0.0f;
	C.z = 0.0f;

	D.x = 0.0f;
	D.y = 0.0f;
	D.z = -BlehZ;

	E.x = - BlehX / 3.0f;
	E.y = - 0.5f;
	E.z = - BlehZ / 3.0f;

	F.x = - BlehX;
	F.y = 0.0f;
	F.z = 0.0f;
	
	N1 = ndp( A , B );
	N2 = ndp( B , C );
	N3 = ndp( D , E );
	N4 = ndp( E , F );

	P[0].x = -0.5f;
	P[0].y = 0.25f;
	P[0].z = -0.5f;

	P[1].x = -0.5f;
	P[1].y = 0.25f;
	P[1].z = 0.5f;

	P[2].x = -0.1666f;
	P[2].y = -0.25f;
	P[2].z = 0.1666f;

	P[3].x = -0.1666f;
	P[3].y = -0.25f;
	P[3].z = -0.1666f;

	P[4].x = 0.5f;
	P[4].y = 0.25f;
	P[4].z = 0.5f;

	P[5].x = 0.5f;
	P[5].y = 0.25f;
	P[5].z = -0.5f;

	P[6].x = 0.1666f;
	P[6].y = -0.25f;
	P[6].z = 0.1666f;

	P[7].x = 0.1666f;
	P[7].y = -0.25f;
	P[7].z = -0.1666f;

	for (int i=0; i<100; i++)
	{
		M[i].p.x = rand() / MX;
		M[i].p.y = rand() / MY;
		M[i].p.z = rand() / MZ;
		M[i].rx = rand() / 256.0f;
		M[i].ry = rand() / 256.0f;
		M[i].rz = rand() / 256.0f;
	}

	// Damn 3DS rules.

}


bool fxMistirassoni::Init(const Loader* l)
{
	JPEG_CORE_PROPERTIES jcprops,jcprops1;
	BYTE pixel_buffer [128*128*3]; // MistirassoniTex is 128*128.
	BYTE buffer [1024*128*3];

	ijlInit (&jcprops);

	jcprops.JPGFile = "data/mistirassoni1.jpg";

	jcprops.DIBWidth = 128;
	jcprops.DIBHeight = 128;
	jcprops.DIBChannels = 3;
	jcprops.DIBColor = IJL_RGB;
	jcprops.DIBPadBytes = 0;
	jcprops.DIBBytes = pixel_buffer;

    ijlRead (&jcprops, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops);	
	
	glGenTextures(3 , &mistirassonimap );
	glBindTexture(GL_TEXTURE_2D, mistirassonimap);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buffer);

	ijlInit (&jcprops);

	jcprops.JPGFile = "data/mistirassoni1_h.jpg";

	jcprops.DIBWidth = 128;
	jcprops.DIBHeight = 128;
	jcprops.DIBChannels = 3;
	jcprops.DIBColor = IJL_RGB;
	jcprops.DIBPadBytes = 0;
	jcprops.DIBBytes = pixel_buffer;

    ijlRead (&jcprops, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops);	
	
	glBindTexture(GL_TEXTURE_2D, bumpmap);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buffer);

	for (int i=0; i<128*128*3; i++)
		pixel_buffer[i] = 255 - pixel_buffer[i];	// Calculate inverse bump

	glBindTexture(GL_TEXTURE_2D, invbumpmap);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buffer);


	ijlInit (&jcprops1);

	jcprops1.JPGFile = "data/creds.jpg";

	jcprops1.DIBWidth = 1024;
	jcprops1.DIBHeight = 128;
	jcprops1.DIBChannels = 3;
	jcprops1.DIBColor = IJL_RGB;
	jcprops1.DIBPadBytes = 0;
	jcprops1.DIBBytes = buffer;

    ijlRead (&jcprops1, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops1);	

	glBindTexture(GL_TEXTURE_2D, creds);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 1024, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, buffer );
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	
	return true;
}


void fxMistirassoni::Render(float time, const Demo *env)
{
	GLfloat light_position[] = { 2.5 , 2.0, 0.5, 0.0 };
	vertex l;
	matrix inv;
	vertex	N,pos;
	matrix	ct;
	vertex s1,s2,s3,s4,t1,t2,t3,t4,c;
	float tcoord[8][2];
	int i;

	// Couldn't have been released without nehe tutorial 22 on emboss bump mapping.
	// http://nehe.gamedev.net

	/* 
	** We shall not rely on a previous OpenGL 
	** configuration since many effects with 
	** different configs can run at the same time.
	*/

	glLoadIdentity();

	glTranslatef( 0.0f, 0.0f, 5.0f );
	glRotatef( -time*1580.0f , 0.0f, 1.0f, 0.0f);
	glRotatef( -time*2350.0f, 1.0f , 0.0f , 0.0f );
	glTranslatef( (time-0.5f) * 3.0f , 0.0f, 0.0f );

    glGetFloatv( GL_MODELVIEW_MATRIX , &inv._11 );

	// 1st pass : bump map

	if (weird & 1)
	{
		glEnable( GL_BLEND );
		glDisable( GL_DEPTH_TEST );
	} else {
		glDisable( GL_BLEND );
		glEnable( GL_DEPTH_TEST );
	}

	glBlendFunc(GL_ONE,GL_ONE);
	glBindTexture( GL_TEXTURE_2D, bumpmap );
	glDisable( GL_LIGHTING );

	/*
	**	Bump map
	*/

	for (i=0; i<100; i++)
	{
		glLoadIdentity();

		glTranslatef( 0.0f, 0.0f, 5.0f );
		glRotatef( -time*1580.0f , 0.0f, 1.0f, 0.0f);
		glRotatef( -time*2350.0f, 1.0f , 0.0f , 0.0f );
		glTranslatef( (time-0.5f) * -3.0f , 0.0f, 0.0f );

		glTranslatef( -M[i].p.x , -M[i].p.y , -M[i].p.z );
		glRotatef( -M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( -M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( -M[i].rz , 0.0f , 0.0f , 1.0f );

	    glGetFloatv( GL_MODELVIEW_MATRIX , &ct._11 );

		glLoadIdentity();

		glTranslatef( 0.0f, 0.0f, -5.0f );
		glRotatef( time*1580.0f , 0.0f, 1.0f, 0.0f);
		glRotatef( time*2350.0f, 1.0f , 0.0f , 0.0f );
		glTranslatef( (time-0.5f) * 3.0f , 0.0f, 0.0f );

		glRotatef( M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( M[i].rz , 0.0f , 0.0f , 1.0f );
		glTranslatef( M[i].p.x , M[i].p.y , M[i].p.z );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[0].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[1].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[2].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[3].x );
		glEnd();

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[1].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[4].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[6].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[2].x );
		glEnd();

		glBegin( GL_QUADS );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[4].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[5].x );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[7].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[6].x );
		glEnd();

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[5].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[0].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[3].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[7].x );
		glEnd();

	}	

	// 2nd pass : inverse bump map

	glBindTexture(GL_TEXTURE_2D,invbumpmap);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_BLEND);
	glDisable( GL_DEPTH_TEST );

	/*
	**	inverse Bump map
	*/

	for (i=0; i<100; i++)
	{
		glLoadIdentity();

		glTranslatef( 0.0f, 0.0f, -5.0f );
		glRotatef( time*1580.0f , 0.0f, 1.0f, 0.0f);
		glRotatef( time*2350.0f, 1.0f , 0.0f , 0.0f );
		glTranslatef( (time-0.5f) * 3.0f , 0.0f, 0.0f );

//		glTranslatef( M[i].p.x , M[i].p.y , M[i].p.z );
		glRotatef( M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( M[i].rz , 0.0f , 0.0f , 1.0f );
		

		s1.x = 0.0f;	t1.x = BlehX / 3.0f;
		s1.y = 0.0f;	t1.y = -0.5f;
		s1.z = 1.0f;	t1.z = BlehZ / 3.0f;

		s2.x = 1.0f;	t2.x = BlehX / 3.0f;
		s2.y = 0.0f;	t2.y = -0.5f;
		s2.z = 0.0f;	t2.z = -BlehZ / 3.0f;

		s3.x = 0.0f;	t3.x = -BlehX / 3.0f;
		s3.y = 0.0f;	t3.y = -0.5f;
		s3.z = -1.0f;	t3.z = -BlehZ / 3.0f;

		s4.x = -1.0f;	t4.x = -BlehX / 3.0f;
		s4.y = 0.0f;	t4.y = -0.5f;
		s4.z = 0.0f;	t4.z = BlehZ / 3.0f;

/*
		norm( t1 );
		norm( t2 );
		norm( t3 );
		norm( t4 ); //*/

		c.x = P[0].x + M[i].p.x ;
		c.y = P[0].y + M[i].p.y ;
		c.z = P[0].z + M[i].p.z ;
		SetUpBumps(&N1,&c,&l,&s1,&t1);
		tcoord[0][0] = c.x;
		tcoord[0][1] = c.y + 1.0f;

		c.x = P[3].x + M[i].p.x ;
		c.y = P[3].y + M[i].p.y ;
		c.z = P[3].z + M[i].p.z ;
		SetUpBumps(&N1,&c,&l,&s1,&t1);
		tcoord[1][0] = c.x;
		tcoord[1][1] = c.y;

		c.x = P[1].x + M[i].p.x ;
		c.y = P[1].y + M[i].p.y ;
		c.z = P[1].z + M[i].p.z ;
		SetUpBumps(&N2,&c,&l,&s2,&t2);
		tcoord[2][0] = c.x + 1.0f;
		tcoord[2][1] = c.y + 1.0f;
	
		c.x = P[2].x + M[i].p.x ;
		c.y = P[2].y + M[i].p.y ;
		c.z = P[2].z + M[i].p.z ;
		SetUpBumps(&N2,&c,&l,&s2,&t2);
		tcoord[3][0] = c.x + 1.0f;
		tcoord[3][1] = c.y;

		c.x = P[4].x + M[i].p.x ;
		c.y = P[4].y + M[i].p.y ;
		c.z = P[4].z + M[i].p.z ;
		SetUpBumps(&N3,&c,&l,&s3,&t3);
		tcoord[4][0] = c.x;
		tcoord[4][1] = c.y + 1.0f;
	
		c.x = P[6].x + M[i].p.x ;
		c.y = P[6].y + M[i].p.y ;
		c.z = P[6].z + M[i].p.z ;
		SetUpBumps(&N3,&c,&l,&s3,&t3);
		tcoord[5][0] = c.x;
		tcoord[5][1] = c.y;

		c.x = P[5].x + M[i].p.x ;
		c.y = P[5].y + M[i].p.y ;
		c.z = P[5].z + M[i].p.z ;
		SetUpBumps(&N4,&c,&l,&s4,&t4);
		tcoord[6][0] = c.x + 1.0f;
		tcoord[6][1] = c.y + 1.0f;
	
		c.x = P[7].x + M[i].p.x ;
		c.y = P[7].y + M[i].p.y ;
		c.z = P[7].z + M[i].p.z ;
		SetUpBumps(&N4,&c,&l,&s4,&t4);
		tcoord[7][0] = c.x + 1.0f;
		tcoord[7][1] = c.y;


		glBegin( GL_QUADS );	// Draw the mistirassoni!!!
	
			glTexCoord2fv( &tcoord[0][0] );		glVertex3f( P[0].x + M[i].p.x, P[0].y + M[i].p.y, P[0].z + M[i].p.z );
			glTexCoord2fv( &tcoord[2][0] );		glVertex3f( P[1].x + M[i].p.x, P[1].y + M[i].p.y, P[1].z + M[i].p.z );
			glTexCoord2fv( &tcoord[3][0] );		glVertex3f( P[2].x + M[i].p.x, P[2].y + M[i].p.y, P[2].z + M[i].p.z );
			glTexCoord2fv( &tcoord[1][0] );		glVertex3f( P[3].x + M[i].p.x, P[3].z + M[i].p.y, P[3].z + M[i].p.z );

			glTexCoord2fv( &tcoord[0][0] );		glVertex3f( P[1].x + M[i].p.x, P[1].y + M[i].p.y, P[1].z + M[i].p.z );
			glTexCoord2fv( &tcoord[6][0] );		glVertex3f( P[4].x + M[i].p.x, P[4].y + M[i].p.y, P[4].z + M[i].p.z );
			glTexCoord2fv( &tcoord[7][0] );		glVertex3f( P[6].x + M[i].p.x, P[6].y + M[i].p.y, P[6].z + M[i].p.z );
			glTexCoord2fv( &tcoord[1][0] );		glVertex3f( P[2].x + M[i].p.x, P[2].y + M[i].p.y, P[2].z + M[i].p.z );

			glTexCoord2fv( &tcoord[4][0] );		glVertex3f( P[4].x + M[i].p.x, P[4].y + M[i].p.y, P[4].z + M[i].p.z );
			glTexCoord2fv( &tcoord[6][0] );		glVertex3f( P[5].x + M[i].p.x, P[5].y + M[i].p.y, P[5].z + M[i].p.z );
			glTexCoord2fv( &tcoord[7][0] );		glVertex3f( P[7].x + M[i].p.x, P[7].y + M[i].p.y, P[7].z + M[i].p.z );
			glTexCoord2fv( &tcoord[5][0] );		glVertex3f( P[6].x + M[i].p.x, P[6].y + M[i].p.y, P[6].z + M[i].p.z );

			glTexCoord2fv( &tcoord[4][0] );		glVertex3f( P[5].x + M[i].p.x, P[5].y + M[i].p.y, P[5].z + M[i].p.z );
			glTexCoord2fv( &tcoord[2][0] );		glVertex3f( P[0].x + M[i].p.x, P[0].y + M[i].p.y, P[0].z + M[i].p.z );
			glTexCoord2fv( &tcoord[3][0] );		glVertex3f( P[3].x + M[i].p.x, P[3].z + M[i].p.y, P[3].z + M[i].p.z );
			glTexCoord2fv( &tcoord[5][0] );		glVertex3f( P[7].x + M[i].p.x, P[7].y + M[i].p.y, P[7].z + M[i].p.z );

		glEnd();

	} // for (int i=0; i<100; i++)


	// 3rd pass : lighted texture.

	glColor4ub( 128, 128 , 128 , 128 );
//	glEnable( GL_LIGHTING );
	glBindTexture(GL_TEXTURE_2D, mistirassonimap);
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	if ( !(weird & 1))
	    glBlendFunc( GL_DST_COLOR , GL_SRC_COLOR );
	else 
		glBlendFunc( GL_ONE_MINUS_SRC_COLOR , GL_ONE_MINUS_DST_COLOR );

	for (i=0; i<100; i++)
	{
		glLoadIdentity();

		glTranslatef( 0.0f, 0.0f, 5.0f );
		glRotatef( -time*1580.0f , 0.0f, 1.0f, 0.0f);
		glRotatef( -time*2350.0f, 1.0f , 0.0f , 0.0f );
		glTranslatef( (time-0.5f) * -3.0f , 0.0f, 0.0f );

		glTranslatef( -M[i].p.x , -M[i].p.y , -M[i].p.z );
		glRotatef( -M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( -M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( -M[i].rz , 0.0f , 0.0f , 1.0f );

	    glGetFloatv( GL_MODELVIEW_MATRIX , &ct._11 );

		glLoadIdentity();

		glTranslatef( 0.0f, 0.0f, -5.0f );
		glRotatef( time*1580.0f , 0.0f, 1.0f, 0.0f);
		glRotatef( time*2350.0f, 1.0f , 0.0f , 0.0f );
		glTranslatef( (time-0.5f) * 3.0f , 0.0f, 0.0f );

		glRotatef( M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( M[i].rz , 0.0f , 0.0f , 1.0f );
		glTranslatef( M[i].p.x , M[i].p.y , M[i].p.z );

		N.x = N1.x;		N.y = N1.y;		N.z = N1.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[0].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[1].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[2].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[3].x );
		glEnd();

		N.x = N2.x;		N.y = N2.y;		N.z = N2.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[1].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[4].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[6].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[2].x );
		glEnd();

		N.x = N3.x;		N.y = N3.y;		N.z = N3.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[4].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[5].x );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[7].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[6].x );
		glEnd();

		N.x = N4.x;		N.y = N4.y;		N.z = N4.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[5].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[0].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[3].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[7].x );
		glEnd();
	}	//*/


	glDisable( GL_DEPTH_TEST );

	glLoadIdentity();
	glTranslatef( 12.0f -time * 24.0f , 0.4f, -4.0f );

	glColor4ub( 255, 255, 255 , 128);
	glBindTexture(GL_TEXTURE_2D, creds);
	glBlendFunc( GL_ONE, GL_ONE );

	glBegin( GL_QUADS );
		glTexCoord2f( 0.0f , 0.0f );
		glVertex3f( -10.68f , 0.3f , 0.0f );
		glTexCoord2f( 1.0f , 0.0f );
		glVertex3f( 10.68f , 0.3f , 0.0f );
		glTexCoord2f( 1.0f , 1.0f );
		glVertex3f( 10.68f , -0.3f , 0.0f );
		glTexCoord2f( 0.0f , 1.0f );
		glVertex3f( -10.68f , -0.3f , 0.0f );
	glEnd();

	glEnable( GL_DEPTH_TEST );

}


void fxMistirassoni::Push(ud type, float value)
{
	if (type == PUSH_PERC)
		weird++;
}


void fxMistirassoni::DeInit()
{
	glDeleteTextures( 3, &mistirassonimap );
}


fxMistirassoni::~fxMistirassoni()
{
}


void fxMistirassoni::Mistirassoni()
{
	vertex	N,pos;
	matrix	ct;


	for (int i=0; i<100; i++)
	{
		glTranslatef( -M[i].p.x , -M[i].p.y , -M[i].p.z );
		glRotatef( -M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( -M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( -M[i].rz , 0.0f , 0.0f , 1.0f );

	    glGetFloatv( GL_MODELVIEW_MATRIX , &ct._11 );

		glTranslatef( 2.0f * M[i].p.x , 2.0f * M[i].p.y , 2.0f * M[i].p.z );
		glRotatef( 2.0f * M[i].rx , 1.0f , 0.0f , 0.0f );
		glRotatef( 2.0f * M[i].ry , 0.0f , 1.0f , 0.0f );
		glRotatef( 2.0f * M[i].rz , 0.0f , 0.0f , 1.0f );

		N.x = N1.x;		N.y = N1.y;		N.z = N1.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[0].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[1].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[2].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[3].x );
		glEnd();

		N.x = N2.x;		N.y = N2.y;		N.z = N2.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[1].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[4].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[6].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[2].x );
		glEnd();

		N.x = N3.x;		N.y = N3.y;		N.z = N3.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[4].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[5].x );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[7].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[6].x );
		glEnd();

		N.x = N4.x;		N.y = N4.y;		N.z = N4.z;

		VMatMult( &ct , &N );
		glNormal3fv( &N.x );

		glBegin( GL_QUADS );
			glTexCoord2f( 0.0f , 1.0f );		glVertex3fv( &P[5].x );
			glTexCoord2f( 1.0f , 1.0f );		glVertex3fv( &P[0].x );
			glTexCoord2f( 1.0f , 0.0f );		glVertex3fv( &P[3].x );
			glTexCoord2f( 0.0f , 0.0f );		glVertex3fv( &P[7].x );
		glEnd();
	}	

}


void fxMistirassoni::MistirassoniBump(vertex* l)	// Emboss according to Light vector.
{

	vertex s1,s2,s3,s4,t1,t2,t3,t4,c;
	float tcoord[8][2];

	for (int i=0; i<100; i++)
	{

		s1.x = 0.0f;	t1.x = BlehX / 3.0f;
		s1.y = 0.0f;	t1.y = -0.5f;
		s1.z = 1.0f;	t1.z = BlehZ / 3.0f;

		s2.x = 1.0f;	t2.x = BlehX / 3.0f;
		s2.y = 0.0f;	t2.y = -0.5f;
		s2.z = 0.0f;	t2.z = -BlehZ / 3.0f;

		s3.x = 0.0f;	t3.x = -BlehX / 3.0f;
		s3.y = 0.0f;	t3.y = -0.5f;
		s3.z = -1.0f;	t3.z = -BlehZ / 3.0f;

		s4.x = -1.0f;	t4.x = -BlehX / 3.0f;
		s4.y = 0.0f;	t4.y = -0.5f;
		s4.z = 0.0f;	t4.z = BlehZ / 3.0f;

/*		norm( t1 );
		norm( t2 );
		norm( t3 );
		norm( t4 ); //*/

		c.x = P[0].x + M[i].p.x ;
		c.y = P[0].y + M[i].p.y ;
		c.z = P[0].z + M[i].p.z ;
		SetUpBumps(&N1,&c,l,&s1,&t1);
		tcoord[0][0] = c.x;
		tcoord[0][1] = c.y + 1.0f;

		c.x = P[3].x + M[i].p.x ;
		c.y = P[3].y + M[i].p.y ;
		c.z = P[3].z + M[i].p.z ;
		SetUpBumps(&N1,&c,l,&s1,&t1);
		tcoord[1][0] = c.x;
		tcoord[1][1] = c.y;

		c.x = P[1].x + M[i].p.x ;
		c.y = P[1].y + M[i].p.y ;
		c.z = P[1].z + M[i].p.z ;
		SetUpBumps(&N2,&c,l,&s2,&t2);
		tcoord[2][0] = c.x + 1.0f;
		tcoord[2][1] = c.y + 1.0f;
	
		c.x = P[2].x + M[i].p.x ;
		c.y = P[2].y + M[i].p.y ;
		c.z = P[2].z + M[i].p.z ;
		SetUpBumps(&N2,&c,l,&s2,&t2);
		tcoord[3][0] = c.x + 1.0f;
		tcoord[3][1] = c.y;

		c.x = P[4].x + M[i].p.x ;
		c.y = P[4].y + M[i].p.y ;
		c.z = P[4].z + M[i].p.z ;
		SetUpBumps(&N3,&c,l,&s3,&t3);
		tcoord[4][0] = c.x;
		tcoord[4][1] = c.y + 1.0f;
	
		c.x = P[6].x + M[i].p.x ;
		c.y = P[6].y + M[i].p.y ;
		c.z = P[6].z + M[i].p.z ;
		SetUpBumps(&N3,&c,l,&s3,&t3);
		tcoord[5][0] = c.x;
		tcoord[5][1] = c.y;

		c.x = P[5].x + M[i].p.x ;
		c.y = P[5].y + M[i].p.y ;
		c.z = P[5].z + M[i].p.z ;
		SetUpBumps(&N4,&c,l,&s4,&t4);
		tcoord[6][0] = c.x + 1.0f;
		tcoord[6][1] = c.y + 1.0f;
	
		c.x = P[7].x + M[i].p.x ;
		c.y = P[7].y + M[i].p.y ;
		c.z = P[7].z + M[i].p.z ;
		SetUpBumps(&N4,&c,l,&s4,&t4);
		tcoord[7][0] = c.x + 1.0f;
		tcoord[7][1] = c.y;


		glBegin( GL_QUADS );	// Draw the mistirassoni!!!
	
			glTexCoord2fv( &tcoord[0][0] );		glVertex3f( P[0].x + M[i].p.x, P[0].y + M[i].p.y, P[0].z + M[i].p.z );
			glTexCoord2fv( &tcoord[2][0] );		glVertex3f( P[1].x + M[i].p.x, P[1].y + M[i].p.y, P[1].z + M[i].p.z );
			glTexCoord2fv( &tcoord[3][0] );		glVertex3f( P[2].x + M[i].p.x, P[2].y + M[i].p.y, P[2].z + M[i].p.z );
			glTexCoord2fv( &tcoord[1][0] );		glVertex3f( P[3].x + M[i].p.x, P[3].z + M[i].p.y, P[3].z + M[i].p.z );

			glTexCoord2fv( &tcoord[0][0] );		glVertex3f( P[1].x + M[i].p.x, P[1].y + M[i].p.y, P[1].z + M[i].p.z );
			glTexCoord2fv( &tcoord[6][0] );		glVertex3f( P[4].x + M[i].p.x, P[4].y + M[i].p.y, P[4].z + M[i].p.z );
			glTexCoord2fv( &tcoord[7][0] );		glVertex3f( P[6].x + M[i].p.x, P[6].y + M[i].p.y, P[6].z + M[i].p.z );
			glTexCoord2fv( &tcoord[1][0] );		glVertex3f( P[2].x + M[i].p.x, P[2].y + M[i].p.y, P[2].z + M[i].p.z );

			glTexCoord2fv( &tcoord[4][0] );		glVertex3f( P[4].x + M[i].p.x, P[4].y + M[i].p.y, P[4].z + M[i].p.z );
			glTexCoord2fv( &tcoord[6][0] );		glVertex3f( P[5].x + M[i].p.x, P[5].y + M[i].p.y, P[5].z + M[i].p.z );
			glTexCoord2fv( &tcoord[7][0] );		glVertex3f( P[7].x + M[i].p.x, P[7].y + M[i].p.y, P[7].z + M[i].p.z );
			glTexCoord2fv( &tcoord[5][0] );		glVertex3f( P[6].x + M[i].p.x, P[6].y + M[i].p.y, P[6].z + M[i].p.z );

			glTexCoord2fv( &tcoord[4][0] );		glVertex3f( P[5].x + M[i].p.x, P[5].y + M[i].p.y, P[5].z + M[i].p.z );
			glTexCoord2fv( &tcoord[2][0] );		glVertex3f( P[0].x + M[i].p.x, P[0].y + M[i].p.y, P[0].z + M[i].p.z );
			glTexCoord2fv( &tcoord[3][0] );		glVertex3f( P[3].x + M[i].p.x, P[3].z + M[i].p.y, P[3].z + M[i].p.z );
			glTexCoord2fv( &tcoord[5][0] );		glVertex3f( P[7].x + M[i].p.x, P[7].y + M[i].p.y, P[7].z + M[i].p.z );

		glEnd();

	} // for (int i=0; i<100; i++)

}

void fxMistirassoni::norm(vertex& v)
{
	float d = 1.0f / (float) sqrt( v.x * v.x + v.y * v.y + v.z * v.z );
	v.x *= d;
	v.y *= d;
	v.z *= d;
}

void fxMistirassoni::SetUpBumps(vertex* n, vertex* c, vertex* l, vertex* s, vertex* t)
{
  vertex v;
  GLfloat lenQ;

  v.x = l->x - c->x ;
  v.y = l->y - c->y ;
  v.z = l->z - c->z ;
  lenQ = 1.0f / (float) sqrt( v.x * v.x + v.y * v.y + v.z * v.z );
  v.x *= lenQ;
  v.y *= lenQ;
  v.z *= lenQ;

  // project v such that we get two values along each texture-coordinat axis.
  c->x = (s->x * v.x + s->y * v.y + s->z * v.z ) * MAX_EMBOSS;
  c->y = (t->x * v.x + t->y * v.y + t->z * v.z ) * MAX_EMBOSS;
}


// calculates v=vM, M is 4x4 in column-major, v is 4dim. row (i.e. "transposed")
void fxMistirassoni::VMatMult(matrix* M, vertex* v)
{
	vertex res;

	res.x  =  M->_11 * v->x + M->_12 * v->y + M->_13 * v->z + M->_14;
	res.y  =  M->_21 * v->x + M->_22 * v->y + M->_23 * v->z + M->_24;
	res.z  =  M->_31 * v->x + M->_32 * v->y + M->_33 * v->z + M->_34;

	v->x = res.x;
	v->y = res.y;
	v->z = res.z;
}


// Normalized dot product
vertex fxMistirassoni::ndp( vertex V1, vertex V2 )
{
	vertex N;

	N.x = V1.y * V2.z - V1.z * V2.y;
	N.y = V1.z * V2.x - V1.x * V2.z;
	N.z = V1.x * V2.y - V1.y * V2.x;
	float ND = 1.0f / (float) sqrt( N.x * N.x + N.y * N.y + N.z * N.z );
	N.x *= ND;
	N.y *= ND;
	N.z *= ND;

	return N;
}


/*
**	Plane implementation
*/

/*Plane::Plane( vertex P, vertex N )
{
}
	
bool Plane::ChkHit( vertex I )
{
	return true;
}
	
Plane::~Plane()
{
}

/*
**	Spline implementation
*/

/*Spline::Spline(vertex P0, vertex V0, vertex P1, vertex V1)
{
}

vertex Spline::GetSplinePos( float t )
{
	vertex P;

	return P;
}

bool Spline::ChkHit( Plane P )
{
	return true;
}


/*
**	Particle implementation
*/

/*Particle::Particle( vertex P0, vertex V0)
{
}

vertex Particle::GetPos( float t )
{
	vertex P;

	return P;
}

Particle::~Particle()
{
}

//*/