/* TEXT WRITER */
/* SoopaDoopa 2001 */

#include "eks4.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"

#define MBLURFRAMES 8
#define ALPHA 18

#define NTEXTSCREENS 8

#define FONT_SPACEX -2
#define FONT_SPACEY -6

extern char binary_font_start[];
extern char binary_font3_start[];
extern char binary_font_alpha_start[];

static int128	list[40];		//do not remove!!!???

static texture font;

typedef struct letterinfo
{
	int startx,starty;
	int endx,endy;
}letterinfo;

static letterinfo fontpos[256];

#define FONTHEIGHT 66

typedef struct sletter{
	float x,y;
	int c;
	float width;
	float t;
}sletter;

static sletter slist[NTEXTSCREENS][1024];
static int slistlength[NTEXTSCREENS];


static int emptycol(int x, int y)
{
	int t;
	
	for(t=0;t<FONTHEIGHT;t++)
		if(((((int32*)(font.image))[(y+t)*font.width+x])&0xff000000)!=((((int32*)(font.image))[0])&0xff000000))return 0;
//		if((int32*)(font.image)[(y+t)*font.width+x]!=(int32*)(font.image)[0])return 0;
//		if(((char*)(font.image))[(y+t)*font.width+x]!=((char*)(font.image))[0])return 0;

	return 1;
}

static void increase(int *x, int *y)
{
	(*x)++;
	if((*x)>=font.width)
	{
		(*y)+=FONTHEIGHT;
		(*x)=0;
	}

	while(*y>font.height-FONTHEIGHT)
	{
		setbgcolor(0xffffff);
	}
}

static void findletters()
{
	int t;
	int startx,endx;
	int ypos=0;
	int xpos=0;
	static char letters[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789.:,;-!#%&/()=?'*'^<>|";
	
	for(t=0;t<256;t++)
	{
		fontpos[t].startx=font.width-10;
		fontpos[t].starty=FONTHEIGHT*2;
		fontpos[t].endx=font.width;
		fontpos[t].endy=FONTHEIGHT*3;
	}

	t=0;
	while(letters[t])
	{
		while(emptycol(xpos,ypos))increase(&xpos,&ypos);
		
		startx=xpos;
		while(!emptycol(xpos,ypos))increase(&xpos,&ypos);
		endx=xpos;

		fontpos[letters[t]].startx=startx;
		fontpos[letters[t]].starty=ypos;
		fontpos[letters[t]].endx=endx;
		fontpos[letters[t]].endy=ypos+FONTHEIGHT;

		t++;
	}
}


static void putletter2(int c, float posx, float posy, float width, float height, int alpha)
{
	letterinfo info=fontpos[c];
	int x1=32000+(posx)*16;
	int y1=32000+(posy)*16;
	int x2=32000+(posx+width)*16;
	int y2=32000+(posy+height)*16;
	
	gif_env;
	
	dma_begingp();

	gif_tag(0xe,1,0,0,0);

	gSCISSOR_1(wwd(hhw(0,639),hhw(0,255)));	// x1,y1,x2,y2 - scissor window
	gPRMODECONT(1);				// refer to prim attributes
	gCOLCLAMP(1);
	gCLAMP_1(0);
	gCLAMP_1(0x1000010005);
	gALPHA_1(0x4000000048);
	gDTHE(0);				// Dither off

	gTEX0_1(texture_TEX0(font));
	gTEX1_1(1<<5);		//bilinear

	gTEST_1(0x30000);
	gPRIM(0x116+0x40);//+0x40);
	gPABE(0);
	gRGBAQ(0x3F80000000808080+(alpha<<24));		// Background RGBA
	gUV(hhw(info.startx*16,info.starty*16));
	gXYZ2(hhw(x1,y1));
	gUV(hhw(info.endx*16,info.endy*16));
	gXYZ2(hhw(x2,y2));
	gif_endfinal();

	dma_endgp();
}

static int initsletter(sletter *list, char *s, float x, float y)
{
	int i=0;
	float t=0;
	float x1=x;
	
	while(*s)
	{
		int c=*s;
		int width;
		c&=255;

		if(c=='\n')
		{
			x=x1;
			y+=FONTHEIGHT/2+FONT_SPACEY;
		}
		else if(c==' ')
		{
			x+=10;
		}
		else
		{
			width=fontpos[c].endx-fontpos[c].startx;
			t=i*3*2;

			list->x=x;
			list->y=y;
			list->c=c;
			list->t=t;
			list->width=width;
			x+=width+FONT_SPACEX;

			list++;
			i++;
		}
		s++;
	}
	return i;
}

void flyv1(float *x, float *y, float *z, float t1)
{
	float t;
	float s;

	s=1;

	if(t1<0.5)t=1;
	else
	{
		float a=1;

		if(t1>1){s=0.75;}
		if(t1>2)s=0.66;
		if(t1>2)s=0.0;


		t=s*sin2(a*t1*3.14159265);
	
	}

	if(t>0)t=-t;
	{
		float x1,y1;
		
		x1=*x;
		y1=*y;
		
		*x=(1+(2*t))* *x;
		*y=(1+(2*t))* *y;
	}

	(*z)+=1000*t;
}

void drawsletter(sletter *list, int i, float frames)
{
	while(frames>1800)frames-=1800;

	while(i>0)
	{
		float x,y,z;
		float t1;

		x=(list->x-320)*1000;
		y=(list->y-130)*1000;
		z=1000;

		t1=-0.006*(2*0.2*list->t-2*frames);

		flyv1(&x,&y,&z,t1);

		if(z>1000)
		{
			putletter2(list->c,list->x,list->y,list->width,FONTHEIGHT/2,ALPHA);
		}
		else
		if(z>220)
		{
			float a=1000/z;

			putletter2(list->c,x/z+320,y/z+130,list->width*(a),FONTHEIGHT/2*(a),ALPHA);
		}		
		
		list++;
		i--;
	}
}

void drawsletter2(sletter *list, int i, float frames)
{
	int t;
	
	for(t=0;t<MBLURFRAMES;t++)
	{
		drawsletter(list,i,frames);
		frames+=2.4/MBLURFRAMES;
	}
	
}

void eks4_init()
{
	texture_init(&font);
	texture_load(&font,binary_font_start);
	texture_loadalpha(&font,binary_font_alpha_start);

	findletters();

	slistlength[0]=initsletter(slist[0],"\n"
				      "               Presents\n"
				      "     a Playstation 2 production\n"
				      "     for the TRSAC demoparty\n"
				      "  in Copenhagen - October 2001\n"
				      "",130,64);

	slistlength[1]=initsletter(slist[1],"greetings: purple, fudge, prone, inf \n"
				      "alien prophets, mainloop, trsac crew \n"
				      "bypass, sunflower, orange, #tpolm, spb\n"
				      "moppi, se2k crew, echo^fdg, litewerx,\n"
				      "novocaine, loonies, rebels, deature\n",94,64+12);
 
	slistlength[2]=initsletter(slist[2],"\n"
				      "Coming up...\n"
				      "\n"
				      "                The Amazing\n"
				      "             80-splits Plasma\n"
				      "\n"
				      "",90,64);
	slistlength[3]=initsletter(slist[3],""
				      "This demo would probably have been even\n"
				      "better, had it not been for the loud\n"
				      "music the organizers organized for much\n"
				      "of the party! *hint* ;)\n"
				      "No more TP deja vues at TRSAC please!",90-10,64+12);
	slistlength[4]=initsletter(slist[4],"\n"
				      "Otherwise TRSAC is great! We will be\ncoming "
				      "back again!\n(Here comes that music again.. ;)\n"
				      ""
				      "And now, the official memberlist!\n"
				      "",90,64);
	slistlength[5]=initsletter(slist[5],"Sheriff - designer\n"
				      "   The Cake - coder\n"
				      "      Gibson - artist\n"
				      "         General Failure - coder\n"
				      "            Druckluft - coder\n"
				      "               Congo Jim - artist\n",90,64);
	slistlength[6]=initsletter(slist[6],"\n"
				      "\n"
				      "\n"
				      "        And now for the credits:\n"
				      "\n"
				      "\n",90,64);
}

void eks4_init2()
{
	texture_allocupload(&font);
}

void eks4_frame(float frames, int pagenum, int leavetime, int a)
{
	if(frames<leavetime)
		drawsletter2(slist[pagenum],slistlength[pagenum],frames);
	else
		drawsletter2(slist[pagenum],slistlength[pagenum],leavetime+a-frames);
}

void eks4_deinit()
{
}
