/*
 * Decompiled with CFR 0.152.
 */
public class RadialBlurSurface
extends Surface {
    int[] map = null;

    public RadialBlurSurface(int n, int n2, float f) {
        super(n, n2);
        this.map = this.createBlurMap(f);
    }

    public final void render() {
        int n;
        int n2 = super.getW() * super.getH();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = (this.buffer[n] & 0xFEFEFE) + (this.buffer[this.map[n]] & 0xFEFEFE) >> 1;
        }
        for (n = 0; n < n2; ++n) {
            this.buffer[n] = nArray[n] | 0xFF000000;
        }
    }

    final int[] createBlurMap(float f) {
        int n = super.getW() * super.getH();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = -super.getH() / 2; i < super.getH() / 2; ++i) {
            for (int j = -super.getW() / 2; j < super.getW() / 2; ++j) {
                double d = Math.sqrt(j * j + i * i);
                int n3 = (int)((double)((float)j * f) * d) / (super.getW() / 2);
                int n4 = (int)((double)((float)i * f) * d) / (super.getH() / 2);
                if (j < 0) {
                    n3 = -n3;
                }
                if (i < 0) {
                    n4 = -n4;
                }
                n4 += super.getH() / 2;
                if ((n3 += super.getW() / 2) < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n3 > super.getW() - 1) {
                    n3 = super.getW() - 1;
                }
                if (n4 > super.getH() - 1) {
                    n4 = super.getH() - 1;
                }
                nArray[n2++] = n3 + n4 * super.getW();
            }
        }
        return nArray;
    }
}

