/*
 * Decompiled with CFR 0.152.
 */
public class Matrix3 {
    protected float[][] m = new float[3][3];

    public final void zero() {
        this.m[2][2] = 0.0f;
        this.m[2][1] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[1][2] = 0.0f;
        this.m[1][1] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][1] = 0.0f;
        this.m[0][0] = 0.0f;
    }

    public final void identity() {
        this.m[2][1] = 0.0f;
        this.m[2][0] = 0.0f;
        this.m[1][2] = 0.0f;
        this.m[1][0] = 0.0f;
        this.m[0][2] = 0.0f;
        this.m[0][1] = 0.0f;
        this.m[2][2] = 1.0f;
        this.m[1][1] = 1.0f;
        this.m[0][0] = 1.0f;
    }

    public final Vector getRow(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return new Vector(this.m[n][0], this.m[n][1], this.m[n][2]);
    }

    public final Vector getColumn(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return new Vector(this.m[0][n], this.m[1][n], this.m[2][n]);
    }

    public static final Vector multiply(Matrix3 matrix3, Vector vector) {
        return new Vector(vector.v[0] * matrix3.m[0][0] + vector.v[1] * matrix3.m[0][1] + vector.v[2] * matrix3.m[0][2], vector.v[0] * matrix3.m[1][0] + vector.v[1] * matrix3.m[1][1] + vector.v[2] * matrix3.m[1][2], vector.v[0] * matrix3.m[2][0] + vector.v[1] * matrix3.m[2][1] + vector.v[2] * matrix3.m[2][2]);
    }

    public static final Matrix3 multiply(Matrix3 matrix3, Matrix3 matrix32) {
        Matrix3 matrix33 = new Matrix3();
        matrix33.m[0][0] = matrix3.m[0][0] * matrix32.m[0][0] + matrix3.m[0][1] * matrix32.m[1][0] + matrix3.m[0][2] * matrix32.m[2][0];
        matrix33.m[0][1] = matrix3.m[0][0] * matrix32.m[0][1] + matrix3.m[0][1] * matrix32.m[1][1] + matrix3.m[0][2] * matrix32.m[2][1];
        matrix33.m[0][2] = matrix3.m[0][0] * matrix32.m[0][2] + matrix3.m[0][1] * matrix32.m[1][2] + matrix3.m[0][2] * matrix32.m[2][2];
        matrix33.m[1][0] = matrix3.m[1][0] * matrix32.m[0][0] + matrix3.m[1][1] * matrix32.m[1][0] + matrix3.m[1][2] * matrix32.m[2][0];
        matrix33.m[1][1] = matrix3.m[1][0] * matrix32.m[0][1] + matrix3.m[1][1] * matrix32.m[1][1] + matrix3.m[1][2] * matrix32.m[2][1];
        matrix33.m[1][2] = matrix3.m[1][0] * matrix32.m[0][2] + matrix3.m[1][1] * matrix32.m[1][2] + matrix3.m[1][2] * matrix32.m[2][2];
        matrix33.m[2][0] = matrix3.m[2][0] * matrix32.m[0][0] + matrix3.m[2][1] * matrix32.m[1][0] + matrix3.m[2][2] * matrix32.m[2][0];
        matrix33.m[2][1] = matrix3.m[2][0] * matrix32.m[0][1] + matrix3.m[2][1] * matrix32.m[1][1] + matrix3.m[2][2] * matrix32.m[2][1];
        matrix33.m[2][2] = matrix3.m[2][0] * matrix32.m[0][2] + matrix3.m[2][1] * matrix32.m[1][2] + matrix3.m[2][2] * matrix32.m[2][2];
        return matrix33;
    }

    public static final Vector[] multiply(Matrix3 matrix3, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Matrix3.multiply(matrix3, vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Matrix3[] multiply(Matrix3 matrix3, Matrix3[] matrix3Array) {
        Matrix3[] matrix3Array2 = new Matrix3[matrix3Array.length];
        for (int i = 0; i < matrix3Array.length; ++i) {
            matrix3Array2[i] = Matrix3.multiply(matrix3, matrix3Array[i]);
        }
        return matrix3Array2;
    }

    public static final Vector[] multiply(Matrix3[] matrix3Array, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Matrix3.multiply(matrix3Array[i], vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Matrix3[] multiply(Matrix3[] matrix3Array, Matrix3[] matrix3Array2) {
        Matrix3[] matrix3Array3 = new Matrix3[matrix3Array2.length];
        for (int i = 0; i < matrix3Array2.length; ++i) {
            matrix3Array3[i] = Matrix3.multiply(matrix3Array[i], matrix3Array2[i]);
        }
        return matrix3Array3;
    }
}

