/* 									2001
  Local Library (ll) is a library produced for making applications
  a bit platform independent. 

  This is the Windows version. 

  Programmer: Kirkov
*/

#ifndef __LOCAL_LIBRARY__LL_
#define __LOCAL_LIBRARY__LL_

#include <windows.h>
#include <GL/gl.h>

#ifndef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION		0x0500
#endif
#include <dinput.h>

/* 2 ways handling events. */
#define LL_EVENT_WAIT	0
#define LL_EVENT_CHECK	1

/* All keys. */
#define LL_KEY_A		DIK_A
#define LL_KEY_B		DIK_B
#define LL_KEY_C		DIK_C
#define LL_KEY_D		DIK_D
#define LL_KEY_E		DIK_E
#define LL_KEY_F		DIK_F
#define LL_KEY_G		DIK_G
#define LL_KEY_H		DIK_H
#define LL_KEY_I		DIK_I
#define LL_KEY_J		DIK_J
#define LL_KEY_K		DIK_K
#define LL_KEY_L		DIK_L
#define LL_KEY_M		DIK_M
#define LL_KEY_N		DIK_N
#define LL_KEY_O		DIK_O
#define LL_KEY_P		DIK_P
#define LL_KEY_Q		DIK_Q
#define LL_KEY_R		DIK_R
#define LL_KEY_S		DIK_S
#define LL_KEY_T		DIK_T
#define LL_KEY_U		DIK_U
#define LL_KEY_V		DIK_V
#define LL_KEY_W		DIK_W
#define LL_KEY_X		DIK_X
#define LL_KEY_Y		DIK_Y
#define LL_KEY_Z		DIK_Z
#define LL_KEY_ENTER		DIK_RETURN
#define LL_KEY_ESC		DIK_ESCAPE
#define LL_KEY_END		DIK_END
#define LL_KEY_HOME		DIK_HOME
#define LL_KEY_PAGE_UP		DIK_PRIOR
#define LL_KEY_PAGE_DOWN	DIK_NEXT
#define LL_KEY_INSERT		DIK_INSERT
#define LL_KEY_DELETE		DIK_DELETE
#define LL_KEY_LEFT_CTRL	DIK_LCONTROL
#define LL_KEY_LEFT_SHIFT	DIK_LSHIFT
#define LL_KEY_ALT		DIK_LMENU
#define LL_KEY_RIGHT_CTRL	DIK_RCONTROL
#define LL_KEY_RIGHT_SHIFT	DIK_RSHIFT
#define LL_KEY_ALT_GR		DIK_RMENU
#define LL_KEY_SPACE		DIK_SPACE
#define LL_KEY_BREAK		DIK_PAUSE
#define LL_KEY_PRINT_SCREEN	DIK_SYSRQ
#define LL_KEY_CAPS_LOCK	DIK_CAPITAL
#define LL_KEY_NUM_LOCK		DIK_NUMLOCK
#define LL_KEY_SCROLL_LOCK	DIK_SCROLL
#define LL_KEY_0		DIK_0
#define LL_KEY_1		DIK_1
#define LL_KEY_2		DIK_2
#define LL_KEY_3		DIK_3
#define LL_KEY_4		DIK_4
#define LL_KEY_5		DIK_5
#define LL_KEY_6		DIK_6
#define LL_KEY_7		DIK_7
#define LL_KEY_8		DIK_8
#define LL_KEY_9		DIK_9
#define LL_KEY_TAB		DIK_TAB
#define LL_KEY_F1		DIK_F1
#define LL_KEY_F2		DIK_F2
#define LL_KEY_F3		DIK_F3
#define LL_KEY_F4		DIK_F4
#define LL_KEY_F5		DIK_F5
#define LL_KEY_F6		DIK_F6
#define LL_KEY_F7		DIK_F7
#define LL_KEY_F8		DIK_F8
#define LL_KEY_F9		DIK_F9
#define LL_KEY_F10		DIK_F10
#define LL_KEY_F11		DIK_F11
#define LL_KEY_F12		DIK_F12
#define LL_KEY_BACKSPACE	DIK_BACK
#define LL_KEY_DOTT				DIK_A
#define LL_KEY_COMMA				DIK_A
#define LL_KEY_PLUS				DIK_A
#define LL_KEY_MINUS				DIK_A
#define LL_KEY_LEFT		DIK_LEFT
#define LL_KEY_RIGHT		DIK_RIGHT
#define LL_KEY_UP		DIK_UP
#define LL_KEY_DOWN		DIK_DOWN
#define LL_KEY_KP_0		DIK_NUMPAD0
#define LL_KEY_KP_1		DIK_NUMPAD1
#define LL_KEY_KP_2		DIK_NUMPAD2
#define LL_KEY_KP_3		DIK_NUMPAD3
#define LL_KEY_KP_4		DIK_NUMPAD4
#define LL_KEY_KP_5		DIK_NUMPAD5
#define LL_KEY_KP_6		DIK_NUMPAD6
#define LL_KEY_KP_7		DIK_NUMPAD7
#define LL_KEY_KP_8		DIK_NUMPAD8
#define LL_KEY_KP_9		DIK_NUMPAD9
#define LL_KEY_KP_PLUS		DIK_ADD
#define LL_KEY_KP_MINUS		DIK_SUBTRACT
#define LL_KEY_KP_MULT		DIK_MULTIPLY
#define LL_KEY_KP_DIV		DIK_DIVIDE
#define LL_KEY_KP_ENTER		DIK_NUMPADENTER
#define LL_KEY_KP_DECIMAL	DIK_DECIMAL

/* Bits for buffers. Used in call co llCreateOpenGLWindow(). */
#define LL_FULLSCREEN			1
#define LL_DOUBLEBUFFER			2
#define LL_DEPTHBUFFER			4
#define LL_ACCUMULATIONBUFFER		8
#define LL_STENCILBUFFER		16

/* Return values from functions. */
#define LL_OK				0
#define LL_ERROR			1
#define LL_QUIT				2	/* Application should quit. Used by llCheckEvents(). */

/* Represent mouse buttons. */
#define LL_MOUSE_BUTTON_LEFT		1
#define LL_MOUSE_BUTTON_RIGHT		2


/* Things to check for keys. */
#define llKeyDown(x)		(llKeyTable[x] & 0x80)



/* Key state table. */
extern unsigned char *llKeyTable;



/* This will create a window and connect OpenGL to it. */
int llCreateOpenGLWindow(char *name,unsigned char mask,int xPos,int yPos,int width,int height);

/* Use this to remove the window and free as much memory as possible. */
void llKillOpenGLWindow(void);

/* Swap buffers if double buffering is used. */
void llSwapBuffers(void);

/* Get messages sent to our app. Update KB-table.*/
/* Return 0 if time to quit else 1. */
int llHandleEvents(int mode);

/* Mouse handling. Get state last time llHandleEvents() was called. */
short int llMouseGetXPos(void);
short int llMouseGetYPos(void);

/* Get button stats. */
unsigned char llMouseButtonDown(unsigned char button);
unsigned char llMouseButtonPressed(unsigned char button);

/* Set mouse position (0,0) is middle of window. */
void llMouseSetPosition(short int x,short int y);
void llMouseSetHome(short int x,short int y);

/* Returns current time, milliseconds. */
unsigned long llGetTime();
/* Brake execution if needed. Brake if not 'time' has passed since last call. */
void llBrake(unsigned long time);

#endif
