/* 									2001
  Local Library (ll) is a library produced for making applications
  a bit platform independent. 

  This is the linux X version. 

  Programmer: Kirkov
*/

#ifndef __LOCAL_LIBRARY__LL_
#define __LOCAL_LIBRARY__LL_


   /*####################################################################
   # Defines								#
   ####################################################################*/

/* 2 ways handling events. */
#define LL_EVENT_WAIT	0
#define LL_EVENT_CHECK	1

/* All keys. */
#define LL_KEY_A		38
#define LL_KEY_B		56
#define LL_KEY_C		54
#define LL_KEY_D		40
#define LL_KEY_E		26
#define LL_KEY_F		41
#define LL_KEY_G		42
#define LL_KEY_H		43
#define LL_KEY_I		31
#define LL_KEY_J		44
#define LL_KEY_K		45
#define LL_KEY_L		46
#define LL_KEY_M		58
#define LL_KEY_N		57
#define LL_KEY_O		32
#define LL_KEY_P		33
#define LL_KEY_Q		24
#define LL_KEY_R		27
#define LL_KEY_S		39
#define LL_KEY_T		28
#define LL_KEY_U		30
#define LL_KEY_V		55
#define LL_KEY_W		25
#define LL_KEY_X		53
#define LL_KEY_Y		29
#define LL_KEY_Z		52
#define LL_KEY_ENTER		36
#define LL_KEY_ESC		9
#define LL_KEY_END		103
#define LL_KEY_HOME		97
#define LL_KEY_PAGE_UP		99
#define LL_KEY_PAGE_DOWN	105
#define LL_KEY_INSERT		106
#define LL_KEY_DELETE		107
#define LL_KEY_LEFT_CTRL	37
#define LL_KEY_LEFT_SHIFT	50
#define LL_KEY_ALT		64
#define LL_KEY_RIGHT_CTRL	109
#define LL_KEY_RIGHT_SHIFT	62
#define LL_KEY_ALT_GR		113
#define LL_KEY_SPACE		65
#define LL_KEY_BREAK			0
#define LL_KEY_PRINT_SCREEN		0
#define LL_KEY_CAPS_LOCK	66
#define LL_KEY_NUM_LOCK		77
#define LL_KEY_SCROLL_LOCK		0
#define LL_KEY_0		19
#define LL_KEY_1		10
#define LL_KEY_2		11
#define LL_KEY_3		12
#define LL_KEY_4		13
#define LL_KEY_5		14
#define LL_KEY_6		15
#define LL_KEY_7		16
#define LL_KEY_8		17
#define LL_KEY_9		18
#define LL_KEY_TAB		23
#define LL_KEY_F1		67
#define LL_KEY_F2		68
#define LL_KEY_F3		69
#define LL_KEY_F4		70
#define LL_KEY_F5		71
#define LL_KEY_F6		72
#define LL_KEY_F7		73
#define LL_KEY_F8		74
#define LL_KEY_F9		75
#define LL_KEY_F10		76
#define LL_KEY_F11		95
#define LL_KEY_F12		96
#define LL_KEY_BACKSPACE	22
#define LL_KEY_DOTT		60
#define LL_KEY_COMMA		59
#define LL_KEY_PLUS			0
#define LL_KEY_MINUS			0
#define LL_KEY_LEFT		100
#define LL_KEY_RIGHT		102
#define LL_KEY_UP		98
#define LL_KEY_DOWN		104
/*#define LL_KEY_
#define LL_KEY_
#define LL_KEY_
#define LL_KEY_
#define LL_KEY_
#define LL_KEY_
#define LL_KEY_
*/
#define LL_KEY_KP_0		90
#define LL_KEY_KP_1		87
#define LL_KEY_KP_2		88
#define LL_KEY_KP_3		89
#define LL_KEY_KP_4		83
#define LL_KEY_KP_5		84
#define LL_KEY_KP_6		85
#define LL_KEY_KP_7		79
#define LL_KEY_KP_8		80
#define LL_KEY_KP_9		81
#define LL_KEY_KP_PLUS		86
#define LL_KEY_KP_MINUS		82
#define LL_KEY_KP_MULT		63
#define LL_KEY_KP_DIV		112
#define LL_KEY_KP_ENTER		108
#define LL_KEY_KP_DECIMAL	91

/* Bits for buffers. Used in call co llCreateOpenGLWindow(). */
#define LL_FULLSCREEN			1
#define LL_DOUBLEBUFFER			2
#define LL_DEPTHBUFFER			4
#define LL_ACCUMULATIONBUFFER		8
#define LL_STENCILBUFFER		16

/* Return values from functions. */
#define LL_OK				0
#define LL_ERROR			1
#define LL_QUIT				2	/* Application should quit. Used by llCheckEvents(). */

/* Represent mouse buttons. */
#define LL_MOUSE_BUTTON_LEFT		1
#define LL_MOUSE_BUTTON_RIGHT		2


   /*####################################################################
   # Macros								#
   ####################################################################*/

/* Things to check for keys. */
#define llKeyDown(x)		(llKeyTable[x] & 0x01)
#define llKeyPressed(x)		(llKeyTable[x] & 0x02)


   /*####################################################################
   # Globals								#
   ####################################################################*/

/* Holds state for all keys on keyboard. This is a global declared in 'll.h'.
   For further information view the declaration in 'll.h'. */
extern unsigned char *llKeyTable;


   /*####################################################################
   # Function prototypes						#
   ####################################################################*/

/* This will create a window and connect OpenGL to it. */
int llCreateOpenGLWindow(char *name,unsigned char mask,int xPos,int yPos,int width,int height);

/* Swap buffers if double buffering is used. */
void llSwapBuffers(void);

/* This will check for important events that the envirnoment have send to us. */
int llHandleEvents(int mode);

/* Mouse handling. Get state last time llHandleEvents() was called. */
short int llMouseGetXPos(void);
short int llMouseSetYPos(void);
/* Set mouse position (0,0) is middle of window. */
void llMouseSetPosition(short int x,short int y);
void llMouseSetHome(short int x,short int y);

unsigned char llMouseButtonDown(unsigned char button);
unsigned char llMouseButtonPressed(unsigned char button);

/* Returns current time, milliseconds. */
unsigned long llGetTime();
/* Brake execution if needed. Brake if not 'time' has passed since last call. */
void llBrake(unsigned long time);


#endif
