; SB16 driver for raw32/nasm by mogyi/MCL

segment code32 use32

%define SBDRV 0
%include "raw32.inc"
%include "sbdrv.inc"
%include "dma.inc"

db "SB16 driver by <oSiRiS>"
;----------------------------------------------------------------------------
SB_detect:
; detect SB16
                     mov word [SBbase],210h
SB_detect_loop:
                     call SB_resetDSP
                     jnc SB_detect_found
                     add word [SBbase],10h
                     cmp word [SBbase],290h
                     jnz SB_detect_loop
SB_detect_notfound:
                     stc
                     ret
SB_detect_found:
                     call SB_getDSPversion ; SB16s DSP ver. above 4.0
                     cmp ah,4
                     jb SB_detect_notfound
;----------------------------------------------------------------------------
                     mov fs,[envsel]       ; search for BLASTER environment
                     xor ebx,ebx
SB_detect_envstr_loop:
                     mov esi,ebx
                     cmp word [fs:esi],0
                     jz near SB_detect_no_envstr
                     mov edi,envstring
                     mov ecx,8
                     fs repz cmpsb
                     jz SB_detect_envstr_ok
                     inc ebx
                     jmp short SB_detect_envstr_loop
;----------------------------------------------------------------------------
SB_detect_envstr_ok:                       ; search for A (base port)
                     fs lodsb
                     cmp al,0
                     jz SB_detect_envstr_s_no_A
                     cmp al,"a"
                     jz SB_detect_envstr_A
                     cmp al,"A"
                     jnz SB_detect_envstr_ok
SB_detect_envstr_A:
                     xor bx,bx
                     mov ah,"0"
                     fs lodsb
                     call SB_char2nmb
                     mov bh,bl
                     fs lodsb
                     mov ah,al
                     fs lodsb
                     call SB_char2nmb

                     cmp bx,[SBbase]
                     jz SB_detect_envstr_s_no_A
                     push word [SBbase]
                     mov [SBbase],bx
                     call SB_resetDSP
                     pop bx
                     jnc SB_detect_envstr_A_skip
                     mov [SBbase],bx
SB_detect_envstr_A_skip:
;----------------------------------------------------------------------------
SB_detect_envstr_s_no_A:                   ; search for I (IRQ)
                     fs lodsb
                     cmp al,0
                     jz SB_detect_envstr_s_no_I
                     cmp al,"i"
                     jz SB_detect_envstr_I
                     cmp al,"I"
                     jnz SB_detect_envstr_s_no_A
SB_detect_envstr_I:
                     mov ah,"0"
                     fs lodsb
                     call SB_char2nmb
                     mov [SBirq],bl
;----------------------------------------------------------------------------
SB_detect_envstr_s_no_I:                   ; search for H (16-bit DMA)
                     fs lodsb
                     cmp al,0
                     jz SB_detect_envstr_s_no_H
                     cmp al,"h"
                     jz SB_detect_envstr_H
                     cmp al,"H"
                     jnz SB_detect_envstr_s_no_I
SB_detect_envstr_H:
                     mov ah,"0"
                     fs lodsb
                     call SB_char2nmb
                     mov [SBdma],bl
;----------------------------------------------------------------------------
SB_detect_envstr_s_no_H:

SB_detect_no_envstr:
                     clc
                     ret
;----------------------------------------------------------------------------
SB_char2nmb:
; convert ax char to bl number
                     sub ah,30h
                     cmp ah,10
                     jb SB_char2nmb_skip
                     sub ah,7
SB_char2nmb_skip:
                     mov bl,ah
                     shl bl,4

                     sub al,30h
                     cmp al,10
                     jb SB_char2nmb_skip2
                     sub al,7
SB_char2nmb_skip2:
                     and al,15
                     or bl,al
                     ret
;----------------------------------------------------------------------------
SB_resetDSP:
; reset SB DSP
                     mov dx,[SBbase]
                     mov al,1
                     add dx,6
                     out dx,al

                     mov ecx,100
SB_resetDSP_preloop:
                     in al,dx
                     loop SB_resetDSP_preloop

                     xor al,al
                     out dx,al

                     add dx,8
                     mov ecx,1000
SB_resetDSP_loop:
                     in al,dx
                     and al,80h
                     jz SB_resetDSP_skip

                     sub dx,4
                     in al,dx
                     add dx,4
                     cmp al,0AAh
                     jz SB_resetDSP_ok
SB_resetDSP_skip:
                     loop SB_resetDSP_loop
                     stc
                     ret
SB_resetDSP_ok:
                     clc
                     ret
;----------------------------------------------------------------------------
SB_writeDSP:
; write to the DSP
                     mov ah,al
                     mov dx,[SBbase]
                     add dx,0Ch
SB_writeDSP_loop:
                     in al,dx
                     and al,80h
                     jnz SB_writeDSP_loop

                     mov al,ah
                     out dx,al
                     ret
;----------------------------------------------------------------------------
SB_readDSP:
; read from the DSP
                     mov dx,[SBbase]
                     add dx,0Eh
SB_readDSP_loop:
                     in al,dx
                     and al,80h
                     jz SB_readDSP_loop

                     sub dx,4
                     in al,dx
                     ret
;----------------------------------------------------------------------------
SB_startoutput:
; IN: esi = IRQ procedure
; start SB output
                     mov [IRQ_procedure],esi

                     call SB_resetDSP
                     jc near SB_startoutput_error
                     mov al,0D1h       ; turn on speaker
                     call SB_writeDSP

                     mov edx,[DMA_buffer]
                     add edx,[code32a]
                     mov al,dl
                     and eax,0fh
                     shr edx,4
                     mov ebx,edx
                     shl ebx,4
                     add ebx,eax

                     mov al,00011000b ; (singled transfer,forward,autoinit,read)
                     mov ah,[SBdma]
                     mov ecx,[SBdma_lgt]
                     call DMA_setup

                     mov bl,[SBirq]
                     cmp bl,8
                     jb SB_startoutput_skip1
                     add bl,68h
SB_startoutput_skip1:
                     add bl,8
                     clc
                     call getvect
                     mov [SB_oldIRQ_sel],cx
                     mov [SB_oldIRQ_offs],edx

                     cli
                     in al,21h
                     and al,80h
                     out 21h,al

                     mov bl,[SBirq]
                     cmp bl,8
                     jb SB_startoutput_skip2
                     add bl,68h
SB_startoutput_skip2:
                     add bl,8
                     mov cx,cs
                     mov edx,SB_IRQ
                     clc
                     call setvect

                     in al,21h
                     and al,7Fh
                     out 21h,al
                     sti

                     mov al,41h        ; set frequency
                     call SB_writeDSP
                     mov al,[SBfreq+1] ; high
                     call SB_writeDSP
                     mov al,[SBfreq]   ; low
                     call SB_writeDSP

                     mov al,10110110b ; command (16bit,DAC,auto-init,FIFO enabled)
                     call SB_writeDSP
                     mov al,00110000b ; mode (stereo,signed)
                     call SB_writeDSP
                     mov al,0h        ; DMA transfer 2x
                     call SB_writeDSP
                     mov al,40h       ; DMA transfer 2x
                     call SB_writeDSP
                     clc
                     ret
SB_startoutput_error:
                     stc
                     jmp exit
                     ret
;----------------------------------------------------------------------------
SB_stopoutput:
; stop SB output
                     mov al,0D3h
                     call SB_writeDSP  ; turn off speaker
                     mov al,0D5h
                     call SB_writeDSP  ; halt DMA op. 16-bit
                     mov al,0D9h       ; exit auto-initialize DMA op. 16-bit
                     call SB_writeDSP
                     mov al,0D5h       ; halt DMA op. 16-bit
                     call SB_writeDSP

                     cli
                     in al,21h
                     and al,80h
                     out 21h,al

                     mov bl,[SBirq]
                     cmp bl,8
                     jb SB_stopoutput_skip
                     add bl,68h
SB_stopoutput_skip:
                     add bl,8
                     mov cx,[SB_oldIRQ_sel]
                     mov edx,[SB_oldIRQ_offs]
                     clc
                     call setvect

                     in al,21h
                     and al,80h
                     out 21h,al
                     sti
                     ret
;----------------------------------------------------------------------------
SB_oldIRQ_sel dw 0
SB_oldIRQ_offs dd 0
SB_IRQ:
                     pushad
                     pushf

                     mov dx,[SBbase]
                     add dx,0Fh        ; DSP 16-bit acknowledge port
                     in al,dx          ; acknowledge DSP interrupt (16 bit)

                     mov eax,[IRQ_procedure]
                     call dword eax

                     mov al,020h
                     out 020h,al

                     popf
                     popad
                     iret
;----------------------------------------------------------------------------
SB_getDSPversion:
; get DSP version
; AH = major, AL = minor version
                     mov al,0E1h
                     call SB_writeDSP
                     call SB_readDSP
                     mov ah,al
                     call SB_readDSP
                     ret
;----------------------------------------------------------------------------
SB_getDSPcopyright:
; DSP copyright
                     mov al,0E3h
                     call SB_writeDSP
                     mov edi,SB_DSPcopystring
SB_getDSPcopyright_loop:
                     call SB_readDSP
                     stosb
                     cmp al,0
                     jz SB_getDSPcopyright_end
                     cmp edi,SB_DSPcopystring+48
                     jnz SB_getDSPcopyright_loop
SB_getDSPcopyright_end:
                     ret
;----------------------------------------------------------------------------
SBbase dw 220
SBirq db 5
SBdma db 5

SBdma_lgt dd 65536
DMA_buffer dd 0

SBfreq dw 45454
SB_DSPcopystring times 48 db 0

envstring db "BLASTER="

IRQ_procedure dd 0



