; 3D rotation with matrice

segment code32 use32

%define ROTATE3D

%include "3Drotate.inc"
%include "3Dengine.inc"
%include "raw32.inc"
%include "nasmmacr.inc"

;----------------------------------------------------------------------------
rotate.dot:
                     mov   esi,[alpha]
                     mov   edi,[beta]
                     mov   ebp,[gamma]
;----------------------------------------------------------------------------
; X matrix
                     ; xx=c2*c1
                     ; xy=c2*s1
                     ; xz=s2

                     mov   eax,[costable+edi*4]
                     imul  eax,D [costable+esi*4]
                     sar   eax,15
                     mov   [matrix.xx],eax

                     mov   eax,[costable+edi*4]
                     imul  eax,D [sintable+esi*4]
                     sar   eax,15
                     mov   [matrix.xy],eax

                     mov   eax,[sintable+edi*4]
                     mov   [matrix.xz],eax
;----------------------------------------------------------------------------
; Y matrix
                     ; yx=c3*s1+s3*s2*c1
                     ; yy=-c3*c1+s3*s2*s1
                     ; yz=-s3*c2

                     mov   eax,[costable+ebp*4]
                     imul  eax,D [sintable+esi*4]
                     sar   eax,15

                     mov   ebx,[sintable+ebp*4]
                     mov   ecx,[sintable+edi*4]
                     mov   edx,[costable+esi*4]
                     imul  ebx,ecx
                     sar   ebx,15
                     imul  ebx,edx
                     sar   ebx,15

                     add   eax,ebx
                     mov   [matrix.yx],eax

                     mov   eax,[costable+ebp*4]
                     neg   eax
                     imul  eax,D [costable+esi*4]
                     sar   eax,15

                     mov   ebx,[sintable+ebp*4]
                     mov   ecx,[sintable+edi*4]
                     mov   edx,[sintable+esi*4]
                     imul  ebx,ecx
                     sar   ebx,15
                     imul  ebx,edx
                     sar   ebx,15

                     add   eax,ebx
                     mov   [matrix.yy],eax

                     mov   eax,[sintable+ebp*4]
                     neg   eax
                     imul  eax,D [costable+edi*4]
                     sar   eax,15
                     mov   [matrix.yz],eax
;----------------------------------------------------------------------------
; Z matrix
                     ; zx=s3*s1-c3*s2*c1;s2*c1+c3*s1
                     ; zy=-s3*c1-c3*s2*s1;c3*c1-s2*s1
                     ; zz=c3*c2

                     mov   eax,[sintable+ebp*4]
                     imul  eax,D [sintable+esi*4]
                     sar   eax,15

                     mov   ebx,[costable+ebp*4]
                     mov   ecx,[sintable+edi*4]
                     mov   edx,[costable+esi*4]
                     imul  ebx,ecx
                     sar   ebx,15
                     imul  ebx,edx
                     sar   ebx,15

                     sub   eax,ebx
                     mov   [matrix.zx],eax

                     mov   eax,[sintable+ebp*4]
                     neg   eax
                     imul  eax,D [costable+esi*4]
                     sar   eax,15

                     mov   ebx,[costable+ebp*4]
                     mov   ecx,[sintable+edi*4]
                     mov   edx,[sintable+esi*4]
                     imul  ebx,ecx
                     sar   ebx,15
                     imul  ebx,edx
                     sar   ebx,15

                     sub   eax,ebx
                     mov   [matrix.zy],eax

                     ;mov   eax,[sintable+edi*4]
                     ;imul  eax,D [costable+esi*4]
                     ;sar   eax,15
                     ;
                     ;mov   ebx,[costable+ebp*4]
                     ;imul  ebx,D [sintable+esi*4]
                     ;sar   ebx,15
                     ;
                     ;add   eax,ebx
                     ;mov   [matrix.zx],eax
                     ;
                     ;mov   eax,[costable+ebp*4]
                     ;imul  eax,D [costable+esi*4]
                     ;sar   eax,15
                     ;
                     ;mov   ebx,[sintable+edi*4]
                     ;imul  ebx,D [sintable+esi*4]
                     ;sar   ebx,15
                     ;
                     ;sub   eax,ebx
                     ;mov   [matrix.zy],eax

                     mov   eax,[costable+ebp*4]
                     imul  eax,D [costable+edi*4]
                     sar   eax,15
                     mov   [matrix.zz],eax
;----------------------------------------------------------------------------
; calculate new coordinates from matrix
                     ;  x''=xx * x + xy * y + xz * z
                     ;  y''=yx * x + yy * y + yz * z
                     ;  z''=zx * x + zy * y + zz * z

                     movsx eax,W [x]
                     movsx ebx,W [y]
                     movsx ecx,W [z]
                     imul  eax,D [matrix.xx]
                     imul  ebx,D [matrix.xy]
                     imul  ecx,D [matrix.xz]
                     sar   eax,15
                     sar   ebx,15
                     sar   ecx,15
                     add   eax,ebx
                     add   eax,ecx
                     mov   [x2],ax

                     movsx eax,W [x]
                     movsx ebx,W [y]
                     movsx ecx,W [z]
                     imul  eax,D [matrix.yx]
                     imul  ebx,D [matrix.yy]
                     imul  ecx,D [matrix.yz]
                     sar   eax,15
                     sar   ebx,15
                     sar   ecx,15
                     add   eax,ebx
                     add   eax,ecx
                     mov   [y2],ax

                     movsx eax,W [x]
                     movsx ebx,W [y]
                     movsx ecx,W [z]
                     imul  eax,D [matrix.zx]
                     imul  ebx,D [matrix.zy]
                     imul  ecx,D [matrix.zz]
                     sar   eax,15
                     sar   ebx,15
                     sar   ecx,15
                     add   eax,ebx
                     add   eax,ecx
                     mov   [z2],ax
;----------------------------------------------------------------------------
                     ret
;----------------------------------------------------------------------------
x   dw 0
y   dw 0
z   dw 0
x2  dw 0
y2  dw 0
z2  dw 0
;----------------------------------------------------------------------------
matrix
      .xx  dd 0
      .xy  dd 0
      .xz  dd 0
      .yx  dd 0
      .yy  dd 0
      .yz  dd 0
      .zx  dd 0
      .zy  dd 0
      .zz  dd 0
;----------------------------------------------------------------------------
sintable times 128 dd 0
costable times 512 dd 0
;----------------------------------------------------------------------------









