//-----------------------------------------------------------------  
// render.cpp
// main D3D operation performed here
// coded by keus  & captainfr 09/07/2000 at party place
//-----------------------------------------------------------------

#include "export.h"
#include "LoadTLD.h"
#include "CityPart.h"
//#include "Particle.h"
#include "LogoTLD.h"
#include "Door.h"
#include "DlyrGFX.h"
#include "loading1.h"
#include "easybass.h"
#include "Greets2.h"
#include "credit.h"

int safe;

CLoading Load;

CLogoTLD  Logo;
CCityPart City;
CDlyrGFX DGFX;
CDoor Porte;
CGreets Greets;
Ccredit Credits;
bool FirstInit = FALSE;

int CurrentPart = 0;

// init all demo part
HRESULT App_InitDeviceObjects( LPDIRECT3DDEVICE7 pd3dDevice)
{
	////////////////////////////////////////////////////
   // D3D INITIALISATION 
  ////////////////////////////////////////////////////
    D3DMATRIX mat;
	D3DUtil_SetIdentityMatrix(mat);
    D3DMATRIX matWorld = mat;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );
    D3DMATRIX matView = mat;
    matView._43 = 15.0f;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );
    D3DMATRIX matProj = mat;
    matProj._11 =  2.0f;
    matProj._22 =  2.0f;
    matProj._34 =  1.0f;
    matProj._43 = -1.0f;
    matProj._44 =  0.5f;
	//funy shit //D3DUtil_SetProjectionMatrix(matProj, float(3.1415/1.15), 4/3, 1.01f, 200000.0f);
	//D3DUtil_SetProjectionMatrix(matProj, float(43.4558), 800/600, 1.01f, 200000.0f);
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );
   
	pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT,    0xffffffff );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_ONE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_ONE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, FALSE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_ADDRESS,   D3DTADDRESS_CLAMP );

	if( FAILED(Load.Init(pd3dDevice) ) )
		return E_FAIL;
	CurrentPart = 666;


    pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
    return S_OK;
}


// called every frame to move objects
HRESULT App_FrameMove( LPDIRECT3DDEVICE7 pd3dDevice, FLOAT fTimeKey )
{

	if ( FirstInit)
	{
		if( FAILED(Logo.Init(pd3dDevice) ) )
			return E_FAIL;
		if( FAILED(City.Init(pd3dDevice) ) )
			return E_FAIL;
		if( FAILED(Porte.Init(pd3dDevice) ) )
			return E_FAIL;
		if( FAILED(DGFX.Init(pd3dDevice) ) )
			return E_FAIL;
		if( FAILED(Greets.Init(pd3dDevice) ) )
			return E_FAIL;
		if( FAILED(Credits.Init(pd3dDevice) ) )
			return E_FAIL;


		Logo.ReInit(pd3dDevice);
		CurrentPart = 0;
		FirstInit = FALSE;
		BassFree();
		BassInit();
		BassLoadMusic("Fdre.xm");
		BassStartPlaying(LOOP);
	}


	safe++;
	if(Touche(VK_F4))
	{
		if(safe > 7)
		{
			CurrentPart++;
			if (CurrentPart == 1)
				City.ReInit(pd3dDevice);
			if (CurrentPart == 2)
				Porte.ReInit(pd3dDevice);
			if (CurrentPart == 3)
				DGFX.ReInit(pd3dDevice);
			if (CurrentPart == 4)
				Greets.ReInit(pd3dDevice);
			if (CurrentPart == 5)
				Credits.ReInit(pd3dDevice);
			safe = 0;
		}

	}

	// 1st part
	if (CurrentPart == 0)
	{
		bool truc = Logo.FrameMove(pd3dDevice, fTimeKey);
		if (truc == TRUE)
		{
			CurrentPart++;
			City.ReInit(pd3dDevice);
		}

	}

	//2nd part
	if (CurrentPart == 1)
	{
		bool truc = City.FrameMove(pd3dDevice, fTimeKey);
		if (truc == TRUE)
		{
			CurrentPart++;
			// 3rd part RE-init
			Porte.ReInit(pd3dDevice);
		}

	}

	
	//3rd part
	if (CurrentPart == 2)
	{
		bool truc = Porte.FrameMove(pd3dDevice, fTimeKey);
		if (truc == TRUE)
		{
			CurrentPart++;
			// 4th part RE-init
			DGFX.ReInit(pd3dDevice);
		}

	}



	//4th part
	if (CurrentPart == 3)
	{
		bool truc = DGFX.FrameMove(pd3dDevice, fTimeKey);
		if (truc == TRUE)
		{
			CurrentPart++;
			// 4th part RE-init
			Greets.ReInit(pd3dDevice);
		}

	}

	//5th part
	if (CurrentPart == 4)
	{
		bool truc = Greets.FrameMove(pd3dDevice, fTimeKey);
		if (truc == TRUE)
		{
			CurrentPart++;
			// 5th part RE-init
		Credits.ReInit(pd3dDevice);
		}

	}

	//6th part
	if (CurrentPart == 5)
	{
		bool truc = Credits.FrameMove(pd3dDevice, fTimeKey);
		if (truc == TRUE)
		{
			CurrentPart++;
			// 5th part RE-init
		}

	}

    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: App_Render()
// Desc: Renders the scene. 
//-----------------------------------------------------------------------------
HRESULT App_Render( LPDIRECT3DDEVICE7 pd3dDevice )
{
    // Clear the viewport and z-buffer
    pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER,
                       0x00000000, 1.0f, 0L );
   


    if( FAILED( pd3dDevice->BeginScene() ) )
        return E_FAIL;

	
	// 1st part
	if (CurrentPart == 0)
		Logo.Render(pd3dDevice);
	// 2nd part
	if (CurrentPart == 1)
		City.Render(pd3dDevice);
	// 3rd part
	if (CurrentPart == 2)
		Porte.Render(pd3dDevice);
	// 4th part
	if (CurrentPart == 3)
		DGFX.Render(pd3dDevice);
    //5 part
	if (CurrentPart == 4)
		Greets.Render(pd3dDevice);
    //6 part
	if (CurrentPart == 5)
		Credits.Render(pd3dDevice);
	if (CurrentPart == 666)
	{
		Load.Render(pd3dDevice);
	    
	}

    pd3dDevice->EndScene();

	if(CurrentPart == 666)
	{
		FirstInit = TRUE;
		//CurrentPart = 0;
	}

    return S_OK;
}

// delete device dependant objects
VOID App_DeleteDeviceObjects( LPDIRECT3DDEVICE7 pd3dDevice )
{
}

void App_FinalCleanUp()
{
}
