///////////////////////////////////////////////////////////////////////
// cod par klang (je crois qu'il a surtout copi sur le sdk de bass
// donc c poa grave .. hein klang ?
///////////////////////////////////////////////////////////////////////

#include "easybass.h"

HMUSIC BassMod;
HSTREAM BassStream;

BOOL BassMono=FALSE;
bool play_ok=true;

void BassError(char *text) 
{
	MessageBox(NULL,text,"Bass Error",MB_OK);
	BASS_Free();
}

bool BassInit()
{

	/* check that BASS 0.8 was loaded */
	if (BASS_GetVersion()!=MAKELONG(0,8))
	{
		BassError("BASS version 0.8 was not loaded");
		play_ok=false;
		return false;
	}

	/* setup output - default device, 44100hz, stereo, 16 bits */
	if (!BASS_Init(-1,44100,0,GetForegroundWindow()))
	{
		BassError("Can't initialize device");
		play_ok=false;
		return false;
	}

	return true;
}

bool BassLoadMusic(char *filename)
{
	/* try streaming the file */
	if (BassStream=BASS_StreamCreateFile(FALSE,filename,0,0,0))
	{
		/* check if the stream is mono (for the level indicator) */
		BassMono=BASS_ChannelGetFlags(BassStream)&BASS_SAMPLE_MONO;
	}
	else
	{
		/* load the MOD (with looping and normal ramping) */
		if (!(BassMod=BASS_MusicLoad(FALSE,filename,0,0,BASS_MUSIC_LOOP|BASS_MUSIC_RAMP)))
			/* not a MOD either */
			{
				BassError("Can't load the file");
				play_ok=false;
				return false;
			}
	}
	return true;
}

	

bool BassStartPlaying(int flagada)
{
	if(play_ok)
	{
		if(!BASS_Start())
		{
			BassError("Can't start playing...");
			return false;
		}
			
		if (BassStream)
			if(flagada==LOOP)
				BASS_StreamPlay(BassStream,FALSE,BASS_SAMPLE_LOOP);
			else
				BASS_StreamPlay(BassStream,FALSE,0);
		else
			if(flagada==LOOP)
				BASS_MusicPlayEx(BassMod,0,BASS_MUSIC_LOOP | BASS_MUSIC_FT2MOD,TRUE);
			else
				BASS_MusicPlayEx(BassMod,0,BASS_MUSIC_FT2MOD,TRUE);
	}

	return true;
}

void BassFree()
{
	BASS_Free();
}