// Sprite3d.cpp: implementation of the CSprite3d class.
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////

#include "Sprite3d.h"
#include "texture.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSprite3d::CSprite3d()
{

}

CSprite3d::~CSprite3d()
{

}

void CSprite3d::Init(LPDIRECT3DDEVICE7 pd3dDevice, char* Filename, RECT Rect)
{
    m_lpSurf = LoadJPGTexture( pd3dDevice, Filename);

	float bottom = float (Rect.bottom);
	float top    = float (Rect.top);
	float left   = float (Rect.left);
	float right  = float (Rect.right);
	D3DVECTOR vNormal = D3DVECTOR( 0.0f, 0.0f, -1.0f);
	m_Sprite[3]= D3DVERTEX( D3DVECTOR(left,  top,    0.0f), -vNormal, 0.0f, 0.0f);
	m_Sprite[4]= D3DVERTEX( D3DVECTOR(left,  bottom, 0.0f), -vNormal, 0.0f, 1.0f);
	m_Sprite[5]= D3DVERTEX( D3DVECTOR(right, bottom, 0.0f), -vNormal, 1.0f, 1.0f);
	m_Sprite[0]= D3DVERTEX( D3DVECTOR(left,  top,    0.0f), -vNormal, 0.0f, 0.0f);
	m_Sprite[1]= D3DVERTEX( D3DVECTOR(right, top,    0.0f), -vNormal, 1.0f, 0.0f);
	m_Sprite[2]= D3DVERTEX( D3DVECTOR(right, bottom, 0.0f), -vNormal, 1.0f, 1.0f);
}


void CSprite3d::Initf(LPDIRECT3DDEVICE7 pd3dDevice, char* Filename, float left, float top, float right, float bottom)
{
    m_lpSurf = CreateTexture( pd3dDevice, Filename);

	D3DVECTOR vNormal = D3DVECTOR( 0.0f, 0.0f, -1.0f);
	m_Sprite[3]= D3DVERTEX( D3DVECTOR(left,  top,    0.0f), -vNormal, 0.0f, 0.0f);
	m_Sprite[4]= D3DVERTEX( D3DVECTOR(left,  bottom, 0.0f), -vNormal, 0.0f, 1.0f);
	m_Sprite[5]= D3DVERTEX( D3DVECTOR(right, bottom, 0.0f), -vNormal, 1.0f, 1.0f);
	m_Sprite[0]= D3DVERTEX( D3DVECTOR(left,  top,    0.0f), -vNormal, 0.0f, 0.0f);
	m_Sprite[1]= D3DVERTEX( D3DVECTOR(right, top,    0.0f), -vNormal, 1.0f, 0.0f);
	m_Sprite[2]= D3DVERTEX( D3DVECTOR(right, bottom, 0.0f), -vNormal, 1.0f, 1.0f);
}


void CSprite3d::Move(float left, float top, float right, float bottom)
{
	D3DVECTOR vNormal = D3DVECTOR( 0.0f, 0.0f, -1.0f);
	m_Sprite[3]= D3DVERTEX( D3DVECTOR(left,  top,    0.0f), -vNormal, 0.0f, 0.0f);
	m_Sprite[4]= D3DVERTEX( D3DVECTOR(left,  bottom, 0.0f), -vNormal, 0.0f, 1.0f);
	m_Sprite[5]= D3DVERTEX( D3DVECTOR(right, bottom, 0.0f), -vNormal, 1.0f, 1.0f);
	m_Sprite[0]= D3DVERTEX( D3DVECTOR(left,  top,    0.0f), -vNormal, 0.0f, 0.0f);
	m_Sprite[1]= D3DVERTEX( D3DVECTOR(right, top,    0.0f), -vNormal, 1.0f, 0.0f);
	m_Sprite[2]= D3DVERTEX( D3DVECTOR(right, bottom, 0.0f), -vNormal, 1.0f, 1.0f);
}

void CSprite3d::MoveTBL(float z)
{
	m_Sprite[3].dvZ += z;
	m_Sprite[4].dvZ += z;
	m_Sprite[5].dvZ += z;
	m_Sprite[0].dvZ += z;
	m_Sprite[1].dvZ += z;
	m_Sprite[2].dvZ += z;
}

void CSprite3d::MoveZ(float left, float top, float right, float bottom, float z)
{
	D3DVECTOR vNormal = D3DVECTOR( 0.0f, 0.0f, -1.0f);
	m_Sprite[3]= D3DVERTEX( D3DVECTOR(left,  top,    z), -vNormal, 0.0f, 0.0f);
	m_Sprite[4]= D3DVERTEX( D3DVECTOR(left,  bottom, z), -vNormal, 0.0f, 1.0f);
	m_Sprite[5]= D3DVERTEX( D3DVECTOR(right, bottom, z), -vNormal, 1.0f, 1.0f);
	m_Sprite[0]= D3DVERTEX( D3DVECTOR(left,  top,    z), -vNormal, 0.0f, 0.0f);
	m_Sprite[1]= D3DVERTEX( D3DVECTOR(right, top,    z), -vNormal, 1.0f, 0.0f);
	m_Sprite[2]= D3DVERTEX( D3DVECTOR(right, bottom, z), -vNormal, 1.0f, 1.0f);
}


void CSprite3d::Render(LPDIRECT3DDEVICE7 pd3dDevice)
{

	D3DMATRIX mat,matView,matWorld;
    pd3dDevice->GetTransform( D3DTRANSFORMSTATE_VIEW,  &matView );
    pd3dDevice->GetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );

	D3DUtil_SetIdentityMatrix(mat);
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &mat );
    mat._43 = 15.0f;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &mat );

	pd3dDevice->SetTexture( 0, m_lpSurf);
	pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP,D3DFVF_VERTEX ,
                               m_Sprite, 6, 0 );
	pd3dDevice->SetTexture( 0, NULL);

	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW,  &matView );
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );

}


void CSprite3d::Release()
{
	if (m_lpSurf) m_lpSurf->Release();
}

