// Implementation of a class that allow you to manage 3D Objects
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////
#define D3D_OVERLOADS


#include "TLDutils.h"
#include "D3DUtil.h"
#include "AlphaLayer.h"



////////////////////////////////////////////////////////////////////
// scale Obj
////////////////////////////////////////////////////////////////////
void CAlphaLayer::Scale(float x,float y,float z)
{
	D3DVERTEX* ScaledObj;
	D3DMATRIX mat;
	D3DUtil_SetScaleMatrix( mat, x, y, z);

	ScaledObj = new D3DVERTEX[m_NbObjVertex];
	for(int i=0;i<m_NbObjVertex;i++)
	{
		D3DVERTEX vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( ScaledObj[i], vTemp, mat);
	}

	UpdateFVB(ScaledObj);
	delete [] ScaledObj;
}

////////////////////////////////////////////////////////////////////
// translate Obj
////////////////////////////////////////////////////////////////////
void CAlphaLayer::SetTranslate(float x,float y,float z)
{
	D3DVERTEX* TranslatedObj;
	TranslatedObj = new D3DVERTEX[m_NbObjVertex];

	for(int i=0;i<m_NbObjVertex;i++)
	{
		TranslatedObj[i] = FakeVertexBuffer[i];
		TranslatedObj[i].dvX += x;
		TranslatedObj[i].dvY += y;
		TranslatedObj[i].dvZ += z;
	}

	UpdateFVB(TranslatedObj);
	delete [] TranslatedObj;
}


///////////////////////////////////////////////////////////////////////
// set up rotation for OBJ
///////////////////////////////////////////////////////////////////////
void CAlphaLayer::SetRotate(float x,float y,float z)
{
	D3DMATRIX matX,matY,matZ;
	D3DUtil_SetRotateXMatrix(matX,x);
	D3DUtil_SetRotateYMatrix(matY,y);
	D3DUtil_SetRotateZMatrix(matZ,z);
	
	/*D3DVERTEX vTemp;
	for(int i=0;i<m_NbObjVertex;i++)
	{
		vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( Obj[i], vTemp, matX);
	}
	for(i=0;i<m_NbObjVertex;i++)
	{
		vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( Obj[i], vTemp, matY);
	}
	for(i=0;i<m_NbObjVertex;i++)
	{
		vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( Obj[i], vTemp, matZ);
	}

	UpdateVB(Obj);*/

	D3DMATRIX matTemp;
	D3DMath_MatrixMultiply(matTemp,matX,matY);
	D3DMath_MatrixMultiply(matRotate,matTemp,matZ);

}


///////////////////////////////////////////////////////////////////////
// set up rotation for OBJ rotate the Obj in the Buffer
///////////////////////////////////////////////////////////////////////
void CAlphaLayer::SetRotateBuffer(float x,float y,float z)
{
	D3DMATRIX matX,matY,matZ;
	D3DUtil_SetRotateXMatrix(matX,x);
	D3DUtil_SetRotateYMatrix(matY,y);
	D3DUtil_SetRotateZMatrix(matZ,z);
	
	D3DVERTEX vTemp;
	for(int i=0;i<m_NbObjVertex;i++)
	{
		vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( Obj[i], vTemp, matX);
	}
	for(i=0;i<m_NbObjVertex;i++)
	{
		vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( Obj[i], vTemp, matY);
	}
	for(i=0;i<m_NbObjVertex;i++)
	{
		vTemp = Obj[i];
		D3DMath_VertexMatrixMultiply( Obj[i], vTemp, matZ);
	}

	UpdateFVB(Obj);

}