// LoadTLD.cpp: implementation of the CLoadTLD class.
// coded by keus juin 2000
//////////////////////////////////////////////////////////////////////
#include "LoadTLD.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLoadTLD::CLoadTLD()
{
	CameraLoaded = FALSE;
	Pause = FALSE;
}

CLoadTLD::~CLoadTLD()
{
	delete [] SceneMtrl;
}

HRESULT CLoadTLD::Init(LPDIRECT3DDEVICE7 pd3dDevice, char* TLDFileName)
{
	MatDef TempMat[30];
	int NbMat = 0;

	LoadObjects(pd3dDevice,TLDFileName);

	char temp[50];
	char TextureFileName[260];
	sprintf(TextureFileName,"%sDEF",TLDFileName);
	TextureFile = fopen(TextureFileName,"r");
	if (!TextureFile)
		MessageBox(NULL,"couldn't open the def file","z",MB_OK);
	while(!feof(TextureFile))
	{
		fscanf(TextureFile,"%s",&temp);
		if (strcmp(temp,"Material") == 0)
		{
			LoadMat(TextureFile,TempMat[NbMat]);
			NbMat++;
		}
	}
	fclose(TextureFile);
	//sprintf(temp,"Nbmat %d",NbMat);
	//MessageBox(NULL,temp,"z",MB_OK);
	


	SceneMtrl = new Material[NbObj];
	//Scene = new CAlphaLayer[NbObj];
	for(int i=0;i<NbObj;i++)
	{
		int repere = 0; bool blop = FALSE;
		while(!blop)
		{
			if (repere > NbMat) 
			{
				char fileError[256];
				sprintf(fileError,"%s not found",Scene[i].TextureFileName);
				MessageBox(NULL,fileError,"z",MB_OK);
			}
			if (strcmp(Scene[i].TextureFileName,TempMat[repere].name) == 0)
				blop = TRUE;
			else repere++;
		}

		SceneMtrl[i].m_lpText = CreateTexture(pd3dDevice,TempMat[repere].TextureFilename);
		if(TempMat[repere].Displacement == TRUE)
			Scene[i].ApplyDisplacement(pd3dDevice,TempMat[repere].DisplacementFilename);
	}


////////////////////////////////////////////////////
// D3D INITIALISATION 
////////////////////////////////////////////////////
    D3DMATRIX mat;
	D3DUtil_SetIdentityMatrix(mat);
    D3DMATRIX matWorld = mat;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );
    D3DMATRIX matView = mat;
    matView._43 = 15.0f;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );
    D3DMATRIX matProj = mat;
    matProj._11 =  2.0f;
    matProj._22 =  2.0f;
    matProj._34 =  1.0f;
    matProj._43 = -1.0f;
    matProj._44 =  0.5f;
	//funy shit //D3DUtil_SetProjectionMatrix(matProj, float(3.1415/1.15), 4/3, 1.01f, 200000.0f);
	//D3DUtil_SetProjectionMatrix(matProj, float(43.4558), 800/600, 1.01f, 200000.0f);
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );
   
	pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT,    0xffffffff );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_ONE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_ONE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, FALSE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );
    pd3dDevice->SetTextureStageState( 0, D3DTSS_ADDRESS,   D3DTADDRESS_CLAMP );

	return S_OK;
}

bool CLoadTLD::FrameMove(LPDIRECT3DDEVICE7 pd3dDevice, FLOAT fTimeKey)
{
	if (!Pause)
		Camera.MoveCamera2(pd3dDevice,fTimeKey);
	if (Touche(VK_F1)) Pause = TRUE;
	if (Touche(VK_F2)) Pause = FALSE;


	return FALSE;
}

HRESULT CLoadTLD::Render(LPDIRECT3DDEVICE7 pd3dDevice)
{
	for(int i=0;i<NbObj;i++)
	{
		//if (SceneMtrl[i].Alpha)
		//		pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
		pd3dDevice->SetTexture( 0, SceneMtrl[i].m_lpText);
		Scene[i].RenderVB(pd3dDevice,FALSE);
		//if (SceneMtrl[i].Alpha)
		//		pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE );

	}
	pd3dDevice->SetTexture( 0, NULL);

	return S_OK;
}


void CLoadTLD::ReInit(LPDIRECT3DDEVICE7 pd3dDevice)
{
    pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT, D3DRGB( 1,1,1) );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, TRUE );
	fTimeDebut = timeGetTime() * 0.001f;

	Camera.fFirstTimeKey = timeGetTime() * 0.001f;

    pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );

    // Turn on fog
    FLOAT fFogStart =  700.0f;
    FLOAT fFogEnd   = 1000.0f;
    //pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGENABLE,    TRUE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGCOLOR, D3DRGB(0.02f,0.02f,0.02f));
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGTABLEMODE, D3DFOG_NONE );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGVERTEXMODE,  D3DFOG_LINEAR );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGSTART, *((DWORD *)(&fFogStart)) );
    pd3dDevice->SetRenderState( D3DRENDERSTATE_FOGEND,   *((DWORD *)(&fFogEnd)) );


}


void CLoadTLD::Release()
{
}


void CLoadTLD::LoadObjects(LPDIRECT3DDEVICE7 pd3dDevice,char *TLDFileName)
{
	char temp[260];
	float truc;
	int CurrentObj = 0;
	hFile = fopen(TLDFileName,"r");
	fscanf(hFile,"%f",&truc);
	fscanf(hFile,"%f",&truc);
	fscanf(hFile,"%f",&truc);

	while(!feof(hFile))
	{
		fscanf(hFile,"%s",&temp);
		if (strcmp(temp,"Object") == 0)
		{
			fscanf(hFile,"%s",&temp);
			fscanf(hFile,"%s",Scene[CurrentObj].TextureFileName);
			Scene[CurrentObj].LoadObjectO(pd3dDevice,hFile,temp);
			CurrentObj++;
		}
		if (strcmp(temp,"Camera") == 0)
		{
			if (!CameraLoaded)
				Camera.SLoadCamera("merde",hFile);
			CameraLoaded = TRUE;
		}

	}
	fclose(hFile);
	NbObj = CurrentObj;

	for (int i=0;i<NbObj;i++)
	{
		Scene[i].CreateVertexBuffer(pd3dDevice);
		Scene[i].UpdateVB(Scene[i].Obj);
	}
}


void CLoadTLD::LoadMat(FILE* hFile,MatDef& Mat)
{
	char temp[260];
	// scan mat name
	fscanf(hFile,"%s",&Mat.name);
	// scan mat type
	fscanf(hFile,"%s",&temp);
	// check what's comming next
	fscanf(hFile,"%s",&temp);
	if(strcmp(temp,"EndMaterial") == 0)
		return;
	else
	{
		fscanf(hFile,"%s",&temp);
		//fscanf(hFile,"%s",&temp);
		fscanf(hFile,"%s",&Mat.TextureFilename);
	}

	// check what's comming next
	fscanf(hFile,"%s",&temp);
	if(strcmp(temp,"EndMaterial") == 0)
	{
		/*char debug[260];
		sprintf(debug,"mat stats:\nname:%s\ntext filename:%s",Mat.name,Mat.TextureFilename);
		MessageBox(NULL,debug,"z",MB_OK);*/
		return;
	}
	else
	{
		Mat.Displacement = TRUE;
		fscanf(hFile,"%s",&temp);
		//fscanf(hFile,"%s",&temp);
		fscanf(hFile,"%s",&Mat.DisplacementFilename);
		fscanf(hFile,"%s",&temp);
	}
	/*char debug[260];
	sprintf(debug,"mat stats:\nname:%s\ntext filename:%s",Mat.name,Mat.TextureFilename);
	MessageBox(NULL,debug,"z",MB_OK);*/
}