// D3DDemo.cpp: implementation of the CD3DDemo class.
//
//////////////////////////////////////////////////////////////////////

#include "D3DDemo.h"
#include "export.h"


///local proto
HRESULT WINAPI EnumZBufferCallback( DDPIXELFORMAT* pddpf,VOID* pddpfDesired );


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CD3DDemo::CD3DDemo()
{

}

CD3DDemo::~CD3DDemo()
{

}

HRESULT CD3DDemo::Init(HWND hWnd)
{
	HRESULT hr;

	GUID*           pDriverGUID;
	GUID*           pDeviceGUID;
	DDSURFACEDESC2* pMode;
	BOOL            bUsing3DHardware;
	GetSelectedDriver( &pDriverGUID, &pDeviceGUID, &pMode, &g_bWindowed,
		               &bUsing3DHardware );

	hr = DirectDrawCreateEx( pDriverGUID, (VOID**)&g_pDD, IID_IDirectDraw7, 
		                     NULL );
	if( FAILED( hr ) )
		return hr;

    // Query DirectDraw for access to Direct3D
    g_pDD->QueryInterface( IID_IDirect3D7, (VOID**)&g_pD3D );
    if( FAILED( hr) )
		return hr;

	if( g_bWindowed )
		hr = g_pDD->SetCooperativeLevel( hWnd, DDSCL_NORMAL );
	else
		hr = g_pDD->SetCooperativeLevel( hWnd, DDSCL_FULLSCREEN|DDSCL_EXCLUSIVE );
	if( FAILED( hr ) )
		return hr;

	if( FALSE == g_bWindowed )
	{
		hr = g_pDD->SetDisplayMode( pMode->dwWidth, pMode->dwHeight,
			                        pMode->ddpfPixelFormat.dwRGBBitCount,
								    pMode->dwRefreshRate, 0L );
		if( FAILED( hr ) )
			return hr;
	}

	DDSURFACEDESC2 ddsd;
	ZeroMemory( &ddsd, sizeof(DDSURFACEDESC2) );
	ddsd.dwSize = sizeof(DDSURFACEDESC2);

	if( g_bWindowed )
	{
		ddsd.dwFlags        = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	}
	else
	{
		ddsd.dwFlags           = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps    = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | 
			                     DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;
		ddsd.dwBackBufferCount = 1;
	}


	// Create the primary surface.
	hr = g_pDD->CreateSurface( &ddsd, &g_pddsPrimary, NULL );
	if( FAILED( hr ) )
		return hr;

	if( g_bWindowed )
	{
		LPDIRECTDRAWCLIPPER pcClipper;
		hr = g_pDD->CreateClipper( 0, &pcClipper, NULL );
		if( FAILED( hr ) )
			return hr;

		pcClipper->SetHWnd( 0, hWnd );
		g_pddsPrimary->SetClipper( pcClipper );
		pcClipper->Release();
	}

	if( g_bWindowed )
	{
		ddsd.dwFlags        = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_3DDEVICE;

		GetClientRect( hWnd, &g_rcScreenRect );
		ClientToScreen( hWnd, (POINT*)&g_rcScreenRect.left );
		ClientToScreen( hWnd, (POINT*)&g_rcScreenRect.right );
		ddsd.dwWidth  = g_rcScreenRect.right - g_rcScreenRect.left;
		ddsd.dwHeight = g_rcScreenRect.bottom - g_rcScreenRect.top;

		hr = g_pDD->CreateSurface( &ddsd, &g_pddsBackBuffer, NULL );
		if( FAILED( hr ) )
			return hr;
	}
	else
	{
		SetRect( &g_rcScreenRect, 0, 0, pMode->dwWidth, pMode->dwHeight );

	    DDSCAPS2 ddscaps = { DDSCAPS_BACKBUFFER, 0, 0, 0 };
		hr = g_pddsPrimary->GetAttachedSurface( &ddscaps, &g_pddsBackBuffer );
		if( FAILED( hr ) )
			return hr;
	}

	DDPIXELFORMAT ddpfZBuffer;
	g_pD3D->EnumZBufferFormats( *pDeviceGUID, EnumZBufferCallback, 
		                        (VOID*)&ddpfZBuffer );

    if( sizeof(DDPIXELFORMAT) != ddpfZBuffer.dwSize )
        return E_FAIL;

    ddsd.dwFlags        = DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT|DDSD_PIXELFORMAT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER;
	ddsd.dwWidth        = g_rcScreenRect.right - g_rcScreenRect.left;
	ddsd.dwHeight       = g_rcScreenRect.bottom - g_rcScreenRect.top;
    memcpy( &ddsd.ddpfPixelFormat, &ddpfZBuffer, sizeof(DDPIXELFORMAT) );

	// For hardware devices, the z-buffer should be in video memory. For
	// software devices, create the z-buffer in system memory
	if( IsEqualIID( *pDeviceGUID, IID_IDirect3DHALDevice ) )
		ddsd.ddsCaps.dwCaps |= DDSCAPS_VIDEOMEMORY;
	else
		ddsd.ddsCaps.dwCaps |= DDSCAPS_SYSTEMMEMORY;

    if( FAILED( hr = g_pDD->CreateSurface( &ddsd, &g_pddsZBuffer, NULL ) ) )
		return hr;

    if( FAILED( hr = g_pddsBackBuffer->AddAttachedSurface( g_pddsZBuffer ) ) )
		return hr;

	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	g_pDD->GetDisplayMode( &ddsd );
	if( ddsd.ddpfPixelFormat.dwRGBBitCount <= 8 )
		return DDERR_INVALIDMODE;


    if( FAILED( hr = g_pD3D->CreateDevice( *pDeviceGUID,
		                                   g_pddsBackBuffer,
                                           &g_pd3dDevice ) ) )
	{
		return hr;
	}

    // Create the viewport
	DWORD dwRenderWidth  = g_rcScreenRect.right - g_rcScreenRect.left;
	DWORD dwRenderHeight = g_rcScreenRect.bottom - g_rcScreenRect.top;
	D3DVIEWPORT7 vp = { 0, 0, dwRenderWidth, dwRenderHeight, 0.0f, 1.0f };
    hr = g_pd3dDevice->SetViewport( &vp );
	if( FAILED( hr ) )
		return hr;


	return S_OK;
}


HRESULT WINAPI EnumZBufferCallback( DDPIXELFORMAT* pddpf,
                                           VOID* pddpfDesired )
{
	// For this tutorial, we are only interested in z-buffers, so ignore any
	// other formats (e.g. DDPF_STENCILBUFFER) that get enumerated. An app
	// could also check the depth of the z-buffer (16-bit, etc,) and make a
	// choice based on that, as well. For this tutorial, we'll take the first
	// one we get.
    if( pddpf->dwFlags == DDPF_ZBUFFER )
    {
        memcpy( pddpfDesired, pddpf, sizeof(DDPIXELFORMAT) );

        // Return with D3DENUMRET_CANCEL to end the search.
		return D3DENUMRET_CANCEL;
    }

    // Return with D3DENUMRET_OK to continue the search.
    return D3DENUMRET_OK;
}