// DECLARES:

#ifndef (Debug)
  #declare Debug = true; // Wanna get output on all the variables?
#end
#ifndef (Up)
  #declare Up = z; // A unit vector of what is up.
#end
#ifndef (R)
  #declare R = seed(0);   // Random Variable.
#end       
#ifndef (Layers)
  #declare Layers = 40;   // Number of layers in blob.
#end       
#ifndef (Density)
  #declare Density = 0.2; // Blobdensity (Max = 5, Min > 0, 0.01 = High Density, 5 = Low Density).
#end       
#ifndef (StartRad)
  #declare StartRad = 1;  // The blobs radius at the floor.
#end       
#ifndef (EndRad)
  #declare EndRad = 2;  // The blobs max radius.
#end                                         
#ifndef (Strength)
  #declare Strength = 0.5;  // The blob strength.
#end                                         
#ifndef (Movement)
  #declare Movement = <0.2,0.2,0.2>; // Random movement within the squirt.
#end
#ifndef (SphereSize)
  #declare SphereSize = 0.05;  // Size of each sphere.
#end          
#ifndef (HeightClock)
  #declare HeightClock = (0.75*pi); // The development of the squirt using sinus (Not good for animation).                               
#end
#ifndef (WidthClock)
  #declare WidthClock = (0.5*pi); // The development of the width of the squirt using sinus (Not good for animation).                               
#end             
#ifndef (Height)
  #declare Height = 1; // The height of the blob.
#end
#ifndef (TiltAmount)
  #declare TiltAmount = 0; // Amount of tilting - in degrees.
#end
#ifndef (TiltVector)
  #declare TiltVector = <0,0>; // A 2d vector which decides in what direction the blob is tilting - seen from above.
#end

// Brag

#if (Debug = true)
  #debug "\n*************************************"
  #debug "\n* WaterSquirt v1.0 by Pelle Coltau. *"
  #debug "\n*************************************"
#end

// FATAL ERRORS

#if (Layers < 1)
  #error "\nLayer variable has to be lager than zero!! Termination is inevitable.\n"
#end
#if (Density <= 0)
  #error "\nDensity smaller than zero creates endless loops.\n"
#end
             
// VARIABLES

#declare Num = 1;     
#declare Rot = 0;
#declare SphNum = 0;

#if (TiltVector.x = 0)
  #if (TiltVector.y = 0)
    #if (TiltAmount != 0)
      #declare TiltAmount = 0;
    #end
  #end
#end

// DEBUG

#if (Debug = true)
  #debug        "\n------------------------------------------"
  #debug concat("\nLayers                         : ",str(Layers,0,3))
  #debug concat("\nDensity                        : ",str(Density,0,3))
  #debug concat("\nStartRad                       : ",str(StartRad,0,3))
  #debug concat("\nEndRad                         : ",str(EndRad,0,3))
  #debug concat("\nStrength                       : ",str(Strength,0,3))
  #debug concat("\nHeightClock                    : ",str(HeightClock,0,3))
  #debug concat("\nWidthClock                     : ",str(WidthClock,0,3))
  #debug concat("\nHeight                         : ",str(Height,0,3))  
  #debug concat("\nUp                             : (",str(Up.x,0,0),",",str(Up.y,0,0),",",str(Up.z,0,0),")")
  #debug concat("\nMovement                       : (",str(Movement.x,0,3),",",str(Movement.y,0,3),",",str(Movement.z,0,3),")")
  #debug concat("\nTiltVector                     : (",str(TiltVector.x,0,3),",",str(TiltVector.y,0,3),")")
  #debug concat("\nTiltAmount                     : ",str(TiltAmount,0,3))  
  #debug        "\n------------------------------------------"
#end

// OBJECT

#declare Deg = 0;

#if (TiltAmount != 0)
  #if (TiltVector.x*TiltVector.y = 0)
    #declare Deg = 270;
    #if (TiltVector.x < 0)
      #declare Deg = 90;
    #end
  #end
  #if (TiltVector.x = 0)
    #declare Deg = 180; 
    #if (TiltVector.y < 0)
      #declare Deg = 0; 
    #end
  #end
  #if (TiltVector.x != 0)
    #if (TiltVector.y != 0)
      #declare Deg = ((degrees(acos((TiltVector.x*TiltVector.y)/(vlength(TiltVector)+sqrt(abs(TiltVector.x))))))-(degrees(asin((TiltVector.x*TiltVector.y)/(vlength(TiltVector)+sqrt(abs(TiltVector.x)))))))+180;
      #if (TiltVector.x < 0)        
        #declare Deg = Deg - 180;
      #end
    #end
  #end
#end

#declare WaterSquirt =
  blob {
    threshold 0.6
    #while (Num <= Layers)
      #while (Rot > 360) 
        #declare Rot = Rot -360;
      #end
      #while (Rot < 360)
        sphere { 0, SphereSize-(Num/Layers)*(SphereSize/2), Strength      
          translate ((rand(R)*Movement)-(Movement/2))
          translate x*((sin(Num/(Layers)*WidthClock)*(EndRad-StartRad))+StartRad)
          rotate y*Rot                                                            
          rotate x*TiltAmount*(Num/Layers)
          rotate y*Deg
          translate y*(sin((Num/Layers)*HeightClock)*Height)
        }
        #declare Rot = Rot + (rand(R)*0.1+Density)*Num;
        #declare SphNum = SphNum + 1;
      #end
      #declare Num = Num + 1;
    #end            
  #if (Up.z = 1)
    rotate x*90
  #end
  #if (Up.x = 1)
    rotate z*90
  #end
  }                 

// End debug

#if (Debug = true)
  #debug concat("\nNumber of spheres in SquirtBlob: ",str(SphNum,0,0))
  #debug        "\n------------------------------------------\n"
#end          

// WARNINGS 

#if (Density > 5)
  #warning "\nDensity should be larger than zero and smaller than 5."
#end
#if (StartRad < 0)
  #warning "\nStartRad should be larger than zero.\n"
#end
#if (EndRad < 0)
  #warning "\nEndRad should be larger than zero.\n"
#end
#if (StartRad > EndRad)
  #warning "\nEndRad should be larger than StartRad.\n"
#end
#if (Strength < 0)
  #warning "\nStrength should be larger than zero.\n"
#end
#if (Strength > 1)
  #warning "\nStrength should be smaller than one.\n"
#end
#if (Strength > 180)
  #warning "\nStrength should be smaller than 180 degrees.\n"
#end
#if (Strength < -180)
  #warning "\nStrength should be larger than -180 degrees.\n"
#end
#if (TiltVector.x = 0)
  #if (TiltVector.y = 0)
    #if (TiltAmount != 0)
      #warning "\nTiltAmount is set (not zero) and the TiltVector is not (0,0). TiltAmount is set to zero.\n"
    #end
  #end
#end
