// *************
// ** Objects **
// *************

#declare Floor = height_field {
  png "WaveHf.png"
  scale <30,2,25>
  smooth
  translate <-15,-0.75,-5>
  texture { Water } 
  interior { ior 1.33 }
  hollow
}
  
#declare Ra = seed(1);
           
#declare MeteorRock01 = union {
  #declare ti = 0;
  #while (ti < 500)
    box { <0.2,0.2,0.2>, <-0.2,-0.2,-0.2>
      translate <rand(Ra)*2-1,rand(Ra)*2-1,rand(Ra)*2-1>
      rotate <rand(Ra)*360,rand(Ra)*360,rand(Ra)*360>
    }
    #declare ti = ti + 1;
  #end          
  scale <1.5,1,1>
  texture { Rock scale 0.1 }
} 

#declare MeteorRock02 = union {
  #declare ti = 0;
  #while (ti < 300)
    box { <0.2,0.2,0.2>, <-0.2,-0.2,-0.2>
      translate <rand(Ra)*2-1,rand(Ra)*2-1,rand(Ra)*2-1>
      rotate <rand(Ra)*360,rand(Ra)*360,rand(Ra)*360>
    }
    #declare ti = ti + 1;
  #end          
  scale <1.5,1,1>
  texture { Rock scale 0.1 }
} 

   
#declare Meteor01 = union {
  object { Smoke01 rotate -z*60 translate <0.8,0.7,0> }
  object { Smoke02 rotate -z*60 translate <0.8,0.7,0> }
  object { MeteorRock01 scale 0.5 rotate z*30 }
  object { MeteorFire01 scale <1.75,1,1.75> translate x*0.4 rotate z*30 }
  object { MeteorFire02 scale <1,1,1.5>   translate x*-0.5 rotate z*30 }
  object { MeteorDust01 scale <1.5,1,1.5>*1.2   translate x*0.25 rotate z*30 }
}

#declare Meteor02 = union {
  object { Smoke01 scale 0.9 rotate -z*60 translate <0.8,0.7,0> }
  object { Smoke02 scale 0.9 rotate -z*60 translate <0.8,0.7,0> }
  object { MeteorRock01 scale 0.3 rotate z*30 }
  object { MeteorFire01 scale <1.2,0.66,1.2> translate x*0.3 rotate z*30 }
  object { MeteorFire02 scale <0.66,0.66,1>   translate x*-0.25 rotate z*30 }
  object { MeteorDust01 scale <1,0.66,1>   translate x*0.25 rotate z*30 }
}

#declare Meteor03 = union {
  object { Smoke01 rotate -z*55 translate <0.8,0.7,0> }
  object { Smoke02 rotate -z*55 translate <0.8,0.7,0> }
  object { MeteorRock02 scale 0.5 rotate z*30 }
  object { MeteorFire01 scale <1.75,1,1.5> translate x*0.5 rotate z*35 }
  object { MeteorFire02 scale <1,1,1.5>   translate x*-0.25 rotate z*30 }    
  object { MeteorDust01 scale <1.5,1,1.5>   translate x*0.25 rotate z*30 }
}

#declare Meteor04 = union {
  object { Smoke01 rotate -z*50 translate <0.8,0.7,0> }
  object { Smoke02 rotate -z*50 translate <0.8,0.7,0> }
  object { MeteorRock01 scale 0.375 rotate z*30 }
  object { MeteorFire01 scale <1.5,1,1.5>*0.8 translate x*0.2 rotate z*30 }
  object { MeteorFire02 scale <1,1,1.5>*0.8   translate x*-0.5 rotate z*30 }
  object { MeteorDust01 scale <1,1,1.5>   translate x*-0.5 rotate z*30 }
}

#declare Hills = height_field { tga "hf_08.tga" smooth scale <350,300,2000> texture { HillsTex } }

#declare Shore = difference {
  height_field { tga "hf_13.tga" scale <10,3,7> smooth translate z*-3.5 rotate x*9.9
  translate <-5,0.275,-4.0> }
  object { Floor }
  texture { ShoreSand scale 0.05 } 
}

#declare WaterBed = union { 
  object { Floor }
  object { Floor translate <0,0,25> }
  object { Floor translate <-30,0,0> }
  object { Floor translate <30,0,0> }
  object { Floor translate <-30,0,25> }
  object { Floor translate <30,0,25> }
}

#declare Sky = sky_sphere {
  pigment {
    granite
    color_map {
      [0.00 color rgb<0.000, 0.000, 0.000>]
      [0.80 color rgb<0.000, 0.000, 0.000>]
      [0.85 color rgb<0.500, 0.500, 0.500>]
      [0.90 color rgb<0.400, 0.400, 0.400>]
      [0.90 color rgb<0.000, 0.000, 0.000>]
      [1.00 color rgb<0.000, 0.000, 0.000>]
    }
  }                                          
  scale 0.01
}

#declare WaterSquirt01 = object { 
  WaterSquirtTmp01 
  texture { Water }  
  interior { ior 1.33 }
  translate <-4.15,0,10>
} 

  
#declare WaterSquirt02 = object { 
  WaterSquirtTmp02
  texture { Water }  
  interior { ior 1.33 }
  translate <4.8,0,20>
}                 

#declare Flag = union {
  cylinder { 
    <0,0,0>, <0,0.5,0>, 0.01 
    pigment { color <0.52,0.37,0.26>*0.75 } 
  }
  box { 
    <0.5,0.5,0.01>, <-0.5,-0.5,-0.01> 
    pigment {
      image_map {
        png "sign2.png"
      }            
      translate <0.5,0.5,0> 
    }   
    normal { 
      bumps 0.8  
      scale 0.1 
    }          
    finish {    
      ambient 0.05
      roughness 0.4
    }
    scale <0.25,0.15,0.15>*0.9
    translate <0.13,0.42,0>
  }
} 

// **** End of file ****