/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.opengl;

import org.komplex.opengl.GL;
import org.komplex.opengl.GLConstants;
import org.komplex.opengl.GLJDirect;
import org.komplex.opengl.GLUquadricObj;

public class GLU
implements GLConstants {
    public static final int GLU_SMOOTH = 100000;
    public static final int GLU_FLAT = 100001;
    public static final int GLU_NONE = 100002;
    public static final int GLU_POINT = 100010;
    public static final int GLU_LINE = 100011;
    public static final int GLU_FILL = 100012;
    public static final int GLU_SILHOUETTE = 100013;
    public static final int GLU_OUTSIDE = 100020;
    public static final int GLU_INSIDE = 100021;
    private GL gl;

    public void gluOrtho2D(double d2, double d1, double d22, double d3) {
        GLJDirect.glOrtho((float)d2, (float)d1, (float)d22, (float)d3, -1.0, 1.0);
    }

    private double det44(double d2, double d1, double d22, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15) {
        return d2 * this.det33(d5, d6, d7, d9, d10, d11, d13, d14, d15) - d4 * this.det33(d1, d22, d3, d9, d10, d11, d13, d14, d15) + d8 * this.det33(d1, d22, d3, d5, d6, d7, d13, d14, d15) - d12 * this.det33(d1, d22, d3, d5, d6, d7, d9, d10, d11);
    }

    private double[] mulMatrix44(double[] ad, double[] ad1) {
        double[] ad2 = new double[16];
        int i2 = 0;
        while (i2 < 4) {
            int j2 = 0;
            while (j2 < 4) {
                int j1 = i2 << 2 | j2;
                int k2 = 0;
                while (k2 < 4) {
                    int l2 = i2 << 2 | k2;
                    int i1 = k2 << 2 | j2;
                    if (ad[l2] != 0.0 && ad1[i1] != 0.0) {
                        if (ad[l2] == 1.0) {
                            int n2 = j1;
                            ad2[n2] = ad2[n2] + ad1[i1];
                        } else if (ad1[i1] == 1.0) {
                            int n3 = j1;
                            ad2[n3] = ad2[n3] + ad[l2];
                        } else {
                            int n4 = j1;
                            ad2[n4] = ad2[n4] + ad[l2] * ad1[i1];
                        }
                    }
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        return ad2;
    }

    private GLU() {
    }

    public GLU(GL gl) {
        this.gl = gl;
    }

    private double det22(double d2, double d1, double d22, double d3) {
        return d2 * d3 - d1 * d22;
    }

    public void gluPickMatrix(double d2, double d1, double d22, double d3, int[] ai) {
        float[] af = new float[16];
        float f2 = (float)((double)ai[2] / d22);
        float f1 = (float)((double)ai[3] / d3);
        float f22 = (float)(((double)ai[2] + 2.0 * ((double)ai[0] - d2)) / d22);
        float f3 = (float)(((double)ai[3] + 2.0 * ((double)ai[1] - d1)) / d3);
        af[0] = f2;
        af[3] = f22;
        af[5] = f1;
        af[7] = f3;
        af[10] = 1.0f;
        af[15] = 1.0f;
        GLJDirect.glMultMatrixf(af);
    }

    public GL gluGetGL() {
        return this.gl;
    }

    public void gluQuadricDrawStyle(GLUquadricObj gluquadricobj, int i2) {
        if (i2 == 100012 || i2 == 100011 || i2 == 100013 || i2 == 100010) {
            gluquadricobj.DrawStyle = i2;
        }
    }

    public void gluSphere(GLUquadricObj gluquadricobj, double d2, int i2, int j2) {
        boolean useNormals = gluquadricobj.Normals != 100002;
        float flipside = gluquadricobj.Orientation == 100021 ? -1.0f : 1.0f;
        float f5 = 3.141593f / (float)j2;
        float f12 = 6.283185f / (float)i2;
        if (gluquadricobj.DrawStyle == 100012) {
            GLJDirect.glBegin(7);
            GLJDirect.glNormal3f(0.0f, 0.0f, 1.0f);
            GLJDirect.glVertex3f(0.0f, 0.0f, flipside * (float)d2);
            int k1 = 0;
            while (k1 <= i2) {
                float f6 = k1 == i2 ? 0.0f : (float)k1 * f12;
                float f13 = (float)(Math.cos(f6) * Math.sin(f5));
                float f19 = (float)(Math.sin(f6) * Math.sin(f5));
                float f25 = flipside * (float)Math.cos(f5);
                if (useNormals) {
                    GLJDirect.glNormal3f(f13 * flipside, f19 * flipside, f25 * flipside);
                }
                GLJDirect.glVertex3f(f13 * (float)d2, f19 * (float)d2, f25 * (float)d2);
                ++k1;
            }
            GLJDirect.glEnd();
            int k2 = 1;
            while (k2 < j2 - 1) {
                float f2 = (float)k2 * f5;
                GLJDirect.glBegin(9);
                int l1 = 0;
                while (l1 <= i2) {
                    float f7 = l1 == i2 ? 0.0f : (float)l1 * f12;
                    float f14 = (float)(Math.cos(f7) * Math.sin(f2));
                    float f20 = (float)(Math.sin(f7) * Math.sin(f2));
                    float f26 = flipside * (float)Math.cos(f2);
                    if (useNormals) {
                        GLJDirect.glNormal3f(f14 * flipside, f20 * flipside, f26 * flipside);
                    }
                    GLJDirect.glVertex3f(f14 * (float)d2, f20 * (float)d2, f26 * (float)d2);
                    f14 = (float)(Math.cos(f7) * Math.sin(f2 + f5));
                    f20 = (float)(Math.sin(f7) * Math.sin(f2 + f5));
                    f26 = flipside * (float)Math.cos(f2 + f5);
                    if (useNormals) {
                        GLJDirect.glNormal3f(f14 * flipside, f20 * flipside, f26 * flipside);
                    }
                    GLJDirect.glVertex3f(f14 * (float)d2, f20 * (float)d2, f26 * (float)d2);
                    ++l1;
                }
                GLJDirect.glEnd();
                ++k2;
            }
            GLJDirect.glBegin(7);
            GLJDirect.glNormal3f(0.0f, 0.0f, -1.0f);
            GLJDirect.glVertex3f(0.0f, 0.0f, (float)(-d2) * flipside);
            float f1 = 3.141593f - f5;
            int i22 = i2;
            while (i22 >= 0) {
                float f8 = i22 == i2 ? 0.0f : (float)i22 * f12;
                float f15 = (float)(Math.cos(f8) * Math.sin(f1));
                float f21 = (float)(Math.sin(f8) * Math.sin(f1));
                float f27 = flipside * (float)Math.cos(f1);
                if (useNormals) {
                    GLJDirect.glNormal3f(f15 * flipside, f21 * flipside, f27 * flipside);
                }
                GLJDirect.glVertex3f(f15 * (float)d2, f21 * (float)d2, f27 * (float)d2);
                --i22;
            }
            GLJDirect.glEnd();
        } else if (gluquadricobj.DrawStyle == 100011 || gluquadricobj.DrawStyle == 100013) {
            int l2 = 1;
            while (l2 < j2 - 1) {
                float f2 = (float)l2 * f5;
                GLJDirect.glBegin(4);
                int j22 = 0;
                while (j22 < i2) {
                    float f9 = (float)j22 * f12;
                    float f16 = (float)(Math.cos(f9) * Math.sin(f2));
                    float f22 = (float)(Math.sin(f9) * Math.sin(f2));
                    float f28 = (float)Math.cos(f2);
                    if (useNormals) {
                        GLJDirect.glNormal3f(f16 * flipside, f22 * flipside, f28 * flipside);
                    }
                    GLJDirect.glVertex3f(f16 * (float)d2, f22 * (float)d2, f28 * (float)d2);
                    ++j22;
                }
                GLJDirect.glEnd();
                ++l2;
            }
            int k2 = 0;
            while (k2 < i2) {
                float f10 = (float)k2 * f12;
                GLJDirect.glBegin(3);
                int i1 = 0;
                while (i1 <= j2) {
                    float f3 = (float)i1 * f5;
                    float f17 = (float)(Math.cos(f10) * Math.sin(f3));
                    float f23 = (float)(Math.sin(f10) * Math.sin(f3));
                    float f29 = (float)Math.cos(f3);
                    if (useNormals) {
                        GLJDirect.glNormal3f(f17 * flipside, f23 * flipside, f29 * flipside);
                    }
                    GLJDirect.glVertex3f(f17 * (float)d2, f23 * (float)d2, f29 * (float)d2);
                    ++i1;
                }
                GLJDirect.glEnd();
                ++k2;
            }
        } else if (gluquadricobj.DrawStyle == 100010) {
            GLJDirect.glBegin(1);
            if (useNormals) {
                GLJDirect.glNormal3f(0.0f, 0.0f, flipside);
            }
            GLJDirect.glVertex3f(0.0f, 0.0f, (float)d2);
            if (useNormals) {
                GLJDirect.glNormal3f(0.0f, 0.0f, -flipside);
            }
            GLJDirect.glVertex3f(0.0f, 0.0f, (float)(-d2));
            int j1 = 1;
            while (j1 < j2 - 1) {
                float f4 = (float)j1 * f5;
                int l2 = 0;
                while (l2 < i2) {
                    float f11 = (float)l2 * f12;
                    float f18 = (float)(Math.cos(f11) * Math.sin(f4));
                    float f24 = (float)(Math.sin(f11) * Math.sin(f4));
                    float f30 = (float)Math.cos(f4);
                    if (useNormals) {
                        GLJDirect.glNormal3f(f18 * flipside, f24 * flipside, f30 * flipside);
                    }
                    GLJDirect.glVertex3f(f18 * (float)d2, f24 * (float)d2, f30 * (float)d2);
                    ++l2;
                }
                ++j1;
            }
            GLJDirect.glEnd();
        }
    }

    public void gluCylinder(GLUquadricObj gluquadricobj, double d2, double d1, double d22, int i2, int j2) {
        boolean useNormals = GLJDirect.glIsEnabled(2977);
        GLJDirect.glEnable(2977);
        float f14 = gluquadricobj.Orientation == 100021 ? -1.0f : 1.0f;
        double d3 = Math.PI * 2 / (double)i2;
        double d7 = (d1 - d2) / (double)j2;
        double d8 = d22 / (double)j2;
        float f13 = (float)((d2 - d1) / d22);
        if (gluquadricobj.DrawStyle == 100010) {
            GLJDirect.glBegin(1);
            int k2 = 0;
            while (k2 < i2) {
                float f2 = (float)Math.cos((double)k2 * d3);
                float f5 = (float)Math.sin((double)k2 * d3);
                GLJDirect.glNormal3f(f2 * f14, f5 * f14, f13 * f14);
                float f10 = 0.0f;
                double d4 = d2;
                int i22 = 0;
                while (i22 <= j2) {
                    GLJDirect.glVertex3f(f2 * (float)d4, f5 * (float)d4, f10);
                    f10 += (float)d8;
                    d4 += d7;
                    ++i22;
                }
                ++k2;
            }
            GLJDirect.glEnd();
        } else if (gluquadricobj.DrawStyle == 100011 || gluquadricobj.DrawStyle == 100013) {
            if (gluquadricobj.DrawStyle == 100011) {
                float f11 = 0.0f;
                double d5 = d2;
                int j22 = 0;
                while (j22 <= j2) {
                    GLJDirect.glBegin(4);
                    int l2 = 0;
                    while (l2 < i2) {
                        float f1 = (float)Math.cos((double)l2 * d3);
                        float f6 = (float)Math.sin((double)l2 * d3);
                        GLJDirect.glNormal3f(f1 * f14, f6 * f14, f13 * f14);
                        GLJDirect.glVertex3f(f1 * (float)d5, f6 * (float)d5, f11);
                        ++l2;
                    }
                    GLJDirect.glEnd();
                    f11 += (float)d8;
                    d5 += d7;
                    ++j22;
                }
            } else if (d2 != 0.0) {
                GLJDirect.glBegin(4);
                int i1 = 0;
                while (i1 < i2) {
                    float f2 = (float)Math.cos((double)i1 * d3);
                    float f7 = (float)Math.sin((double)i1 * d3);
                    GLJDirect.glNormal3f(f2 * f14, f7 * f14, f13 * f14);
                    GLJDirect.glVertex3f(f2 * (float)d2, f7 * (float)d2, 0.0f);
                    ++i1;
                }
                GLJDirect.glEnd();
                GLJDirect.glBegin(4);
                int j1 = 0;
                while (j1 < i2) {
                    float f3 = (float)Math.cos((double)j1 * d3);
                    float f8 = (float)Math.sin((double)j1 * d3);
                    GLJDirect.glNormal3f(f3 * f14, f8 * f14, f13 * f14);
                    GLJDirect.glVertex3f(f3 * (float)d1, f8 * (float)d1, (float)d22);
                    ++j1;
                }
                GLJDirect.glEnd();
            }
            GLJDirect.glBegin(2);
            int k1 = 0;
            while (k1 < i2) {
                float f4 = (float)Math.cos((double)k1 * d3);
                float f9 = (float)Math.sin((double)k1 * d3);
                GLJDirect.glNormal3f(f4 * f14, f9 * f14, f13 * f14);
                GLJDirect.glVertex3f(f4 * (float)d2, f9 * (float)d2, 0.0f);
                GLJDirect.glVertex3f(f4 * (float)d1, f9 * (float)d1, (float)d22);
                ++k1;
            }
            GLJDirect.glEnd();
        } else if (gluquadricobj.DrawStyle == 100012) {
            int l1 = 0;
            while (l1 < i2) {
                float f15 = (float)Math.cos((double)l1 * d3);
                float f16 = (float)Math.sin((double)l1 * d3);
                float f17 = (float)Math.cos((double)(l1 + 1) * d3);
                float f18 = (float)Math.sin((double)(l1 + 1) * d3);
                float f12 = 0.0f;
                double d6 = d2;
                GLJDirect.glBegin(9);
                int k2 = 0;
                while (k2 <= j2) {
                    if ((double)f14 == 1.0) {
                        GLJDirect.glNormal3f(f15 * f14, f16 * f14, f13 * f14);
                        GLJDirect.glVertex3f(f15 * (float)d6, f16 * (float)d6, f12);
                        GLJDirect.glNormal3f(f17 * f14, f18 * f14, f13 * f14);
                        GLJDirect.glVertex3f(f17 * (float)d6, f18 * (float)d6, f12);
                    } else {
                        GLJDirect.glNormal3f(f17 * f14, f18 * f14, f13 * f14);
                        GLJDirect.glVertex3f(f17 * (float)d6, f18 * (float)d6, f12);
                        GLJDirect.glNormal3f(f15 * f14, f16 * f14, f13 * f14);
                        GLJDirect.glVertex3f(f15 * (float)d6, f16 * (float)d6, f12);
                    }
                    f12 += (float)d8;
                    d6 += d7;
                    ++k2;
                }
                GLJDirect.glEnd();
                ++l1;
            }
        }
        if (!useNormals) {
            GLJDirect.glDisable(2977);
        }
    }

    private double[] adjoint44(double[] ad) {
        double[] ad1 = new double[16];
        ad1[0] = this.det33(ad[5], ad[6], ad[7], ad[9], ad[10], ad[11], ad[13], ad[14], ad[15]);
        ad1[1] = -this.det33(ad[4], ad[6], ad[7], ad[8], ad[10], ad[11], ad[12], ad[14], ad[15]);
        ad1[2] = this.det33(ad[4], ad[5], ad[7], ad[8], ad[9], ad[11], ad[12], ad[13], ad[15]);
        ad1[3] = -this.det33(ad[4], ad[5], ad[6], ad[8], ad[9], ad[10], ad[12], ad[13], ad[14]);
        ad1[4] = -this.det33(ad[1], ad[2], ad[3], ad[9], ad[10], ad[11], ad[13], ad[14], ad[15]);
        ad1[5] = this.det33(ad[0], ad[2], ad[3], ad[8], ad[10], ad[11], ad[12], ad[14], ad[15]);
        ad1[6] = -this.det33(ad[0], ad[1], ad[3], ad[8], ad[9], ad[10], ad[12], ad[13], ad[15]);
        ad1[7] = this.det33(ad[0], ad[1], ad[2], ad[8], ad[9], ad[10], ad[12], ad[13], ad[14]);
        ad1[9] = -this.det33(ad[0], ad[2], ad[3], ad[4], ad[6], ad[7], ad[12], ad[14], ad[15]);
        ad1[10] = this.det33(ad[0], ad[1], ad[3], ad[4], ad[5], ad[7], ad[12], ad[13], ad[15]);
        ad1[11] = -this.det33(ad[0], ad[1], ad[2], ad[4], ad[5], ad[6], ad[12], ad[13], ad[14]);
        ad1[12] = -this.det33(ad[1], ad[2], ad[3], ad[5], ad[6], ad[7], ad[9], ad[10], ad[11]);
        ad1[13] = this.det33(ad[0], ad[2], ad[3], ad[4], ad[6], ad[7], ad[8], ad[10], ad[11]);
        ad1[14] = -this.det33(ad[0], ad[1], ad[3], ad[4], ad[5], ad[7], ad[8], ad[9], ad[11]);
        ad1[15] = this.det33(ad[0], ad[1], ad[2], ad[4], ad[5], ad[6], ad[8], ad[9], ad[10]);
        return ad1;
    }

    private double[] inverseMatrix44(double[] ad) {
        double[] ad1 = this.adjoint44(ad);
        double d2 = this.det44(ad1[0], ad1[1], ad1[2], ad1[3], ad1[4], ad1[5], ad1[6], ad1[7], ad1[8], ad1[9], ad1[10], ad1[11], ad1[12], ad1[13], ad1[14], ad1[15]);
        if (d2 != 0.0) {
            int i2 = 0;
            while (i2 < 16) {
                int n2 = i2++;
                ad1[n2] = ad1[n2] / d2;
            }
            return ad1;
        }
        return null;
    }

    public GLUquadricObj gluNewQuadric() {
        GLUquadricObj gluquadricobj = new GLUquadricObj();
        gluquadricobj.DrawStyle = 100012;
        gluquadricobj.Orientation = 100020;
        gluquadricobj.TextureFlag = false;
        gluquadricobj.Normals = 100000;
        return gluquadricobj;
    }

    private double[] mulMatrix41(double[] ad, double[] ad1) {
        double[] ad2 = new double[4];
        int i2 = 0;
        while (i2 < 4) {
            int j2 = 0;
            while (j2 < 4) {
                int k2 = i2 << 2 | j2;
                if (ad[k2] != 0.0 && ad1[j2] != 0.0) {
                    if (ad[k2] == 1.0) {
                        int n2 = i2;
                        ad2[n2] = ad2[n2] + ad1[j2];
                    } else if (ad1[j2] == 1.0) {
                        int n3 = i2;
                        ad2[n3] = ad2[n3] + ad[k2];
                    } else {
                        int n4 = i2;
                        ad2[n4] = ad2[n4] + ad[k2] * ad1[j2];
                    }
                }
                ++j2;
            }
            ++i2;
        }
        return ad2;
    }

    public void gluQuadricNormals(GLUquadricObj gluquadricobj, int i2) {
        if (i2 == 100002 || i2 == 100001 || i2 == 100000) {
            gluquadricobj.Normals = i2;
        }
    }

    public void gluPerspective(double d2, double d1, double d22, double d3) {
        double d7 = d22 * Math.tan(d2 * Math.PI / 360.0);
        double d6 = -d7;
        double d4 = d6 * d1;
        double d5 = d7 * d1;
        GLJDirect.glFrustum((float)d4, (float)d5, (float)d6, (float)d7, (float)d22, (float)d3);
    }

    public boolean gluProject(double d2, double d1, double d22, double[] ad, double[] ad1, int[] ai, double[] ad2, double[] ad3, double[] ad4) {
        double[] ad5 = new double[]{d2, d1, d22, 1.0};
        double[] ad6 = this.mulMatrix41(ad, ad5);
        ad5 = this.mulMatrix41(ad1, ad6);
        ad5[0] = ad5[0] / ad5[3];
        ad5[1] = ad5[1] / ad5[3];
        ad5[2] = ad5[2] / ad5[3];
        ad2[0] = (double)ai[0] + (1.0 + ad5[0]) * (double)ai[2] / 2.0;
        ad3[0] = (double)ai[1] + (1.0 + ad5[1]) * (double)ai[3] / 2.0;
        ad4[0] = (1.0 + ad5[2]) / 2.0;
        return true;
    }

    public void gluLookAt(double d2, double d1, double d22, double d3, double d4, double d5, double d6, double d7, double d8) {
        double[] ad = new double[16];
        double[] ad1 = new double[3];
        double[] ad2 = new double[3];
        double[] ad3 = new double[]{d2 - d3, d1 - d4, d22 - d5};
        double d9 = Math.sqrt(ad3[0] * ad3[0] + ad3[1] * ad3[1] + ad3[2] * ad3[2]);
        if (d9 != 0.0) {
            ad3[0] = ad3[0] / d9;
            ad3[1] = ad3[1] / d9;
            ad3[2] = ad3[2] / d9;
        }
        ad2[0] = d6;
        ad2[1] = d7;
        ad2[2] = d8;
        ad1[0] = ad2[1] * ad3[2] - ad2[2] * ad3[1];
        ad1[1] = -ad2[0] * ad3[2] + ad2[2] * ad3[0];
        ad1[2] = ad2[0] * ad3[1] - ad2[1] * ad3[0];
        ad2[0] = ad3[1] * ad1[2] - ad3[2] * ad1[1];
        ad2[1] = -ad3[0] * ad1[2] + ad3[2] * ad1[0];
        ad2[2] = ad3[0] * ad1[1] - ad3[1] * ad1[0];
        d9 = Math.sqrt(ad1[0] * ad1[0] + ad1[1] * ad1[1] + ad1[2] * ad1[2]);
        if (d9 != 0.0) {
            ad1[0] = ad1[0] / d9;
            ad1[1] = ad1[1] / d9;
            ad1[2] = ad1[2] / d9;
        }
        if ((d9 = Math.sqrt(ad2[0] * ad2[0] + ad2[1] * ad2[1] + ad2[2] * ad2[2])) != 0.0) {
            ad2[0] = ad2[0] / d9;
            ad2[1] = ad2[1] / d9;
            ad2[2] = ad2[2] / d9;
        }
        ad[0] = ad1[0];
        ad[1] = ad1[1];
        ad[2] = ad1[2];
        ad[4] = ad2[0];
        ad[5] = ad2[1];
        ad[6] = ad2[2];
        ad[8] = ad3[0];
        ad[9] = ad3[1];
        ad[10] = ad3[2];
        ad[15] = 1.0;
        GLJDirect.glMultMatrixd(ad);
        GLJDirect.glTranslated(-d2, -d1, -d22);
    }

    private double det33(double d2, double d1, double d22, double d3, double d4, double d5, double d6, double d7, double d8) {
        return d2 * this.det22(d4, d5, d7, d8) - d3 * this.det22(d1, d22, d7, d8) + d6 * this.det22(d1, d22, d4, d5);
    }

    public boolean gluUnProject(double d2, double d1, double d22, double[] ad, double[] ad1, int[] ai, double[] ad2, double[] ad3, double[] ad4) {
        double[] ad5 = new double[16];
        double[] ad6 = new double[16];
        double[] ad7 = new double[4];
        double[] ad8 = new double[4];
        ad7[0] = (d2 - (double)ai[0]) * 2.0 / (double)ai[2] - 1.0;
        ad7[1] = (d1 - (double)ai[1]) * 2.0 / (double)ai[3] - 1.0;
        ad7[2] = 2.0 * d22 - 1.0;
        ad7[3] = 1.0;
        ad6 = this.mulMatrix44(ad1, ad);
        ad5 = this.inverseMatrix44(ad6);
        ad8 = this.mulMatrix41(ad5, ad7);
        ad2[0] = ad8[0] / ad8[3];
        ad3[0] = ad8[1] / ad8[3];
        ad4[0] = ad8[2] / ad8[3];
        return true;
    }
}

