/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.opengl;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import org.komplex.opengl.GL;
import org.komplex.opengl.GLConstants;
import org.komplex.opengl.GLJDirect;
import org.komplex.util.Fetch;

public class GLImage
implements ImageConsumer,
ImageProducer,
GLConstants {
    static final boolean DEBUG = false;
    int imgw;
    int imgh;
    boolean completed = false;
    boolean error;
    int[] pixels24;
    Toolkit def = Toolkit.getDefaultToolkit();
    ImageConsumer theConsumer;

    public void setHints(int hintflags) {
        this.pixels24 = new int[this.imgw * this.imgh];
    }

    public int getFormat() {
        return 6408;
    }

    public synchronized void waitForImage() {
        try {
            while (true) {
                if (this.isReady()) {
                    return;
                }
                this.wait(500L);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    public byte[] getData() {
        byte[] pix = new byte[this.pixels24.length * 4];
        int j2 = 0;
        int i2 = 0;
        while (i2 < this.pixels24.length) {
            int p2 = this.pixels24[i2];
            pix[j2++] = (byte)(p2 >> 16 & 0xFF);
            pix[j2++] = (byte)(p2 >> 8 & 0xFF);
            pix[j2++] = (byte)(p2 & 0xFF);
            pix[j2++] = (byte)(p2 >>> 24 & 0xFF);
            ++i2;
        }
        return pix;
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public static void build2DMipmap(GL gl, GLImage img) {
        GLJDirect.glTexImage2D(3553, 0, 32849, img.getWidth(), img.getHeight(), 0, img.getFormat(), 5121, img.getData());
        int i2 = 1;
        while (i2 < 11) {
            if (img.getWidth() >> i2 > 0) {
                GLImage mip = img.createMipmap(i2);
                GLJDirect.glTexImage2D(3553, i2, 32849, mip.getWidth(), mip.getHeight(), 0, mip.getFormat(), 5121, mip.getData());
            }
            ++i2;
        }
    }

    public void setPixels(int x, int y, int w, int h2, ColorModel model, byte[] pixels, int off, int scansize) {
        try {
            int doff = y * this.imgw + x;
            int i2 = 0;
            while (i2 < h2) {
                int j2 = 0;
                while (j2 < w) {
                    this.pixels24[doff + j2] = model.getRGB(pixels[off + j2] & 0xFF);
                    ++j2;
                }
                off += scansize;
                doff += this.imgw;
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setPixels(int x, int y, int w, int h2, ColorModel model, int[] pixels, int off, int scansize) {
        int doff = y * this.imgw + x;
        int i2 = 0;
        while (i2 < h2) {
            int j2 = 0;
            while (j2 < w) {
                this.pixels24[doff + j2] = model.getRGB(pixels[off + j2]);
                ++j2;
            }
            off += scansize;
            doff += this.imgw;
            ++i2;
        }
    }

    public synchronized void addConsumer(ImageConsumer imageconsumer) {
        this.theConsumer = imageconsumer;
        this.produce();
    }

    public int getWidth() {
        return this.imgw;
    }

    private void produce() {
        if (this.theConsumer == null) {
            return;
        }
        this.def.getColorModel();
        ColorModel cm = ColorModel.getRGBdefault();
        this.theConsumer.setDimensions(this.imgw, this.imgh);
        this.theConsumer.setColorModel(cm);
        this.theConsumer.setHints(30);
        this.theConsumer.setPixels(0, 0, this.imgw, this.imgh, ColorModel.getRGBdefault(), this.pixels24, 0, this.imgw);
        this.theConsumer.imageComplete(3);
    }

    public GLImage(int w, int h2) {
        this.imgw = w;
        this.imgh = h2;
        this.pixels24 = new int[w * h2];
    }

    public GLImage(int w, int h2, int[] pix24) {
        this.imgw = w;
        this.imgh = h2;
        this.pixels24 = pix24;
        this.completed = true;
    }

    public GLImage(String file) {
        InputStream is = this.getClass().getResourceAsStream(file);
        byte[] b2 = Fetch.fetch(is);
        Image img = this.def.createImage(b2);
        this.startLoadImage(img);
    }

    public GLImage(URL url) {
        Image img = this.def.getImage(url);
        this.startLoadImage(img);
    }

    public GLImage(Image img) {
        this.startLoadImage(img);
    }

    public void bind(GL gl, int id) {
        this.bind(gl, id, false);
    }

    public void bind(GL gl, int id, boolean wrap) {
        this.waitForImage();
        GLJDirect.glBindTexture(3553, id);
        GLJDirect.glTexParameteri(3553, 10241, 9729);
        GLJDirect.glTexParameteri(3553, 10240, 9729);
        GLJDirect.glTexImage2D(3553, 0, 6408, this.getWidth(), this.getHeight(), 0, this.getFormat(), 5121, this.getData());
        int w = wrap ? 10497 : 10496;
        GLJDirect.glTexParameteri(3553, 10242, w);
        GLJDirect.glTexParameteri(3553, 10243, w);
    }

    public GLImage createMipmap(int n2) {
        AreaAveragingScaleFilter filt = new AreaAveragingScaleFilter(this.imgw >> n2, this.imgh >> n2);
        Image img = this.def.createImage(new FilteredImageSource(this, filt));
        GLImage gg = new GLImage(img);
        return gg;
    }

    public void loadImage(Image img) {
        this.startLoadImage(img);
        this.waitForImage();
    }

    public void startLoadImage(Image img) {
        ImageProducer ip = img.getSource();
        if (ip == null) {
            return;
        }
        this.startLoadImage(ip);
    }

    public void startLoadImage(ImageProducer ip) {
        ip.startProduction(this);
        this.waitForImage();
    }

    public synchronized boolean isConsumer(ImageConsumer imageconsumer) {
        return imageconsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageconsumer) {
        if (this.theConsumer == imageconsumer) {
            this.theConsumer = null;
        }
    }

    public void setDimensions(int width, int height) {
        this.imgw = width;
        this.imgh = height;
    }

    public void setProperties(Hashtable props) {
    }

    public void startProduction(ImageConsumer imageconsumer) {
        this.addConsumer(imageconsumer);
    }

    public int getHeight() {
        return this.imgh;
    }

    public boolean ok() {
        return !this.error;
    }

    public synchronized void imageComplete(int status) {
        if (!this.completed) {
            if (status == 1 || status == 4) {
                this.error = true;
            }
            this.completed = true;
            this.notify();
        }
    }

    public boolean isReady() {
        return this.completed;
    }

    public void setColorModel(ColorModel model) {
    }

    public static void getTexture(GL gl, int id, String name) {
        GLImage.getTexture(gl, id, name, false);
    }

    public static void getTexture(GL gl, int id, String name, boolean wrap) {
        GLImage img0 = new GLImage(name);
        img0.bind(gl, id, wrap);
    }
}

