/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.opengl;

import com.ms.awt.WComponentPeer;
import com.ms.dll.Callback;
import com.ms.dll.DllLib;
import com.ms.dll.Root;
import com.ms.win32.Gdi32;
import com.ms.win32.Kernel32;
import com.ms.win32.MSG;
import com.ms.win32.PIXELFORMATDESCRIPTOR;
import com.ms.win32.User32;
import com.ms.win32.WNDCLASS;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.komplex.opengl.GL;
import org.komplex.opengl.GLCanvasCallback;
import org.komplex.opengl.GLIdleListener;
import org.komplex.opengl.GLJDirect;
import org.komplex.opengl.GLRepaintListener;
import org.komplex.opengl.GLResizeListener;
import org.komplex.opengl.OpenGL;
import org.komplex.opengl.ext.ARBMultitexture;
import org.komplex.opengl.ext.EXTCompiledVertexArray;

public class GLCanvas
extends Canvas
implements ComponentListener,
Runnable {
    GL gl;
    Container container;
    int colorBits = 32;
    int depthBits = 16;
    int stencilBits = 0;
    Hashtable extensions = new Hashtable();
    int hglRC;
    int hDC;
    int rootWndProc;
    int hWnd;
    boolean done = false;
    Vector idleListeners = new Vector();
    Vector repaintListeners = new Vector();
    Vector resizeListeners = new Vector();
    Callback wndProc = new GLCanvasCallback(this);
    boolean peerCreated = false;
    boolean peerInitialized = false;
    Rectangle resize = null;

    public void addGLRepaintListener(GLRepaintListener l2) {
        this.repaintListeners.addElement(l2);
    }

    synchronized void createGLPeer() {
        if (!this.peerCreated) {
            this.peerCreated = true;
            this.container = this.getTopContainer(this);
            Thread t = new Thread(this);
            t.start();
        }
    }

    public void componentShown(ComponentEvent e2) {
        this.createGLPeer();
    }

    public void makeCurrent() {
        GLJDirect.wglMakeCurrent(this.hDC, this.hglRC);
    }

    public void componentResized(ComponentEvent e2) {
        Rectangle r2;
        this.createGLPeer();
        this.resize = r2 = this.container.getBounds();
        int hwndParent = this.getComponentHwnd(this.container);
        User32.SetWindowPos((int)this.hWnd, (int)0, (int)0, (int)0, (int)r2.width, (int)r2.height, (int)4);
    }

    public boolean isPeerCreated() {
        return this.peerCreated && this.peerInitialized;
    }

    void callRepaintListeners() {
        if (this.resize != null) {
            Rectangle r2 = this.resize;
            this.resize = null;
            if (r2 != null) {
                this.callResizeListeners(r2.width, r2.height);
            }
        }
        Enumeration e2 = this.repaintListeners.elements();
        while (e2.hasMoreElements()) {
            ((GLRepaintListener)e2.nextElement()).doGLWindowRepaint();
        }
    }

    public void componentHidden(ComponentEvent e2) {
    }

    public void swapBuffers() {
        Gdi32.SwapBuffers((int)this.hDC);
    }

    public void initExtensions() {
        String ext = GL.glGetString(7939);
        if (ext == null) {
            return;
        }
        try {
            if (ext.indexOf("GL_ARB_multitexture") != -1) {
                this.extensions.put("GL_ARB_multitexture", new ARBMultitexture(this.gl));
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (ext.indexOf("GL_EXT_compiled_vertex_array") != -1) {
                this.extensions.put("GL_EXT_compiled_vertex_array", new EXTCompiledVertexArray(this.gl));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void initGL() {
        this.hDC = User32.GetDC((int)this.hWnd);
        PIXELFORMATDESCRIPTOR pfd = new PIXELFORMATDESCRIPTOR();
        pfd.nVersion = 1;
        pfd.dwFlags = 37;
        pfd.iPixelType = 0;
        pfd.cDepthBits = (byte)this.depthBits;
        pfd.cColorBits = (byte)this.colorBits;
        pfd.cStencilBits = (byte)this.stencilBits;
        pfd.iLayerType = 0;
        this.hglRC = 0;
        int pixelFormat = Gdi32.ChoosePixelFormat((int)this.hDC, (PIXELFORMATDESCRIPTOR)pfd);
        if (pixelFormat != 0 && Gdi32.SetPixelFormat((int)this.hDC, (int)pixelFormat, (PIXELFORMATDESCRIPTOR)pfd)) {
            this.hglRC = GLJDirect.wglCreateContext(this.hDC);
            if (this.hglRC != 0 && !GLJDirect.wglMakeCurrent(this.hDC, this.hglRC)) {
                this.destroyGL();
            }
        }
        if (this.hglRC == 0) {
            throw new RuntimeException("createcontext failed");
        }
    }

    void destroyGL() {
        if (this.hglRC != 0) {
            GLJDirect.wglMakeCurrent(0, 0);
            GLJDirect.wglDeleteContext(this.hglRC);
            this.hglRC = 0;
        }
    }

    void pumpWin32Messages() {
        MSG msg = new MSG();
        this.peerInitialized = true;
        while (!this.done) {
            if (User32.PeekMessage((MSG)msg, (int)0, (int)0, (int)0, (int)1)) {
                if (msg.message == 18) break;
                User32.TranslateMessage((MSG)msg);
                User32.DispatchMessage((MSG)msg);
                continue;
            }
            this.callIdleListeners();
        }
        Root.free((int)this.rootWndProc);
    }

    public void addGLResizeListener(GLResizeListener l2) {
        this.resizeListeners.addElement(l2);
    }

    public void removeGLRepaintListener(GLRepaintListener l2) {
        this.repaintListeners.removeElement(l2);
    }

    int getComponentHwnd(Component component) {
        return ((WComponentPeer)this.getTopContainer(component).getPeer()).gethwnd();
    }

    void callResizeListeners(int w, int h2) {
        Enumeration e2 = this.resizeListeners.elements();
        while (e2.hasMoreElements()) {
            ((GLResizeListener)e2.nextElement()).doGLWindowResize(w, h2);
        }
    }

    boolean registerWindowClass(String title, int addrOfWndProc) {
        WNDCLASS wc = new WNDCLASS();
        wc.style = 0;
        wc.lpfnWndProc = addrOfWndProc;
        wc.cbWndExtra = 0;
        wc.cbClsExtra = 0;
        wc.hInstance = Kernel32.GetModuleHandle(null);
        wc.hIcon = User32.LoadIcon((int)0, (int)32512);
        wc.hCursor = User32.LoadCursor((int)0, (int)32512);
        wc.hbrBackground = Gdi32.GetStockObject((int)4);
        wc.lpszMenuName = title;
        wc.lpszClassName = title;
        return User32.RegisterClass((WNDCLASS)wc) != 0;
    }

    void createWindow() {
        String title = "komplexglcanvas";
        this.rootWndProc = Root.alloc((Object)this.wndProc);
        this.registerWindowClass(title, DllLib.addrOf((int)this.rootWndProc));
        Rectangle r2 = this.container.getBounds();
        int hwndParent = this.getComponentHwnd(this);
        int style = 0x54000000;
        this.hWnd = User32.CreateWindow((String)title, (String)title, (int)style, (int)0, (int)0, (int)r2.width, (int)r2.height, (int)hwndParent, (int)0, (int)0, (int)0);
        if (this.hWnd == 0) {
            throw new RuntimeException("createwindow failed");
        }
        User32.ShowWindow((int)this.hWnd, (int)10);
        User32.UpdateWindow((int)this.hWnd);
    }

    public GLCanvas() {
        this(OpenGL.createGLContext(), 32, 16, 0);
    }

    public GLCanvas(int colorBits, int depthBits) {
        this(OpenGL.createGLContext(), colorBits, depthBits, 0);
    }

    public GLCanvas(int colorBits, int depthBits, int stencilBits) {
        this(OpenGL.createGLContext(), colorBits, depthBits, stencilBits);
    }

    public GLCanvas(GL gl, int colorBits, int depthBits, int stencilBits) {
        this.gl = gl;
        this.colorBits = colorBits;
        this.depthBits = depthBits;
        this.addComponentListener(this);
    }

    public void removeGLIdleListener(GLIdleListener l2) {
        this.idleListeners.removeElement(l2);
    }

    public synchronized void waitForPeer() throws InterruptedException {
        do {
            this.wait(200L);
        } while (!this.isPeerCreated());
    }

    static {
        try {
            System.loadLibrary("opengl32");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void addGLIdleListener(GLIdleListener l2) {
        this.idleListeners.addElement(l2);
    }

    public void removeGLResizeListener(GLResizeListener l2) {
        this.resizeListeners.removeElement(l2);
    }

    void destroyWindow() {
        User32.DestroyWindow((int)this.hWnd);
        this.hWnd = 0;
    }

    Container getTopContainer(Component component) {
        while (true) {
            Container container = component.getParent();
            try {
                if (component.getPeer() instanceof WComponentPeer) {
                    int x = ((WComponentPeer)component.getPeer()).gethwnd();
                    return (Container)component;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (container == null) break;
            component = container;
        }
        return (Container)component;
    }

    void callIdleListeners() {
        this.makeCurrent();
        Enumeration e2 = this.idleListeners.elements();
        while (e2.hasMoreElements()) {
            ((GLIdleListener)e2.nextElement()).doGLWindowIdle();
        }
    }

    public void run() {
        this.createWindow();
        this.initGL();
        this.pumpWin32Messages();
    }

    public void componentMoved(ComponentEvent e2) {
        this.createGLPeer();
    }

    public GL getGL() {
        return this.gl;
    }
}

