/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio.device;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.komplex.audio.AudioDataConverter;
import org.komplex.audio.AudioException;
import org.komplex.audio.BaseDevice;

public class JavaSoundDevice
extends BaseDevice
implements Runnable {
    static final int JSBUFSIZE = 5120;
    static final int BUFSIZE = 1024;
    Thread thread;
    AudioDataConverter ac;
    SourceDataLine line;
    private static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public void stop() {
        this.thread = null;
    }

    void close() {
        if (this.line != null) {
            if (this.thread != null) {
                this.line.drain();
            }
            this.line.stop();
            this.line.close();
            this.line = null;
        }
    }

    void open() throws AudioException {
        AudioFormat format;
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine != null ? class$javax$sound$sampled$SourceDataLine : (class$javax$sound$sampled$SourceDataLine = JavaSoundDevice.class$("javax.sound.sampled.SourceDataLine")), format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.getSampleRate(), this.getBits(), this.getChannels(), this.getSampleSize(), 5120.0f, false));
        if (!AudioSystem.isLineSupported(info)) {
            throw new AudioException("unsupported: " + info.toString());
        }
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(format);
        }
        catch (LineUnavailableException ex) {
            throw new AudioException("Unable to open the line: " + ex);
        }
    }

    public String toString() {
        return "JavaSound Audio Out";
    }

    public int read() {
        return 255;
    }

    public float getGain() {
        return this.getGainControl().getValue();
    }

    public float getGainMin() {
        return this.getGainControl().getMinimum();
    }

    public void setGain(float v) {
        this.getGainControl().setValue(v);
    }

    public void start() throws AudioException {
        this.thread = new Thread(this);
        this.thread.setName(this.toString());
        this.thread.start();
        this.thread.setPriority(10);
    }

    private static /* synthetic */ Class class$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e2) {
            throw new NoClassDefFoundError(e2.getMessage());
        }
    }

    public FloatControl getGainControl() {
        return (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
    }

    public void run() {
        int[] data = new int[1024];
        byte[] data8 = new byte[data.length * this.getSampleSize()];
        this.line.start();
        System.out.println("start");
        try {
            while (this.thread != null) {
                long t0 = System.currentTimeMillis();
                int c2 = data.length;
                if (this.source != null) {
                    c2 = this.source.read(data, 0, data.length);
                    if (c2 == -1) break;
                    this.ac.convert(data, 0, data8, 0, c2);
                }
                int off = 0;
                int len = c2 * this.getSampleSize();
                while (len > 0) {
                    int b2 = this.line.write(data8, off, len);
                    off += b2;
                    len -= b2;
                }
            }
        }
        catch (Exception e2) {
            System.err.println("playback error: " + e2);
            e2.printStackTrace();
        }
        this.close();
    }

    public void init(int n2) throws AudioException {
        super.init(n2);
        this.open();
        this.ac = AudioDataConverter.getConverter(this.getFormat());
        if (this.line == null) {
            throw new AudioException("cannot open line output");
        }
    }

    public float getGainMax() {
        return this.getGainControl().getMaximum();
    }
}

