/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio;

import org.komplex.audio.AudioChannel;

public class SampleChannel
implements AudioChannel {
    public final double PAN_CENTER = 0.5;
    static final int FIXED = 12;
    static final int FIXEDSCALE = 4096;
    byte[] data;
    boolean enabled;
    int position;
    int pitch;
    double volume;
    double pan;

    public void trigger() {
        this.position = 0;
        this.enabled = true;
    }

    public SampleChannel(byte[] data) {
        this.data = data;
        this.setPan(0.5);
        this.setVolume(1.0);
        this.setPitch(1.0);
    }

    public void mix(int[] buffer, int off, int len) {
        if (!this.enabled) {
            return;
        }
        int off2 = off + len;
        int i2 = off;
        int p2 = this.position;
        int d2 = this.pitch;
        int v0 = (int)(this.pan * this.volume * 255.0);
        int v1 = (int)((1.0 - this.pan) * this.volume * 255.0);
        int mixval = v0 << 16 | v1;
        try {
            while (i2 < off2) {
                byte b2 = this.data[p2 >>> 12];
                int n2 = i2++;
                buffer[n2] = buffer[n2] + b2 * mixval;
                p2 += d2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            this.enabled = false;
            e2.printStackTrace();
        }
        this.position = p2;
    }

    public void setPitch(double f2) {
        this.pitch = (int)(f2 * 4096.0);
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double f2) {
        if (f2 < 0.0) {
            f2 = 0.0;
        }
        if (f2 > 1.0) {
            f2 = 1.0;
        }
        this.volume = f2;
    }

    public double getPan() {
        return this.pan;
    }

    public void setPan(double f2) {
        if (f2 < 0.0) {
            f2 = 0.0;
        }
        if (f2 > 1.0) {
            f2 = 1.0;
        }
        this.pan = f2;
    }
}

