/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.komplex.audio.BassDLL;

public class BassPlayer {
    int moduleHandle = 0;

    public void stop() {
        BassDLL.BASS_Stop();
    }

    public void unload() {
        BassDLL.BASS_Free();
        this.moduleHandle = 0;
    }

    public static byte[] readStreamToByteArray(InputStream is) throws IOException {
        int c2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        while ((c2 = is.read(buf)) > 0) {
            os.write(buf, 0, c2);
        }
        ((OutputStream)os).close();
        return os.toByteArray();
    }

    public void play() {
        BassDLL.BASS_Start();
        BassDLL.BASS_MusicPlay(this.moduleHandle);
    }

    public void load(String filename) throws IOException {
        FileInputStream is = new FileInputStream(filename);
        this.load(is);
        ((InputStream)is).close();
    }

    public void load(InputStream is) throws IOException {
        byte[] mod = BassPlayer.readStreamToByteArray(is);
        int mh = BassDLL.BASS_MusicLoad(true, mod, 0, 0, 0);
        if (mh == 0) {
            throw new IOException("unable to load module");
        }
        this.moduleHandle = mh;
    }

    public int getPosition() {
        return BassDLL.BASS_ChannelGetPosition(this.moduleHandle);
    }

    public void init() {
        boolean initok = BassDLL.init(false);
        if (!initok) {
            throw new RuntimeException("Unable to initialize sound system.");
        }
    }
}

