/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio;

import java.util.Enumeration;
import java.util.Vector;
import org.komplex.audio.AudioOutDevice;

public class AudioOutDeviceFactory {
    Vector v = new Vector();
    Vector disabled = new Vector();
    boolean nosound = false;
    static final String AUDIO_OUT_JDK11 = "org.komplex.audio.device.SunAudioDevice";
    static final String AUDIO_OUT_IE4 = "org.komplex.audio.device.DirectSoundDevice";
    static final String AUDIO_OUT_JS = "org.komplex.audio.device.JavaSoundDevice";

    public void initArgs(String[] args) {
        if (args == null) {
            return;
        }
        int i2 = 0;
        while (i2 < args.length) {
            String s = args[i2];
            if (s.equals("-nosound")) {
                this.nosound = true;
            }
            if (s.equals("-nojs")) {
                this.disabled.addElement(AUDIO_OUT_JS);
            }
            if (s.equals("-nods")) {
                this.disabled.addElement(AUDIO_OUT_IE4);
            }
            if (s.equals("-nosun")) {
                this.disabled.addElement(AUDIO_OUT_JDK11);
            }
            ++i2;
        }
    }

    public AudioOutDeviceFactory() {
        this.v.addElement(AUDIO_OUT_IE4);
        this.v.addElement(AUDIO_OUT_JS);
        this.v.addElement(AUDIO_OUT_JDK11);
    }

    public void addDevice(String classname) {
        this.v.addElement(classname);
    }

    public AudioOutDevice getAudioOutDevice() {
        AudioOutDevice ad = null;
        Enumeration e2 = this.v.elements();
        while (e2.hasMoreElements()) {
            ad = this.silentLoadAudioOutDevice(e2.nextElement().toString());
            if (ad == null) continue;
            return ad;
        }
        return ad;
    }

    static AudioOutDevice loadDevice(String s) {
        Class<?> c2 = null;
        try {
            System.out.println(s);
            c2 = Class.forName(s);
            return (AudioOutDevice)c2.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected AudioOutDevice silentLoadAudioOutDevice(String s) {
        if (this.disabled.contains(s)) {
            System.out.println("disabled: " + s);
            return null;
        }
        AudioOutDevice ad = null;
        try {
            ad = AudioOutDeviceFactory.loadDevice(s);
        }
        catch (Error e2) {
            System.out.println("failed: " + s + " reason:" + e2.toString());
        }
        return ad;
    }

    public void disableDevice(AudioOutDevice d2) {
        String name = d2.getClass().getName();
        System.out.print(name);
        this.disabled.addElement(name);
    }
}

