/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Random;
import javax.vecmath.Vector3f;
import org.komplex.demo.GLPart;
import org.komplex.demo.RandomLayer;
import org.komplex.opengl.GL;
import org.komplex.opengl.GLJDirect;

public class SuttuPart
extends GLPart {
    Particle[] parta = new Particle[16384];
    float[] pos;
    float[] col;
    RandomLayer rl = new RandomLayer(1.0);
    static Random rnd = new Random();

    public void prepare() {
        super.prepare();
        GLJDirect.glClear(16384);
    }

    public boolean render(float t) {
        this.setProjMatrix(60.0f);
        GLJDirect.glEnable(3042);
        GLJDirect.glBlendFunc(770, 771);
        GLJDirect.glMatrixMode(5888);
        GLJDirect.glLoadIdentity();
        GL.glColor(0.0, 0.0, 0.0, 0.35);
        this.rl.render(this.gl, t);
        double sx = Math.sin((double)t * 0.1) * 4.0;
        double sy = Math.cos((double)t * 0.2) * 3.0;
        this.glu.gluLookAt(4.0 + sx, sy - 6.0, 11.2, 0.0, -1.0, 0.0, 0.0, -1.0, 0.0);
        GLJDirect.glRotated(22.0, 0.0, 0.0, 1.0);
        GLJDirect.glEnable(3042);
        GLJDirect.glBlendFunc(770, 1);
        GLJDirect.glEnable(2832);
        float lig = this.clamp1(30.0f - t) * this.clamp1((double)t * 0.2) * 0.5f;
        int j2 = 0;
        while (j2 < 8) {
            int coff = j2 * 4;
            GLJDirect.glPointSize(2.0f + (float)j2 * 0.33f);
            float f2 = 1.0f - t - 4.0f;
            int i2 = j2;
            while (i2 < this.parta.length) {
                this.parta[i2].animate(t);
                this.col[i2 * 4 + 3] = lig;
                i2 += 8;
            }
            ++j2;
        }
        GL.glColor(0.1, 0.3, 0.1);
        GLJDirect.glEnableClientState(32886);
        GLJDirect.glColorPointer(4, 5126, 0, this.col);
        GLJDirect.glEnableClientState(32884);
        GLJDirect.glVertexPointer(3, 5126, 0, this.pos);
        GLJDirect.glDrawArrays(0, 0, this.parta.length);
        GLJDirect.glDisableClientState(32886);
        GLJDirect.glDisableClientState(32884);
        GLJDirect.glLoadIdentity();
        GLJDirect.glEnable(3553);
        GLJDirect.glDisable(3553);
        return true;
    }

    public void init() {
        this.pos = new float[this.parta.length * 3];
        this.col = new float[this.parta.length * 4];
        float f2 = 0.00390625f;
        int off = 0;
        int i2 = 0;
        while (i2 < this.parta.length) {
            this.parta[i2] = (i2 & 3) == 0 ? new HomoParticle(this.pos, i2 * 3) : new Particle(this.pos, i2 * 3);
            this.parta[i2].time = (float)(10 * i2) / (float)this.parta.length + (float)Math.random();
            int rgb = Color.getHSBColor((1.0f - (float)i2 / (float)this.parta.length) * 0.11f, 0.75f, 0.17f).getRGB();
            this.col[off++] = f2 * (float)(rgb >>> 16 & 0xFF);
            this.col[off++] = f2 * (float)(rgb >>> 8 & 0xFF);
            this.col[off++] = f2 * (float)(rgb & 0xFF);
            this.col[off++] = 1.0f;
            ++i2;
        }
    }

    public void unprepare() {
        this.parta = null;
        GLJDirect.glDisable(3042);
    }

    class Particle {
        Vector3f position;
        Vector3f vel;
        float time;
        int idx;
        float[] pp;
        float t0;

        public void reset() {
            this.pp[this.idx] = 0.0f;
            this.pp[this.idx + 1] = 0.0f;
            this.pp[this.idx + 2] = 0.0f;
            this.vel = new Vector3f(rnd.nextFloat() - 0.5f, 0.0f, rnd.nextFloat() - 0.5f);
            this.vel.normalize();
            this.vel.y = 0.1f;
            this.vel.scale(3.73f);
        }

        public Particle(float[] pp, int idx) {
            SuttuPart.this.getClass();
            this.time = 0.0f;
            this.idx = 0;
            this.t0 = 0.0f;
            this.pp = pp;
            this.idx = idx;
            this.reset();
        }

        public void animate(float t) {
            if (this.time < t) {
                this.reset();
                this.t0 = t + (this.time - 9.0f) + (float)Math.random() * 1.1f;
                this.time = t + 10.0f;
            } else {
                float dt = t - this.t0;
                int n2 = this.idx;
                this.pp[n2] = this.pp[n2] + dt * this.vel.x;
                int n3 = this.idx + 1;
                this.pp[n3] = this.pp[n3] + dt * this.vel.y;
                int n4 = this.idx + 2;
                this.pp[n4] = this.pp[n4] + dt * this.vel.z;
                this.t0 = t;
            }
        }
    }

    class HomoParticle
    extends Particle {
        public void reset() {
            this.pp[this.idx] = 0.0f;
            this.pp[this.idx + 1] = 0.0f;
            this.pp[this.idx + 2] = 0.0f;
            this.vel = new Vector3f(rnd.nextFloat() - 0.5f, rnd.nextFloat() - 0.7f, rnd.nextFloat() - 0.5f);
            this.vel.normalize();
            this.vel.scale(1.0f + rnd.nextFloat());
        }

        HomoParticle(float[] pp, int idx) {
            super(pp, idx);
            SuttuPart.this.getClass();
        }
    }
}

