#include "init.h"

#define MAX_MODULES 10

Module *module;
int do_sound_config=0,speed=70;
unsigned int timer=0;

void timercounter() {
    timer++;
}

void init_sounds() {
    int i;
    module=(Module *)halloc(sizeof(Module)*MAX_MODULES);
    for(i=0;i<MAX_MODULES;i++) {
        module[i].module=0;
        module[i].playing=0;
        module[i].playhandle=0;
    }
    /* hug Midas */
    MIDASstartup();
    if(do_sound_config) MIDASconfig();
    MIDASinit();
    MIDASstartBackgroundPlay(0);
    timer=0;
    if(!MIDASsetTimerCallbacks(speed*1000,FALSE,&timercounter,NULL,NULL)) {
        error(SOUND_ERROR,"Can't set new callback!\n!\n");
    }
}

int load_module(char *file) {
    int i,found=0;
    for(i=0;i<MAX_MODULES;i++) {
        if(module[i].module==0) { found=1; break; }
    }
    if(!found) error(MEMORY_ERROR,"Not enough module places!\n");
    module[i].module=MIDASloadModule(file);
    if(!module[i].module) error(FILE_ERROR,"Can't load file %s!\n",file);
    module[i].playing=0;
    return i;
}

void free_module(int mod) {
    if(module[mod].playing) stop_module(mod);
    if(module[mod].module) MIDASfreeModule(module[mod].module);
    module[mod].module=0;
}

void play_module(int mod) {
    if(module[mod].playing) return;
    module[mod].playhandle=MIDASplayModule(module[mod].module,TRUE);
    module[mod].playing=1;
}

void stop_module(int mod) {
    if(!module[mod].playing) return;
    MIDASstopModule(module[mod].playhandle);
    module[mod].playing=0;
}

void deinit_sounds() {
    int i;
    for(i=0;i<MAX_MODULES;i++) {        
        if(module[i].playing) stop_module(i);
        if(module[i].module) free_module(i);
    }
    MIDASremoveTimerCallbacks();
    MIDASstopBackgroundPlay();
    MIDASclose();
}
