#ifndef _SCREEN_H_
#define _SCREEN_H_

#define PACKED __attribute__ ((packed))
#define LINEAR(a) (((a&0xFFFF0000)>>12)+(a&0xFFFF))

#define MODEFLAG_BANKED   0x0000
#define MODEFLAG_LINEAR   0x4000
#define MODEFLAG_CLEAR    0x0000
#define MODEFLAG_PRESERVE 0x8000

typedef unsigned long int dword;
typedef unsigned short int word;
typedef signed long int s_dword;
typedef signed short int s_word;
typedef unsigned char byte;
typedef unsigned bit;

typedef struct {
  byte sign[4]            PACKED;
  word version            PACKED;
  dword OEMstring         PACKED;

  dword reserved1         PACKED;

  dword videomodeptr      PACKED;
  word totalmemory        PACKED;

  byte reserved2[492]     PACKED;
} vesa_information;

typedef struct {
  bit modesupported : 1         PACKED;
  bit reserved : 1              PACKED;
  bit TTYsupported : 1          PACKED;
  bit colormode : 1             PACKED;
  bit graphicsmode : 1          PACKED;
  bit notVGAcompatible : 1      PACKED;
  bit notVGAwindowmemory : 1    PACKED;
  bit linearavailable : 1       PACKED;

  byte reserved1[15]            PACKED;

  word bpl                      PACKED;
  word width                    PACKED;
  word height                   PACKED;
  byte charwidth                PACKED;
  byte charheight               PACKED;
  byte planes                   PACKED;
  byte bpp                      PACKED;
  byte banks                    PACKED;
  byte memorymodel              PACKED;
  byte banksize                 PACKED;
  byte imagepages               PACKED;

  byte reserved3[10]           PACKED;
  dword physicalbaseptr         PACKED;
  byte reserved4[212]           PACKED;
} vesa_mode_information PACKED;

extern unsigned int *screen,scrsize,bpp;
extern void (*flip_screen)();
extern void (*deinit_gfx)();

void init_gfx();
void deinit_vesa();
void set_gfx_mode();

int vesa_int(byte function,__dpmi_regs *regs);
int vesa_init();
int vesa_mapphysical(dword *linear,s_dword *segment,dword physaddr,dword size);
void vesa_unmap_physical(dword *linear, s_dword *segment);
int vesa_get_mode_info(word mode);
int vesa_set_mode(int mode);
int vesa_search_mode(int w,int h,int d);
int vesa_search_and_set_mode(int w,int h,int d);
void vesa_deinit();

void vesa_flip_screen_32();
void vesa_flip_screen_24();
void vesa_flip_screen_16();

#endif
