#include "init.h"
#include <stdio.h>
#include <stdarg.h>

void font_printf(Font *font,int x,int y,const unsigned char *f,...) {
    va_list v;
    unsigned char buffer[2049];
    va_start(v,f);
    vsprintf(buffer,f,v);
    draw_string(font,x,y,buffer);
    va_end(v);
}

void draw_string(Font *font,int x,int y,const unsigned char *f) {
    int i,chars=strlen(f);

    for(i=0;i<chars;i++) {
        if(f[i]==0) break;
        if(font->loaded[(uint)f[i]]) {
            draw_bitmap(font->letters[(uint)f[i]],x,y);
            x+=font->letters[(uint)f[i]]->w+2;
        } else {
            if(f[i]==32) x+=font->space;
        }
    }
    va_end(v);
}
