#include "init.h"
#include "pcxhead.h"

bitmap *create_bitmap(int w,int h) {
    bitmap *b;
    b=halloc(sizeof(bitmap));
    b->w=w;
    b->h=h;
    b->size=w*h;
    b->data=(unsigned int *)halloc(w*h*4);
    return b;
}

bitmap *load_pcx_bitmap(char *file) {
   int i;
   FILE *f;
   bitmap *b;
   char *buf;
   unsigned char b1,b2;
   pcx_header header;
   f=fopen(file,"rb");
   if(f==0) error(FILE_ERROR,"Can't open file %s",file);
   fread(&header,128,1,f);
   if(header.version!=5) error(FILE_ERROR,"Error in file %s (VER)",file);
   header.width+=2;
   header.height++;
   b=create_bitmap(header.width,header.height);
   buf=(char *)b->data;
   fseek(f,127,SEEK_SET);
   for(i=0;i<header.width*header.height;i++) b->data[i]=0;
   for(i=0;i<header.width*header.height*4;) {
       b1=fgetc(f);
       if(b1>192) {
           b2=fgetc(f);
           for(;b1>192;b1--) { buf[i]=b2; i+=4; }
       } else { buf[i]=b1; i+=4; }
   }
   for(i=1;i<header.width*header.height*4;) {
       b1=fgetc(f);
       if(b1>192) {
           b2=fgetc(f);
           for(;b1>192;b1--) { buf[i]=b2; i+=4; }
       } else { buf[i]=b1; i+=4; }
   }
   for(i=2;i<header.width*header.height*4;) {
       b1=fgetc(f);
       if(b1>192) {
           b2=fgetc(f);
           for(;b1>192;b1--) { buf[i]=b2; i+=4; }
       } else { buf[i]=b1; i+=4; }
   }
   fclose(f);
   return b;
}

bitmap *load_raw_bitmap(char *file,int w,int h) {
   int i,j;
   FILE *f;
   bitmap *b;
   char *buf;
   f=fopen(file,"rb");
   if(f==0) error(FILE_ERROR,"Can't open file %s",file);
   b=create_bitmap(w,h);
   buf=(char *)b->data;
   for(j=i=0;i<w*h;i++) {
       buf[j++]=fgetc(f);
       buf[j++]=fgetc(f);
       buf[j++]=fgetc(f);
       buf[j++]=0;
   }
   fclose(f);
   return b;
}

void do_bitmap_mask(bitmap *b,unsigned int mask) {
    int i;
    b->mask=(unsigned int *)halloc(b->w*b->h*4);
    for(i=0;i<b->w*b->h;i++) {
        if(b->data[i]==mask) {
            b->mask[i]=0xffffffff;
            b->data[i]=0;
        }
        else b->mask[i]=0x00000000;
    }
}
