#include <stdio.h>
#include <stdlib.h>

#define INIT_X 6
#define INIT_Y 4

#define GRID_SIZE 16
#define MAX_DEPTH 5

typedef struct
{
 int X,Y,Count;
}TPos;

char *Grid0[GRID_SIZE] = {
 "adbdcdbdddcbdbab",
 "bccbddbccaadcdaa",
 "dabdacdbbdacaccd",
 "cdababcacbdcadca",
 "baadab????dbaddb",
 "addbdaadcdaddcba",
 "adcacdabcabcaadc",
 "acadcbddbbcdcccd",
 "bdbaadaaabdcaaba",
 "adadbccbdacddcdb",
 "dbaaddbcbdbbbcaa",
 "dccbdcbaacaaacad",
 "cbdacbcadcbdddcc",
 "dbaadbacdcaaacab",
 "dbcdcdbadbbbdaca",
 "dcddccdcccacdcdb"
};
  char Grid[GRID_SIZE][GRID_SIZE];
  char GridMask[GRID_SIZE][GRID_SIZE];
  TPos SuggPos[MAX_DEPTH];
//  int Depths[MAX_DEPTH]={256,256,0,0,0};
  int Depths[MAX_DEPTH]={256,256,25,20,15};
  int Lines[GRID_SIZE]={256,256,150,100,80,70,65,60,60,60,60,60,60,60,60,60};

void OrderSuggPos(TPos *SP)
{
  int I,V,P,X,Y,C;

  V=SP[0].Count;
  P=0;
  for(I=1;I<MAX_DEPTH;I++)
  {
	if(SP[I].X == -1) break;
	if(SP[I].Count > V)
	{
	  P=I;
	  V=SP[I].Count;
	}
  }
  if(P!=0)
  {
	X=SP[P].X;
	Y=SP[P].Y;
	C=SP[P].Count;
	SP[P].X=SP[0].X;
	SP[P].Y=SP[0].Y;
	SP[P].Count=SP[0].Count;
	SP[0].X=X;
	SP[0].Y=Y;
	SP[0].Count=C;
  }
}

void ClearSuggPos(int Depth)
{
  int I;

  for(I=Depth;I<MAX_DEPTH;I++)
  {
	SuggPos[I].X=-1;
	SuggPos[I].Y=-1;
	SuggPos[I].Count=65535;
  }
}

int GetDepth(int Nb)
{
  int I;

  for(I=MAX_DEPTH-1;I>=0;I--)
	if(Nb<=Depths[I]) return I+1;
  return 1;
}

int GetLines(int Nb)
{
  int I;

  for(I=GRID_SIZE;I>=0;I--)
	if(Nb<=Lines[I]) return I+1;
  return 1;
}

void ClearGridMask()
{
  int X,Y;

  for(Y=0;Y<GRID_SIZE;Y++)
	for(X=0;X<GRID_SIZE;X++)
	  GridMask[Y][X]=' ';
}

void Fall(char G[GRID_SIZE][GRID_SIZE])
{
  int X,Y,I,Nb;

  for(Y=GRID_SIZE-1;Y>=0;Y--)
  {
	for(X=GRID_SIZE-1;X>=0;X--)
	{
	  Nb=0;
	  while((G[Y][X] == '?') && (Nb < Y))
	  {
		for(I=Y;I>=1;I--)
		  G[I][X]=G[I-1][X];
		G[0][X]='?';
		Nb++;
	  }
	}
  }
}

// X,Y = pos TO check
int CheckClusterRec(char G[GRID_SIZE][GRID_SIZE],int Len,int X,int Y,char Col)
{
  if(Col!=G[Y][X]) return Len;
  Len++;
  GridMask[Y][X]='*';
  if((X-1)>=0)
	if(GridMask[Y][X-1] == ' ')
	  Len=CheckClusterRec(G,Len,X-1,Y,Col);
  if((X+1)<GRID_SIZE)
	if(GridMask[Y][X+1] == ' ')
	  Len=CheckClusterRec(G,Len,X+1,Y,Col);
  if((Y-1)>=0)
	if(GridMask[Y-1][X] == ' ')
	  Len=CheckClusterRec(G,Len,X,Y-1,Col);
  if((Y+1)<GRID_SIZE)
	if(GridMask[Y+1][X] == ' ')
	  Len=CheckClusterRec(G,Len,X,Y+1,Col);
  return Len;
}

int CheckCluster(char G[GRID_SIZE][GRID_SIZE])
{
  int X,Y,Len,I,J,ret;

  ret=0;
  for(Y=0;Y<GRID_SIZE;Y++)
	for(X=0;X<GRID_SIZE;X++)
	{
	  if(G[Y][X]!='?')
	  {
		ClearGridMask();
		Len=CheckClusterRec(G,0,X,Y,G[Y][X]);
		if(Len>=4)
		{
		  ret=1;
		  for(J=0;J<GRID_SIZE;J++)
			for(I=0;I<GRID_SIZE;I++)
			  if(GridMask[J][I]!=' ')
				G[J][I]='?';
		}
	  }
	}
  return ret;
}

void DoClic(int PX,int PY)
{
  int res;

  printf("%x\n",(PY<<4)+PX);
  if(Grid[PY][PX] == '?') return;
  Grid[PY][PX]='?';
  do
  {
	Fall(Grid);
	res=CheckCluster(Grid);
  }
  while(res);
}

int CountGridBlocs(char G[GRID_SIZE][GRID_SIZE])
{
  int X,Y,Nb;

  Nb=0;
  for(Y=0;Y<GRID_SIZE;Y++)
	for(X=0;X<GRID_SIZE;X++)
	  if(G[Y][X]!='?') Nb++;
  return Nb;
}

void SimuleClick(char G[GRID_SIZE][GRID_SIZE],int X,int Y)
{
  int res;

  if(G[Y][X] == '?') return;
  G[Y][X]='?';
  do
  {
	Fall(G);
	res=CheckCluster(G);
  }
  while(res);
}

int SuggestRec(int PrevCount,int Prof,int Max,int PX,int PY,char G[GRID_SIZE][GRID_SIZE])
{
  char MyG[GRID_SIZE][GRID_SIZE];
  int X,Y,Nb,ONb,Lin,res;

  memcpy(MyG,G,sizeof(MyG));
  SimuleClick(MyG,PX,PY);
  res=CountGridBlocs(MyG);
  ClearSuggPos(Prof);
  if(Prof>=Max) return res;
  ONb=res;
  Lin=GetLines(res);
  for(Y=GRID_SIZE-1;Y>=GRID_SIZE-Lin;Y--)
	for(X=0;X<GRID_SIZE;X++)
	{
	  if(MyG[Y][X]!='?')
	  {
		Nb=SuggestRec(res,Prof+1,Max,X,Y,MyG);
		if(Nb<ONb)
		{
		  SuggPos[Prof].X=X;
		  SuggPos[Prof].Y=Y;
		  SuggPos[Prof-1].Count=PrevCount-res;
		  SuggPos[Prof].Count=res-Nb;
		  ONb=Nb;
		}
	  }
	}
  return ONb;
}

void Suggest()
{
  int X,Y,Count,Nb,ONb,Lin,Dep;
  TPos SP[MAX_DEPTH];

  ONb=65535;
  Count=CountGridBlocs(Grid);
  Dep=GetDepth(Count);
  Lin=GetLines(Count);
  for(Y=GRID_SIZE-1;Y>=GRID_SIZE-Lin;Y--)
	for(X=0;X<GRID_SIZE;X++)
	{
	  if(Grid[Y][X]!='?')
	  {
		ClearSuggPos(0);
		Nb=SuggestRec(Count,1,Dep,X,Y,Grid);
		if(Nb<ONb)
		{
		  ONb=Nb;
		  SuggPos[0].X=X;
		  SuggPos[0].Y=Y;
		  memcpy(SP,SuggPos,sizeof(SP));
		}
		else if(Nb == ONb)
		{
		  if(SuggPos[0].Count > SP[0].Count)
		  {
			SuggPos[0].X=X;
			SuggPos[0].Y=Y;
			memcpy(SP,SuggPos,sizeof(SP));
		  }
		}
	  }
	}
  OrderSuggPos(SP);
  memcpy(SuggPos,SP,sizeof(SuggPos));
}

void Solve()
{
  while(CountGridBlocs(Grid)!=0)
  {
	Suggest();
	DoClic(SuggPos[0].X,SuggPos[0].Y);
  }
}

int main(int argc,char *argv[])
{
  int i;
  for(i=0;i<GRID_SIZE;i++)
	memcpy(Grid[i],Grid0[i],GRID_SIZE);
  Grid[INIT_Y][INIT_X+0]=argv[1][0];
  Grid[INIT_Y][INIT_X+1]=argv[1][1];
  Grid[INIT_Y][INIT_X+2]=argv[1][2];
  Grid[INIT_Y][INIT_X+3]=argv[1][3];
  Solve();
  return 0;
}