// Camera
#include "table.inc"
#include "cage.inc"
#include "plume.inc"
#include "aquarium.inc"
#include "rideau.inc"
#include "cat.inc"

#declare areaLights=on ;
#declare radio=on ;
#declare Rtable=on ;
#declare Rcage=on ;
#declare Rplume=on ;
#declare Raquarium=on ;
#declare Rrideau=on ;
#declare Rcat=on ;
#declare Rpoil=0 ;
#declare atmos=off ;


global_settings {
      max_trace_level 8
      #if (radio)
      radiosity {
         count 130 
         error_bound 0.06
         gray_threshold 0.4
         distance_maximum 0
         low_error_factor 0.85
         nearest_count 5
         minimum_reuse 0.01
         brightness 3.3
         recursion_limit 1
      }
   #end
}


#declare cm_location=<20,100,-400>;
#declare cm_look_at=<0,0,40> ;
#declare cm_prop=<4,3,0> ;
#declare cm_angle=5 ;


#declare cm_location=<20,50,-400>;
#declare cm_look_at=<10,15,0> ;
#declare cm_prop=<3,2,0> ;
#declare cm_angle=10 ;

#include "camera/Camera.inc"

light_source {
	 #local lightLocation=<20, 10, -1000> ;
	 lightLocation,
	 color <1,1,1>
	 fade_distance vlength(lightLocation)*0.5
	 fade_power 3
	 
	 shadowless	 
	 media_interaction off
}


light_source {
	 <20, 40, 40>*2,
	 color <1,1,1>
	 
	 spotlight
	 point_at <0,0,40>
	 radius 6
	 falloff 15
	 
	 #if (areaLights)
			area_light <8,0,0>/4, <0,5,5>/4, 5, 5
	 
	 #end
	
	 adaptive 1
	 jitter 
//	 scale 10
	 
	 media_interaction off
}

light_source {
	 <-5, 10, -30>*4,
	 color <1,1,1>
	 
	 spotlight
	 point_at <20,0,10>
	 radius 6
	 falloff 30
	 
	 #if (areaLights)
			area_light <8,0,0>/4, <0,5,5>/4, 5, 5
	 
	 #end
	
	 adaptive 1
	 jitter 
//	 scale 10
	 
	 media_interaction off
}

#if (atmos)
#local Atmosphere = 
   media  // Atmosphere
   {
      samples 20,100
      variance 1.0/1000.0
      ratio 0.999
      scattering
      {
         1 ,  rgbt <0.01, 0.01, 0.01,0.4> // isotropic scattering
         extinction 0.01
      }
   }

media { Atmosphere }

#end



// La table...
#if (Rtable) object { table(600,400,10) } #end
#if (Rcage) object { cage(20, 40, 0.3, 50, 8, 90, 2)
	 rotate y*44 rotate -z*(95.71)
	 translate y*20*1.2 rotate -y*30
	 translate -x*40 }
#end

#if (Rplume)
	 object { plume(10, 0.05, 10, 2, 35, 0.3) translate <0,0,-10> }
	 object { plume(08, 0.05, 10, 1.6, 15, 0.6) rotate y*30 translate <4,0,-14>}
	 object { plume(12, 0.05, 10, 1.6, 25, 0.4) rotate y*(180-80) translate <-1,0,-5>}
	 object { plume(12, 0.05, 10, 1.6, 25, 0.4) rotate y*(200) translate <8,0,-40>}
	 object { plume(10, 0.05, 10, 2, 35, 0.6) rotate -y*70 translate <30,0,-55>}
	 object { plume(12, 0.05, 10, 1.6, 25, 0.4) rotate -y*60 translate <-10,0,-50>}
#end

// Aquarium..
#if (Raquarium)
	 object { aquarium(15, 0.2, -0.5) translate <35, 0, 50> }
#end

// Les rideau
#if (Rrideau)
	 object { rideau(10, 5, 100, 200) translate <0,1,80> }
#end

// La queue du chat
#if (Rcat)
	 object { queueDuChat(30, 2, 80, 0.3, Rpoil) translate <40,4,-50> }
#end
