/* rotozoom.c - 
   Copyright (C) 2000 Tijs van Bakel and Jorik Blaas.
   Tijs van Bakel <smoke@casema.net>
   Jorik Blaas <jrk@panic.et.tudelft.nl>
 
 This file is part of a silly intro
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with This program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdlib.h>
#include <math.h>

#include "rotozoom.h"
#include "palettecruncher.h"

#include "crap_png.h"
#include "crap_lib.h"
#include "crap_mod.h"
#include "crap_font.h"

Image* temp_scroll_image;
Palette* _crunched_palette;
Palette texture1_palette;
Palette texture2_palette;
Image* background_image;
Image* texture1_image;
Image* texture2_image;
Image texture_subimage;

Image* moon_image;

Image* animal_image1;
Image* animal_image2;
Image* animal_image3;

Image* credits_image;

Image* _scroll_image1;
Image* _scroll_image2;

typedef void (*rotoproc) (uint8* src, uint8* dest);

#define VWIDTH 320
#define VHEIGHT 200

void add_rotozoom ( Image* dest_image, Image* src_image,
		    float theta, float r,
		    float cx, float cy, int u_offset, int v_offset,
		    int width, int height )
{
  int ESI_OFS[8] = {
    39+2,39+2+6+6,9+2,9+2+6+6,
    39+2+6,39+2+6+6+6,9+2+6,9+2+6+6+6
  };
  #define EDI_OFS0 (63+2)
  #define EDI_OFS1 (63+6+2)

  /* AL BL AH BH  AL BL AH BH */
  /* AH AL AH AL  BH BL BH BL */
  
  uint8 add_code[] =
  {
    0x60, 
    0x89, 0xe5,         /* movl %esp, %ebp */
    0x8b, 0x75, 0x24,   /* movl 0x24(%ebp),%esi */
    0x8b, 0x7d, 0x28,   /* movl 0x28(%ebp),%edi */

    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x01, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x61,               /* popa */
    0xc3 };             /* ret */

  uint8* dest = dest_image->buffer;
  uint8* src = src_image->buffer;

  rotoproc add_code_caller;
  
  /* screencoords */
  int x,y; 
  int ofs; /* textureoffsets */
  
  /* texture coords inside one block */
  int u,v; 
  int u0,v0; /* initial values */
  int dudx,dvdx,dudy,dvdy;
  float fdudx,fdvdx,fdudy,fdvdy;
  
  /* block coordinates */
  int bx,by;
  int bu,bv;
  int bu0,bv0; /* initial values */
  
  int dudx_shl_3,dvdx_shl_3,dudy_shl_3,dvdy_shl_3;
  
  uint8* src_ptr;
  uint8 *ptr;

  int pos;
  uint32 edi_ofs, esi_ofs;

  fdudx = ( (cos(theta/65536.0*2*M_PI) * r));
  fdvdx = ( (-sin(theta/65536.0*2*M_PI) * r));
  
  fdudy = ( (sin(theta/65536.0*2*M_PI) * r));
  fdvdy = ( (cos(theta/65536.0*2*M_PI) * r));

  dudx_shl_3 = fdudx * 8.0;
  dudy_shl_3 = fdudy * 8.0;
  dvdx_shl_3 = fdvdx * 8.0;
  dvdy_shl_3 = fdvdy * 8.0;

  dudx = dudx_shl_3 >> 3;
  dvdx = dvdx_shl_3 >> 3;
  dudy = dudy_shl_3 >> 3;
  dvdy = dvdy_shl_3 >> 3;
  
  bu0 = (-cy*fdudy + -cx*fdudx);
  bv0 = (-cy*fdvdy + -cx*fdvdx);
  
  /* do precalcs */
  
  u0 = 0;
  v0 = 0;
  
  for (y = 0; y < 8; y++)
    {
      u = u0;
      v = v0;
      for (x = 0; x < 8; x++)
        {
	  esi_ofs = ( u >> 8 ) + ( v & ~255 );

	  pos = y * 66;

	  add_code[ESI_OFS[x]+0+pos] = (esi_ofs)&255;
	  add_code[ESI_OFS[x]+1+pos] = (esi_ofs>>8)&255;
	  add_code[ESI_OFS[x]+2+pos] = (esi_ofs>>16)&255;
	  add_code[ESI_OFS[x]+3+pos] = (esi_ofs>>24)&255;
	  
	  u += dudx;
	  v += dvdx;
        }
      
      pos = y * 66;
      
      edi_ofs = y * VWIDTH;
      add_code[EDI_OFS0+pos] = (edi_ofs)&255;
      add_code[EDI_OFS0+1+pos] = (edi_ofs>>8)&255;
      add_code[EDI_OFS0+2+pos] = (edi_ofs>>16)&255;
      add_code[EDI_OFS0+3+pos] = (edi_ofs>>24)&255;
      edi_ofs = y * VWIDTH + 4;
      add_code[EDI_OFS1+pos] = (edi_ofs)&255;
      add_code[EDI_OFS1+1+pos] = (edi_ofs>>8)&255;
      add_code[EDI_OFS1+2+pos] = (edi_ofs>>16)&255;
      add_code[EDI_OFS1+3+pos] = (edi_ofs>>24)&255;
      
      u0 += dudy;
      v0 += dvdy;
    }

  add_code_caller = (rotoproc) add_code;

  /* draw 32x25 blocks of 8x8 pixels */
  for (by = 0; by < (height/8); by++)
    {
      bu = bu0;
      bv = bv0;
      for (bx = 0; bx < (width/8); bx++)
        {
	  u0 = bu & 255;
	  v0 = bv & 255;
	  
	  ofs = (((bu+u_offset*256)&(65535-255))>>8)
	    + ((bv+v_offset*256)&(65535-255));
	  
	  src_ptr = src + ofs;
	  ptr = dest + (bx<<3) + VWIDTH*(by<<3);

	  add_code_caller( src_ptr, ptr );
	  
	  bu += dudx_shl_3;
	  bv += dvdx_shl_3;
        }
      bu0 += dudy_shl_3;
      bv0 += dvdy_shl_3;
    }
}

/*
  src_image = 256x256,
  dest_image = 320x200
*/
void mov_rotozoom ( Image* dest_image, Image* src_image,
		    float theta, float r,
		    float cx, float cy,
		    int u_offset, int v_offset,
		    int width, int height )
{
  int ESI_OFS[8] = {
    39+2,39+2+6+6,9+2,9+2+6+6,
    39+2+6,39+2+6+6+6,9+2+6,9+2+6+6+6
  };
  #define EDI_OFS0 (63+2)
  #define EDI_OFS1 (63+6+2)
  
  uint8 mov_code[] =
  {
    0x60, 
    0x89, 0xe5,         /* movl %esp, %ebp */
    0x8b, 0x75, 0x24,   /* movl 0x24(%ebp),%esi */
    0x8b, 0x7d, 0x28,   /* movl 0x28(%ebp),%edi */

    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x61,               /* popa */
    0xc3 };             /* ret */

  uint8* dest = dest_image->buffer;
  uint8* src = src_image->buffer;

  rotoproc mov_code_caller;
  
  /* screencoords */
  int x,y; 
  int ofs; /* textureoffsets */
  
  /* texture coords inside one block */
  int u,v; 
  int u0,v0; /* initial values */
  int dudx,dvdx,dudy,dvdy;
  float fdudx,fdvdx,fdudy,fdvdy;
  
  /* block coordinates */
  int bx,by;
  int bu,bv;
  int bu0,bv0; /* initial values */
  
  int dudx_shl_3,dvdx_shl_3,dudy_shl_3,dvdy_shl_3;
  
  uint8* src_ptr;
  uint8 *ptr;

  int pos;
  uint32 edi_ofs, esi_ofs;

  fdudx = ( (cos(theta/65536.0*2*M_PI) * r));
  fdvdx = ( (-sin(theta/65536.0*2*M_PI) * r));
  
  fdudy = ( (sin(theta/65536.0*2*M_PI) * r));
  fdvdy = ( (cos(theta/65536.0*2*M_PI) * r));

  dudx_shl_3 = fdudx * 8.0;
  dudy_shl_3 = fdudy * 8.0;
  dvdx_shl_3 = fdvdx * 8.0;
  dvdy_shl_3 = fdvdy * 8.0;

  dudx = dudx_shl_3 >> 3;
  dvdx = dvdx_shl_3 >> 3;
  dudy = dudy_shl_3 >> 3;
  dvdy = dvdy_shl_3 >> 3;
  
  bu0 = (-cy*fdudy + -cx*fdudx);
  bv0 = (-cy*fdvdy + -cx*fdvdx);
  
  /* do precalcs */
  
  u0 = 0;
  v0 = 0;
  
  for (y = 0; y < 8; y++)
    {
      u = u0;
      v = v0;
      for (x = 0; x < 8; x++)
        {
	  esi_ofs = ( u >> 8 ) + ( v & ~255 );

	  pos = y * 66;

	  mov_code[ESI_OFS[x]+0+pos] = (esi_ofs)&255;
	  mov_code[ESI_OFS[x]+1+pos] = (esi_ofs>>8)&255;
	  mov_code[ESI_OFS[x]+2+pos] = (esi_ofs>>16)&255;
	  mov_code[ESI_OFS[x]+3+pos] = (esi_ofs>>24)&255;
	  
	  u += dudx;
	  v += dvdx;
        }
      
      pos = y * 66;
      
      edi_ofs = y * VWIDTH;
      mov_code[EDI_OFS0+pos] = (edi_ofs)&255;
      mov_code[EDI_OFS0+1+pos] = (edi_ofs>>8)&255;
      mov_code[EDI_OFS0+2+pos] = (edi_ofs>>16)&255;
      mov_code[EDI_OFS0+3+pos] = (edi_ofs>>24)&255;

      edi_ofs = y * VWIDTH + 4;
      mov_code[EDI_OFS1+pos] = (edi_ofs)&255;
      mov_code[EDI_OFS1+1+pos] = (edi_ofs>>8)&255;
      mov_code[EDI_OFS1+2+pos] = (edi_ofs>>16)&255;
      mov_code[EDI_OFS1+3+pos] = (edi_ofs>>24)&255;
      
      u0 += dudy;
      v0 += dvdy;
    }

  mov_code_caller = (rotoproc) mov_code;

  /* draw 32x25 blocks of 8x8 pixels */
  for (by = 0; by < (height/8); by++)
    {
      bu = bu0;
      bv = bv0;
      for (bx = 0; bx < (width/8); bx++)
        {
	  u0 = bu & 255;
	  v0 = bv & 255;
	  
	  ofs = (((bu+u_offset*256)&(65535-255))>>8)
	    + ((bv+v_offset*256)&(65535-255));
	  
	  src_ptr = src + ofs;
	  ptr = dest + (bx<<3) + VWIDTH*(by<<3);

  	  mov_code_caller( src_ptr, ptr ); 
	  
	  bu += dudx_shl_3;
	  bv += dvdx_shl_3;
        }
      bu0 += dudy_shl_3;
      bv0 += dvdy_shl_3;
    }
}

/* 
   this version uses code unrolling in x86 asm 

   src_image = 256x256,
   dest_image = 320x200
*/
void draw_rotozoom ( Image* dest_image, Image* src_image,
		     float theta, float r, float x0, float y0,
		     int u_offset, int v_offset,
		     int width, int height )
{
/*    int ESI_OFS[8] = { 9+2, 11+6, 11+6+6, 11+6+6+6, */
/*  		     39+2, 41+6, 41+6+6, 41+6+6+6 }; */
/*    int ESI_OFS[8] = { */
/*      9+2+6+6+6, 9+2+6, 39+2+6+6+6, 39+2+6, */
/*      9+2+6+6, 9+2, 39+2+6+6, 39+2, */
/*    }; */
  int ESI_OFS[8] = {
    39+2,39+2+6+6,9+2,9+2+6+6,
    39+2+6,39+2+6+6+6,9+2+6,9+2+6+6+6
  };
  #define EDI_OFS0 (63+2)
  #define EDI_OFS1 (63+6+2)
  
/*  	movb	0x13131313(%esi),%al		# u */
/*  	movb	0x13131313(%esi),%bl		# v */
/*  	movb	0x13131313(%esi),%ah		# u */
/*  	movb	0x13131313(%esi),%bh		# v */
/*  	shll	$16, %eax		# u */
/*  	shll	$16, %ebx		# u */
/*  	movb	0x13131313(%esi),%al		# u */
/*  	movb	0x13131313(%esi),%bl		# v */
/*  	movb	0x13131313(%esi),%ah		# u */
/*  	movb	0x13131313(%esi),%bh		# v */
/*  	movl	%eax, 0x12000004(%edi)	# u */
/*  	movl	%ebx, 0x13131313(%edi) */
  
  uint8 code[] =
  {
    0x60, 
    0x89, 0xe5,         /* movl %esp, %ebp */
    0x8b, 0x75, 0x24,   /* movl 0x24(%ebp),%esi */
    0x8b, 0x7d, 0x28,   /* movl 0x28(%ebp),%edi */

    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0xc1, 0xe0, 0x10,
    0xc1, 0xe3, 0x10,
    0x8a, 0x86, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0x9e, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x8a, 0xbe, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x87, 0x00, 0x00, 0x00, 0x00,
    0x89, 0x9f, 0x00, 0x00, 0x00, 0x00,
    
    0x61,               /* popa */
    0xc3 };             /* ret */

  uint8* dest = dest_image->buffer;
  uint8* src = src_image->buffer;

  rotoproc code_caller;
  
  /* screencoords */
  int x,y; 
  int ofs; /* textureoffsets */
  
  /* texture coords inside one block */
  int u,v; 
  int u0,v0; /* initial values */
  int dudx,dvdx,dudy,dvdy;
  float fdudx,fdvdx,fdudy,fdvdy;
  
  /* block coordinates */
  int bx,by;
  int bu,bv;
  int bu0,bv0; /* initial values */
  
  int dudx_shl_3,dvdx_shl_3,dudy_shl_3,dvdy_shl_3;
  
  uint8* src_ptr;
  uint8 *ptr;

  int pos;
  uint32 edi_ofs, esi_ofs;

  fdudx = ( (cos(theta/65536.0*2*M_PI) * r));
  fdvdx = ( (-sin(theta/65536.0*2*M_PI) * r));
  
  fdudy = ( (sin(theta/65536.0*2*M_PI) * r));
  fdvdy = ( (cos(theta/65536.0*2*M_PI) * r));

  dudx_shl_3 = fdudx * 8.0;
  dudy_shl_3 = fdudy * 8.0;
  dvdx_shl_3 = fdvdx * 8.0;
  dvdy_shl_3 = fdvdy * 8.0;

  dudx = dudx_shl_3 >> 3;
  dvdx = dvdx_shl_3 >> 3;
  dudy = dudy_shl_3 >> 3;
  dvdy = dvdy_shl_3 >> 3;
  
  bu0 = (-y0*fdudy + -x0*fdudx);
  bv0 = (-y0*fdvdy + -x0*fdvdx);
  
  /* do precalcs */
  
  u0 = 0;
  v0 = 0;
  
  for (y = 0; y < 8; y++)
    {
      u = u0;
      v = v0;
      for (x = 0; x < 8; x++)
        {
	  esi_ofs = ( u >> 8 ) + ( v & ~255 );

	  pos = y * 66;

	  code[ESI_OFS[x]+0+pos] = (esi_ofs)&255;
	  code[ESI_OFS[x]+1+pos] = (esi_ofs>>8)&255;
	  code[ESI_OFS[x]+2+pos] = (esi_ofs>>16)&255;
	  code[ESI_OFS[x]+3+pos] = (esi_ofs>>24)&255;
	  
	  u += dudx;
	  v += dvdx;
        }
      
      pos = y * 66;
      
      edi_ofs = y * VWIDTH;
      code[EDI_OFS0+pos] = (edi_ofs)&255;
      code[EDI_OFS0+1+pos] = (edi_ofs>>8)&255;
      code[EDI_OFS0+2+pos] = (edi_ofs>>16)&255;
      code[EDI_OFS0+3+pos] = (edi_ofs>>24)&255;
      edi_ofs = y * VWIDTH + 4;
      code[EDI_OFS1+pos] = (edi_ofs)&255;
      code[EDI_OFS1+1+pos] = (edi_ofs>>8)&255;
      code[EDI_OFS1+2+pos] = (edi_ofs>>16)&255;
      code[EDI_OFS1+3+pos] = (edi_ofs>>24)&255;
      
      u0 += dudy;
      v0 += dvdy;
    }

  code_caller = (rotoproc) code;

  /* draw 32x25 blocks of 8x8 pixels */
  for (by = 0; by < (height/8); by++)
    {
      bu = bu0;
      bv = bv0;
      for (bx = 0; bx < (width/8); bx++)
        {
	  u0 = bu & 255;
	  v0 = bv & 255;
	  
	  ofs = (((bu+u_offset*256)&(65535-255))>>8)
	    + ((bv+v_offset*256)&(65535-255));
	  
	  src_ptr = src + ofs;
	  ptr = dest + (bx<<3) + VWIDTH*(by<<3);

	  code_caller( src_ptr, ptr );
	  
	  bu += dudx_shl_3;
	  bv += dvdx_shl_3;
        }
      bu0 += dudy_shl_3;
      bv0 += dvdy_shl_3;
    }
}

/* we use the cache optimization technique as described by Pascal aka
   Niklas Beisert (sp?) from Cubic Team.  (the original source is
   available from http://www.hornet.org/, the Cubic homepage is at
   http://www.cubic.org/).

   note that i'm using a p100 myself, so i have NO idea how this
   technique works on modern fancy hardware with modern fancy
   caches. please let me know if you're into this.

   the general idea is to split up the innerloop in 8x8 pixelblocks,
   by means of which the cache won't stall as much if the
   dudx/dudy/dvdx/dvdy's are too big (if they are too big, the texture
   is traversed through at too large intervals, and the cache couldn't
   read pixels ahead as happily. experimenting with 16x16 and 4x4
   blocks didn't really help much

   --
   smoke, thinking of giving credit where credit is due :-) */

void
draw_rotozoom_c ( Image* dest, Image* src,
	   float angle, float r )
{
  /* routine is a goner */
}

/* i discovered a buffer overflow here and there were basically three
   ways to solve it:
   
   1) clip better (add a maximal diff to the block borders)
   2) use &65535 in the innerloop, thereby slowing things down
   3) allocate a big empty void, and use a subimage in the middle
      of that so that overflows are of no harm

   of these options, 3 is obviously the ugliest. guess which one i
   chose to use.. (hint: this is why the source image is cropped to
   256x512 instead of the usual 256x256.

   please send in patches for the fastest method, i really don't like
   allocating another 256x256. */

/* max length        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX */
char *scrolltext2 = "gnorky animals farm fun W from rectum cauda holland S";
char *scrolltext1 = "silly releases * cheap plot * but still it took 20Jhrs";

Image* make_rotozoom_image ( Image* src, int x0, int y0, int w, int h )
{
  Image subimage;
  Image* i;
  
  crap_image_subimage ( src, &subimage, x0, y0, w, h );
  i = crap_image_safe_create ( 256, 256 );
  crap_image_blit ( i, 128-w/2, 128-h/2, &subimage );
  return i;
}

void quad_pixel ( Image* dest, int dest_x, int dest_y,
		  Image* src, int src_x, int src_y )
{
  uint8 c = src->buffer[src_x+src_y*src->width];
  dest->buffer[dest_x+dest_y*dest->width] = c;
  dest->buffer[dest_x+1+dest_y*dest->width] = c;
  dest->buffer[dest_x+(1+dest_y)*dest->width] = c;
  dest->buffer[dest_x+1+(1+dest_y)*dest->width] = c;
}

Rotozoom_data* create_fx_rotozoom ( Image* dest_image )
{
  Rotozoom_data* data;
  Image image1;
  Image image2;
  uint8* src;
  uint8* dest;
  int x,y;
  Image temp_image;
  Palette temp_palette;
  
  data = (Rotozoom_data*) malloc ( sizeof(Rotozoom_data) );

  crap_png_load ( &temp_image, &temp_palette, "logo.png" );
  credits_image = crap_image_create ( 64, dest_image->height );
  temp_image.buffer += 320;
  crap_image_blit ( credits_image, 0, 0, &temp_image );
  
  crap_png_load ( &image1, &texture1_palette, "ham.png" );
  crap_png_load ( &image2, &texture2_palette, "slagerij.png" );

  _crunched_palette = crunch_palette( &image1, &image2,
				      &texture1_palette, &texture2_palette );

  texture2_image = crap_image_safe_create ( 256, 256 );
  background_image = crap_image_safe_create (256, 256 );

  animal_image1 = make_rotozoom_image ( &image1, 0, 0, 70, 50 ); // pig
  animal_image2 = make_rotozoom_image ( &image1, 70, 0, 60, 50 ); // kip
  animal_image3 = make_rotozoom_image ( &image1, 130, 0, 50, 50 ); // koe

  moon_image = make_rotozoom_image ( &image1, 190, 50, 100, 160 ); // mooner
  
  crap_image_fill ( background_image, 0 );
  crap_image_blit ( background_image, 0, 0, &image2 );
		   
  crap_image_fill ( background_image, 0 );
  crap_image_blit ( background_image, 0, 0, &image2 );
		   
  texture1_image = make_rotozoom_image ( &image1, 80, 50, 100, 150);

  src = texture1_image->buffer + texture1_image->width - 1;
  dest = texture2_image->buffer;
  /* mirror image into t2 */
  for ( y = 0; y < texture1_image->height; y++ )
    {
      for ( x = 0; x < texture1_image->width; x++ )
	*dest++ = *src--;
      src += 2 * texture1_image->width;
    }
  
  /* render first scrolltext */
  temp_scroll_image = crap_image_create ( crap_pfont_string_width ( crap_get_big_font(), scrolltext1 ), 17 );
    crap_pfont_string ( crap_get_big_font(), temp_scroll_image, 0, 0, scrolltext1 );

  _scroll_image1 = crap_image_create ( temp_scroll_image->height * 2,
				      temp_scroll_image->width * 2);
  for ( y = 0; y < temp_scroll_image->height; y++ )
    for ( x = 0; x < temp_scroll_image->width; x++ )
      {
	quad_pixel ( _scroll_image1, _scroll_image1->width - 2 * ( y + 1 ), 2*x, temp_scroll_image, x, y );
      }

  /* render second scrolltext */
  temp_scroll_image = crap_image_create ( crap_pfont_string_width ( crap_get_big_font(), scrolltext2 ), 17 );
    crap_pfont_string ( crap_get_big_font(), temp_scroll_image, 0, 0, scrolltext2 );

  _scroll_image2 = crap_image_create ( temp_scroll_image->height * 2,
				      temp_scroll_image->width * 2);
  for ( y = 0; y < temp_scroll_image->height; y++ )
    for ( x = 0; x < temp_scroll_image->width; x++ )
      {
	quad_pixel ( _scroll_image2, 2*y, _scroll_image2->height - 2*(x+1), temp_scroll_image, x, y );
      }
  
  
  return data;
}

void fx_rotozoom ( Image* dest, Rotozoom_data* data, int note, int state )
{
  int u,v;
  float r;
  float x,y;
  float angle;
  static int prev_note = 0;
  
  static float counter = 0.0;
  static float scroll_counter = 0.0;
  static int first_time = 1;

  static float scrolpos = 0.0;
  static float scrolpossync = 0.0;

  static int x_pan = 64;

  static int beast = 0;

  if ( first_time )
    {
      first_time = 0;
      crap_image_rect_fill ( dest, 0, 0, 0,dest->width,dest->height );
      crap_setpalette ( _crunched_palette, 0, 128 );
    }

  counter += 1.0;

  scrolpossync = (note/4) * 60.0;
  //  if ( scrolpos < scrolpossync )	
  scrolpos += ( scrolpossync - scrolpos ) * 0.15;

  if ( scrolpos > scrolpossync )
    scrolpos = scrolpossync;

  switch ( state )
    {
    case 0: // animals

      if ( note > 64 + 56 )
	x_pan -= 2;
      if ( x_pan < 0 )
	x_pan = 0;
      
      dest->buffer += x_pan;

      /* funky animal rotations */
      angle = 0.05 * sin ( counter / 32.0 ) * 65535.0;
      x = 128.0;
      y = 92;
      u = 128;
      v = 128;
      r = - cos ( counter / 32.0 ) * 64.0 + 128.0;
      mov_rotozoom ( dest, background_image, angle, r, x, y, u, v, 256, 200-26 );

      angle = 0.25 * sin ( sin ( counter / 32.0 ) + counter / 32.0 ) * 65535.0;

      x = 128.0;
      y = 92.0;
      u = 128;
      v = 128;
      r = cos ( counter / 32.0 ) * 64.0 + 128.0;
      
      if ( ( note > 16 ) && ( note < 64 + 48 ) )
	{
	  if ( note != prev_note )
	    beast++;
	  
	  prev_note = note;
	  
	  switch ( (beast/4) % 3 )
	    {
	    case 0:
	      add_rotozoom ( dest, animal_image1, angle, r, x, y, u, v, 256, 200-26 );
	      break;
	    case 1:
	      add_rotozoom ( dest, animal_image2, angle, r, x, y, u, v, 256, 200-26 );
	      break;
	    case 2:
	      add_rotozoom ( dest, animal_image3, angle, r, x, y, u, v, 256, 200-26 );
	      break;
	    }
	}
	  
      dest->buffer -= x_pan;


      if ( x_pan < 64 )
	{
	  crap_image_rect_fill ( dest, 0, x_pan + 256, 0, 64-x_pan, dest->height );
	}
      else
	{
	  /* draw scroller on the left */
	  
	  crap_image_rect_fill ( dest, 0, 0, 0, 64, dest->height );
	  crap_image_blit ( dest, 16, -25-_scroll_image2->height+scrolpos, _scroll_image2 );
	}
      break;
      
    case 1:  // bert is here
      
      if ( note > 64 + 56 )
	x_pan += 2;
      if ( x_pan > 64 )
	x_pan = 64;
      
      if ( (note/2)&1 )
	counter += 3.0;
  
      dest->buffer += x_pan;
      
      /* funky rotations */
      angle = 0.02 * sin ( counter / 16.0 ) * 65535.0;
      x = 128.0;
      y = 92;
      u = 128;
      v = 128;
      r = - cos ( counter / 32.0 ) * 64.0 + 128.0;
      mov_rotozoom ( dest, background_image,
		     angle, r, x, y, u, v, 256, 200-26 );

      angle = 0.02 * sin ( counter / 16.0 ) * 65535.0;
  
      x = 128.0;
      y = 64.0;
      
      u = 127;
      v = 76;

      r = cos ( counter / 32.0 ) * 128.0 + 192.0;

      if ( note < 64+48+8 )
	{
	  if ( (note/4) & 1 )
	    {
	      add_rotozoom ( dest, texture1_image,
			     angle, r, x, y, u, v, 256, 200-26 );
	    }
	  else
	    {
	      add_rotozoom ( dest, texture2_image,
			     angle, r, x, y, u, v, 256, 200-26 );
	    }
	}

      dest->buffer -= x_pan;
      
      if ( x_pan > 0 )
	{
	  crap_image_rect_fill ( dest, 0, 0, 0, x_pan, dest->height );
	}
      else
	{
	  /* draw scroller on the right */
	  
	  crap_image_rect_fill ( dest, 0, 256, 0, 64, dest->height );
	  crap_image_blit ( dest, 256+16, 200-scrolpos, _scroll_image1 );
	}
      break;

    case 2: // mooning

/*        if ( (note/2)&1 ) */
/*  	counter += 3.0; */
      
      dest->buffer += 64;
      
      angle = 0.02 * sin ( counter / 16.0 ) * 65535.0;

      x = 128.0;
      y = 92;
      u = 128;
      v = 128;
      r = - cos ( counter / 32.0 ) * 64.0 + 128.0;

      mov_rotozoom ( dest, background_image, angle, r, x, y, u, v, 256, 200-26 );

      angle = 0.01 * sin ( sin ( counter / 8.0 ) + counter / 32.0 ) * 65535.0;
      x = 128.0 + sin ( counter / 8.0 ) * 40.0;
      y = 135.0 - fabs ( cos (counter / 8.0) * 30.0 ) + 30.0;
      u = 128;
      v = 160;
      r = cos ( counter / 32.0 ) * 64.0 + 256.0;

      if ( note > 8 )
	add_rotozoom ( dest, moon_image, angle, r, x, y, u, v, 256, 200-26 );

      dest->buffer -= 64;


      scroll_counter += 1.0;
      crap_image_rect_fill ( dest, 0, 0, 0, 64, dest->height );
      { 
	static float nocred_pos = -200.0;
	static float nocred_vel = 0.0;
	int ypos;
	
	nocred_pos += nocred_vel;
	if (nocred_pos > 0 && (nocred_vel > 0))
	  {
	    nocred_vel = -0.69 * nocred_vel;
	    nocred_pos = 0.0;
	  }
	nocred_vel += 0.5;
	ypos = nocred_pos;
	
	crap_image_blit ( dest, 0, ypos , credits_image );
      }
      break;
    }
  
}


