#include "palettecruncher.h"

#include <stdio.h>
#include <stdlib.h>

Palette* crunch_palette( Image * src1, Image * src2,
		Palette * palettesrc1, Palette * palettesrc2 )
{
   int x,y,c, colorcnt1, colorcnt2;
   int colors[256];
   uint8 * src;
   Palette* palettenew;

   uint8 newcolor1[256];
   uint8 newcolor2[256];

   uint8 newcolor1rev[256];
   uint8 newcolor2rev[256];

   memset( colors, 0, sizeof(int) * 256 );

   src = src1->buffer;
   for (y=0;y<src1->height;y++)
     for (x=0;x<src1->width;x++)
       colors[ *src++ ]++;
  
   colorcnt1 = 0;
   for (c=0;c<256;c++)
     if ( colors[c] > 0 )
       newcolor1[ colorcnt1 ++ ] = c;

   memset( colors, 0, sizeof(int) * 256 );

   src = src2->buffer;
   for (y=0;y<src2->height;y++)
   for (x=0;x<src2->width;x++)
     colors[ *src++ ]++;

   colorcnt2 = 0;
   for (c=0;c<256;c++)
     if ( colors[c] > 0 )
       newcolor2[ colorcnt2 ++ ] = c;
   
   printf("Image 1 uses %d colors\n", colorcnt1 );
   printf("Image 2 uses %d colors\n", colorcnt2 );
   printf("Total : %d colors\n", colorcnt1*colorcnt2 );
   fflush(stdout);

   if (colorcnt1 * colorcnt2 > 256)
   {
     printf("too much colors\n");
     exit(4);
   }
   // remap the palette of the images
   for ( c = 0; c < colorcnt1; c++)
     newcolor1rev[newcolor1[c]]=c;
   
   for ( c = 0; c < colorcnt2; c++ )
     newcolor2rev[newcolor2[c]]=c * colorcnt1;

   src = src1->buffer;
   for (y=0;y<src1->height;y++)
     for (x=0;x<src1->width;x++)
       {
	 *src = newcolor1rev[*src];
	 src++;
       }

   src = src2->buffer;
   for (y=0;y<src2->height;y++)
     for (x=0;x<src2->width;x++)
       {
	 *src  = newcolor2rev[*src];
	 src++;
       }

   // all pixels in both images have been remapped

   // time to fix a joined palette

   palettenew = malloc ( sizeof ( Palette ) );
   palettenew->color = malloc ( sizeof ( Color ) * 256 );
   
   for (x=0;x<colorcnt1;x++)
     for (y=0;y<colorcnt2;y++)
       {
	if ( x!=0 )
	{
	 palettenew->color[x+y*colorcnt1].r =
	   palettesrc1->color[newcolor1[x]].r;
	 palettenew->color[x+y*colorcnt1].g =
	   palettesrc1->color[newcolor1[x]].g;
	 palettenew->color[x+y*colorcnt1].b =
	   palettesrc1->color[newcolor1[x]].b;
	} else
	{
	 palettenew->color[x+y*colorcnt1].r =
	    palettesrc2->color[newcolor2[y]].r;
	 palettenew->color[x+y*colorcnt1].g =
	    palettesrc2->color[newcolor2[y]].g;
	 palettenew->color[x+y*colorcnt1].b =
	    palettesrc2->color[newcolor2[y]].b;
	}
	 //	palettenew[x+y*colorcnt1] = pallettesrc1[x] mixed met
	 //				    pallettesrc2[x];
       }
   return palettenew;
}



