#include "config.h"
#include "crap_image.h"
#include "crap_lib.h"
#include "crap_png.h"
#include "crap_video.h"

#ifdef HAVE_MIKMOD
#include <mikmod.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

Image* beer_image;
Image* bg_image;

const int letter_height = 23;
int letter_xleft[11] = { 323,337,348,361,376,392,406,418,430,443,459 };
int letter_xright[11] ={ 333,344,358,372,387,403,416,428,440,453,497 };

typedef struct {
  int x,y,vx,vy;
  uint8 c;
  uint8 enabled;
} pixpos;

#define MAXPIX 14000

pixpos pixels[MAXPIX];
int pixcnt = 0;

#define CENTERX 50
#define CENTERY 70

void addpixel( int x, int y, uint8 c )
{
  float dx,dy,l;
  
  // printf("add %d, %d, %d\n", x,y,c );
  //  fflush( stdout );
  pixels[ pixcnt ].x = (x+10) * 256 + (rand() & 255);
  pixels[ pixcnt ].y = (y+30) * 256 + (rand() & 255);
  pixels[ pixcnt ].c = c;
  dx = -(CENTERX-x);
  dy = -(CENTERY-y);
  l = sqrt( dx*dx + dy*dy );
  dx /= l;
  dy /= l;
  dx *= 400.0 / (l + 1.0 );
  dy *= 400.0 / (l + 1.0 );

  pixels[ pixcnt ].vx = dx*52.0 + (rand() & 15);
  pixels[ pixcnt ].vy = dy*52.0 + (rand() & 15);
  pixels[ pixcnt ].enabled = 1;
  pixcnt ++;
  if (pixcnt == MAXPIX)
    {
      printf("too many pixelz\n");
      exit(3);
    }
}


#define VWIDTH 320
#define VHEIGHT 200

void drawallpix( Image * dst, int splode )
{
  int c;
  uint8 * buf = dst->buffer;
  
  for(c=0;c<pixcnt;c++)
    {
      if (!pixels[c].enabled)
	continue;
      if ( (pixels[c].x<0) || (pixels[c].x>=256*VWIDTH)
	   || (pixels[c].y<0) || (pixels[c].y>=256*VHEIGHT ))
	{
	  pixels[c].enabled = 0;
	  continue;
	};
      buf[ (pixels[c].x>>8) + (pixels[c].y>>8) * VWIDTH ] = pixels[c].c;
      if ( splode )
	{
	  pixels[c].x += pixels[c].vx;
	  pixels[c].y += pixels[c].vy;
	  pixels[c].vy += 1;
	}
    }
}

void prepare_explode( Image * img )
{
  int x,y;
  for(x=0;x<img->width;x++)
    for(y=0;y<img->height;y++)
      if (img->buffer[x+y*img->width] )
	addpixel( x,y, img->buffer[x+y*img->width ]) ;
}

void beer ( Image* dest_image, int seconds )
{
  Image * letters[11];
  Image tmp_image;
  Image tmp_subimage;
  Palette tmp_palette;
  int e, bpp = 32;
  int fnr = 0;
  int first_timer_8bpp = 1;
  int first_timer_16bpp = 1;
  int uitloop_count = 100;

#ifdef HAVE_MIKMOD

  SAMPLE* sample_boom;
  SAMPLE* sample_meuh;

  sample_meuh = Sample_Load ( "meuh.wav" );
  if ( !sample_meuh )
    {
      printf("cannot load sample\n");
      exit(1);
    }
  
  sample_boom = Sample_Load ( "boom.wav" );
  if ( !sample_boom )
    {
      printf("cannot load sample\n");
      exit(1);
    }
  
  MikMod_SetNumVoices(-1, 2);
  MikMod_EnableOutput();
  
#endif

  crap_png_load ( &tmp_image, &tmp_palette, "beer.png" );
  crap_setpalette ( &tmp_palette, 0, 64 );
  
  bg_image = crap_image_create ( 320, 200 );
  beer_image = crap_image_create ( 100, 140 );

  crap_image_subimage ( &tmp_image, &tmp_subimage, 320, 38, 100, 140 );
  crap_image_blit ( beer_image, 0, 0, &tmp_subimage );
  prepare_explode( beer_image );
  
  crap_image_blit ( bg_image, 0, 0, &tmp_image );

  for( e=0;e<11; e++ )
    {
      letters[e] = crap_image_create( letter_xright[e] - letter_xleft[e],
				      letter_height );
      crap_image_subimage( &tmp_image, &tmp_subimage,
			   letter_xleft[e], 0,
			   letter_xright[e] - letter_xleft[e],
			   letter_height );
      
      crap_image_blit( letters[e], 0, 0, &tmp_subimage );
    }

  fnr = 0;
  while (1)
    {
      int xpos = 262;
      int ypos = 100;

      fnr ++;

      crap_image_fill( dest_image, 0 );
      crap_image_blit( dest_image, 0, 0, bg_image );

      if ( bpp == 8 )
	drawallpix( dest_image, 1 ); // splode
      else
	drawallpix( dest_image, 0 ); // blit
      
/*  ypos + letter_height ); */

      if (bpp>=10)
	crap_image_blit( dest_image,
			 xpos-letters[bpp%10]->width - letters[bpp/10]->width - 1,
			 ypos, letters[bpp/10] ); 

      crap_image_blit( dest_image,
		       xpos-letters[bpp%10]->width,
		       ypos,
		       letters[bpp%10] );
      
      crap_image_blit( dest_image, xpos+3, ypos, letters[10] );
      
      crap_video_waitretrace();
      crap_video_blit ( dest_image );

      if ((fnr&15)==0)
	bpp--;
      if ( bpp < 8 )
	bpp = 8;

      if ( (crap_video_keypress()) && ( crap_video_getkey() == CRAP_KEY_ESCAPE ) )
	break;

#ifdef HAVE_MIKMOD
      if ( bpp == 24 )
	{
	  if ( first_timer_16bpp )
	    {
	      first_timer_16bpp = 0;
	      Sample_Play(sample_meuh, 0, 0 );
	    }
	}

      if ( bpp == 11 )
	{
	  if ( first_timer_8bpp )
	    {
	      first_timer_8bpp = 0;
	      Sample_Play(sample_boom, 0, 0 );
	    }
	}

      if ( bpp == 8 )
	{
	  uitloop_count--;
	  if (uitloop_count < 0 )
	    return;
	}

      MikMod_Update();
#endif
    }
}


