;Sin:
Polygon:
  PolyXL: resb 256
  PolyXR: resb 256
  PolyUL: resb 256
  PolyVL: resb 256
  PolyUR: resb 256
  PolyVR: resb 256


Ymin      db 0
Ymax      db 0

x1        dw 0
y1        dw 0
x2        dw 0
y2        dw 0
u1        dw 0
v1        dw 0
u2        dw 0
v2        dw 0
deltax    dw 0
deltau:
deltay    dw 0
deltav    dw 0
xpos      dw 0

; Entres : ES=dest
;           FS=texture (256*256)
;           BX=nde la ligne
TextHLine:

  mov cl,[bx+PolyXR]
  mov ch,0
  sub cl,[bx+PolyXL]  ; cx=(x2-x1)
  jnz .thl_ok
    ret
  .thl_ok:


  mov ah,[bx+PolyUR]
  mov al,0
  sub ah,[bx+PolyUL]  ; ax=(u2-u1) << 8
  cwd                 ; dx:ax=(u2-u1) << 8
  idiv cx             ; ax=((u2-u1)<<8) / (x2-x1)
  mov [deltax],ax

  mov ah,[bx+PolyVR]
  mov al,0
  sub ah,[bx+PolyVL]  ; ax=(v2-v1) << 8
  cwd                 ; dx:ax=(v2-v1) << 8
  idiv cx             ; ax=((v2-v1)<<8) / (x2-x1)
  mov [deltay],ax

  inc cx              ; cx=length of line

  mov ah,bl
  mov al,[bx+PolyXL]
  mov di,ax           ; [es:di]=start of line

  xor dx,dx
  mov ah,[bx+PolyVL]  ; ax=v1<<8
  mov al,[bx+PolyUL]  
  mov si,ax           ; si=starting offset in texture
  mov dh,al           ; dx=u1<<8

  .thl_loop:
    mov bl,[fs:si]
    mov [es:di],bl    ; envoie le point
    inc di

    add ax,[deltay]
    add dx,[deltax]   ; avance dans la texture

    mov bh,ah
    mov bl,dh
    mov si,bx         ; si=nouvel offset

  loop .thl_loop
ret
 
;=====================
; Entres : al=x1, ah=y1, bl=x2, bh=y2, cl=u1, ch=v1, dl=u2, dh=v2
ScanPolySide:   

  cmp bh,ah
  jne .sps_ok_y1
    ret
  .sps_ok_y1:

  ja .sps_ok_y2
    xchg ax,bx
    xchg cx,dx
  .sps_ok_y2:

  mov [x1],al
  mov [y1],ah
  mov [x2],bl
  mov [y2],bh
  mov [u1],cl
  mov [v1],ch
  mov [u2],dl
  mov [v2],dh

  mov bl,bh
  mov bh,0
  sub bl,ah        ; bx=(y2-y1)
  

  mov ah,[x2]
  mov al,0
  sub ah,[x1]      ; ax=(x2-x1)<<8
  cwd
  idiv bx          ; ax=((x2-x1)<<8) / (y2-y1)
  mov [deltax],ax

  mov ah,[u2]
  mov al,0
  sub ah,[u1]
  cwd
  idiv bx          ; ax=((u2-u1)<<8) / (y2-y1)
  mov [deltau],ax

  mov ah,[v2]
  mov al,0
  sub ah,[v1]
  cwd
  idiv bx          ; ax=((v2-v1)<<8) / (y2-y1)
  mov [deltav],ax

  mov ah,[x1]
  mov ch,[u1]
  mov dh,[v1]
  mov al,0
  mov cl,0
  mov dl,0

  mov bx,[y1]
  .sps_loop:
    cmp ah,[bx+PolyXL]
    jae .sps_pas_l
      mov [bx+PolyXL],ah
      mov [bx+PolyUL],ch
      mov [bx+PolyVL],dh
    .sps_pas_l:

    cmp ah,[bx+PolyXR]
    jbe .sps_pas_r
      mov [bx+PolyXR],ah
      mov [bx+PolyUR],ch
      mov [bx+PolyVR],dh
    .sps_pas_r:

    add ax,[deltax]
    add cx,[deltau]
    add dx,[deltav]
  
    inc bx
    cmp bx,[y2]
  jne .sps_loop
ret




;Entre : ax=n de la face, dl=color, es=dest.
;         DS=SS=CS !!!!
TextPoly:

  shl ax,3
  add ax,Faces
  mov si,ax        ; [si]=p1, [si+1]=p2, [si+2]=p3, [si+3]=p4


  ; Calcul de Ymin et Ymax
  ;------------------------
  mov di,[si]
  mov al,[di+1] ; al=p1.y
  mov [Ymin],al ; Ymin=p1.y
  mov [Ymax],al ; Ymax=p1.y

  mov di,[si+2]
  mov al,[di+1] ; al=p2.y
  cmp al,[Ymin]
  jae .fp_min1
    mov [Ymin],al ; Ymin=p2.y
  .fp_min1:
  cmp al,[Ymax]
  jbe .fp_max1
    mov [Ymax],al ; Ymax=p2.y
  .fp_max1:

  mov di,[si+4]
  mov al,[di+1] ; al=p3.y
  cmp al,[Ymin]
  jae .fp_min2
    mov [Ymin],al ; Ymin=p3.y
  .fp_min2:
  cmp al,[Ymax]
  jbe .fp_max2
    mov [Ymax],al ; Ymax=p3.y
  .fp_max2:
  
  mov di,[si+6]
  mov al,[di+1] ; al=p4.y
  cmp al,[Ymin]
  jae .fp_min3
    mov [Ymin],al ; Ymin=p4.y
  .fp_min3:
  cmp al,[Ymax]
  jbe .fp_max3
    mov [Ymax],al ; Ymax=p4.y
  .fp_max3:

  ; Initialisation des tableaux PolyXL et PolyXR
  ;----------------------------------------------
  mov cx,256
  mov bx,Polygon
  .loop_poly_0:
    mov [bx], byte 255
    mov [bx+256], byte 0
    inc bx
;  jnz .loop_poly_0
  loop .loop_poly_0


  ; Appel des 4 ScanPolySide
  ;--------------------------
  mov di,[si]
  mov ax,[di]
  mov di,[si+2]
  mov bx,[di]
  mov cx,[UVs]
  mov dx,[UVs+2]
  push si
  call ScanPolySide
  pop si

  mov di,[si+2]
  mov ax,[di]
  mov di,[si+4]
  mov bx,[di]
  mov cx,[UVs+2]
  mov dx,[UVs+4]
  push si
  call ScanPolySide
  pop si

  mov di,[si+4]
  mov ax,[di]
  mov di,[si+6]
  mov bx,[di]
  mov cx,[UVs+4]
  mov dx,[UVs+6]
  push si
  call ScanPolySide
  pop si

  mov di,[si+6]
  mov ax,[di]
  mov di,[si]
  mov bx,[di]
  mov cx,[UVs+6]
  mov dx,[UVs]
  push si
  call ScanPolySide
  pop si
  
  ; Initialisation avant les HLines
  ;---------------------------------

;  xor ax,ax
;  mov al,[Ymin]
;  mov bh,al
;  add ax,Polygon
;  mov si,ax
;  xor cx,cx
;  pop ax           ; rcupre la couleur
;  mov dl,[Ymax]

  mov bl,[Ymin]
  mov bh,[Ymax]
  .loop_poly:
    push bx
    mov bh,0
    call TextHLine
    pop bx
;    mov bl,[si]
;    mov cl,[si+256]
;    sub cl,bl
;    inc cl
;    mov di,bx

;    rep stosb
;    inc si
    inc bl
    cmp bl,bh
  jbe .loop_poly
  
ret
