; VARIABLES
;===========

anglex:
angley:
anglez    dd 0

x_angle:
y_angle:
z_angle   dd 0.0

temp1     dd 0.0
temp2     dd 0.0

valeurPersp dd 500           ; Peut aller jusqu' 70
valeur800 dd 800.0

Cube:
  dw 8*4*3                   ; La taille du tableau de points
NbFaces:
  dw 6                       ; Le nombre de faces (== la taille du tableau)
Points:
  dd -5.0, -5.0, -5.0        ; P1
  dd -5.0, -5.0,  5.0        ; P2
  dd -5.0,  5.0, -5.0        ; .
  dd -5.0,  5.0,  5.0        ;
  dd  5.0, -5.0, -5.0        ; :
  dd  5.0, -5.0,  5.0        ; .
  dd  5.0,  5.0, -5.0        ;
  dd  5.0,  5.0,  5.0        ; P8
PointsR:                     ; Les points aprs rotation
  dd  0,0,0, 0,0,0
  dd  0,0,0, 0,0,0
  dd  0,0,0, 0,0,0
  dd  0,0,0, 0,0,0
PointsS:
  db 0,0,0,0                 ; x1,y1,x2,y2
  db 0,0,0,0                 ; ....
  db 0,0,0,0
  db 0,0,0,0
Faces:
  dw PointsS,      PointsS+(4*2),PointsS+(6*2),PointsS+(2*2)
  dw PointsS+(4*2),PointsS+(5*2),PointsS+(7*2),PointsS+(6*2)
  dw PointsS,      PointsS+(1*2),PointsS+(5*2),PointsS+(4*2)
  dw PointsS,      PointsS+(2*2),PointsS+(3*2),PointsS+(1*2)
  dw PointsS+(1*2),PointsS+(3*2),PointsS+(7*2),PointsS+(5*2)
  dw PointsS+(2*2),PointsS+(6*2),PointsS+(7*2),PointsS+(3*2)
UVs:
  db 1,1, 128,1, 128,128, 1,128
Visible:
  db 0,0,0,0,0,0             ; 1 si visible
Couleurs:
;  db 63,59,45,41,37,33




RotateCube:

  ; passage des angles byte->float
  ;--------------------------------

  fldpi                         ; pi
  fld dword [valeur128]         ; 128 | pi
  fild dword [anglex]           ; ax  | 128 | pi
  fdiv st0,st1                  ; ax/128 | 128 | pi
  fmul st0,st2
  fstp dword [x_angle]
;  fild dword [angley]           ; ay  | 128 | pi
;  fdiv st0,st1                  ; ay/128 | 128 | pi
;  fmul st0,st2
;  fstp dword [y_angle]
;  fild dword [anglez]           ; az  | 128 | pi
;  fdiv st0,st1                  ; az/128 | 128 | pi
;  fmul st0,st2
;  fstp dword [z_angle]
  


  xor bx,bx

  .rotation:

    ; autour de X
    ;-------------
    fld dword [x_angle]          ; xa
    fsincos                      ; cos(xa)     sin(xa)
    fld st0                      ; cos(xa)     cos(xa) sin(xa)
    fld st2                      ; sin(xa)     cos(xa) cos(xa) sin(xa)
    fld dword [bx+Points+8]
    fmulp st1,st0                ; z*sin       cos(xa) cos(xa) sin(xa) 
    fld dword [bx+Points+4]
    fmulp st2,st0                ; z*sin       y*cos   cos(xa) sin(xa)
    fsubp st1,st0                ; y*cos-z*sin cos(xa) sin(xa)
    fstp dword [temp1]           ; cos(xa)     sin(xa)
    fld dword [bx+Points+8]
    fmulp st1,st0                ; z*cos       sin(xa)
    fld dword [bx+Points+4]
    fmulp st2,st0                ; z*cos       y*sin
    faddp st1,st0                ; z*cos+y*sin
    fstp dword [temp2]           ; --
    mov eax,[temp1]
    mov [bx+PointsR+4],eax
    mov eax,[temp2]
    mov [bx+PointsR+8],eax
    
    ; autour de Y
    ;-------------
    fld dword [y_angle]          ; ya
    fsincos                      ; cos(ya)     sin(ya)
    fld st0                      ; cos(ya)     cos(ya) sin(ya)
    fld st2                      ; sin(ya)     cos(ya) cos(ya) sin(ya)
    fld dword [bx+Points]
    fmulp st1,st0                ; x*sin       cos(ya) cos(ya) sin(ya) 
    fld dword [bx+PointsR+8]
    fmulp st2,st0                ; x*sin       z*cos   cos(ya) sin(ya)
    fsubp st1,st0                ; z*cos-x*sin cos(ya) sin(ya)
    fstp dword [temp1]           ; cos(ya)     sin(ya)
    fld dword [bx+Points]
    fmulp st1,st0                ; x*cos       sin(ya)
    fld dword [bx+PointsR+8]
    fmulp st2,st0                ; x*cos       z*sin
    faddp st1,st0                ; x*cos+z*sin
    fstp dword [temp2]           ; --
    mov eax,[temp1]
    mov [bx+PointsR+8],eax
    mov eax,[temp2]
    mov [bx+PointsR],eax
    
    ; autour de Z
    ;-------------
    fld dword [z_angle]          ; za
    fsincos                      ; cos(za)     sin(za)
    fld st0                      ; cos(za)     cos(za) sin(za)
    fld st2                      ; sin(za)     cos(za) cos(za) sin(za)
    fld dword [bx+PointsR+4]
    fmulp st1,st0                ; y*sin       cos(za) cos(za) sin(za) 
    fld dword [bx+PointsR]
    fmulp st2,st0                ; y*sin       x*cos   cos(za) sin(za)
    fsubp st1,st0                ; x*cos-y*sin cos(za) sin(za)
    fstp dword [temp1]           ; cos(za)     sin(za)
    fld dword [bx+PointsR+4]
    fmulp st1,st0                ; y*cos       sin(za)
    fld dword [bx+PointsR]
    fmulp st2,st0                ; y*cos       x*sin
    faddp st1,st0                ; y*cos+x*sin
    fstp dword [temp2]           ; --
    mov eax,[temp1]
    mov [bx+PointsR],eax
    mov eax,[temp2]
    mov [bx+PointsR+4],eax
  
    add bx, 4*3
    cmp bx,[Cube]
  je .fini_rot
    jmp .rotation
  .fini_rot:

ret



CalcPerspective:
  finit
  xor bx,bx
  xor si,si
  .persp:
    fld dword [bx+PointsR+8]     ; z
    fild dword [valeurPersp]
    faddp st1,st0                ; z+128
    fld st0                      ; z+128 | z+128
    fld dword [bx+PointsR]       ; x     | z+128 | z+128
    fld dword [valeur800]
    fmulp st1,st0                ; 800*x | x+128 | z+128
    fdivrp st1,st0               ; 800x/(z+128) | z+128
    fadd dword [valeur128]
    fistp dword [temp1]          ; z+128
    fld dword [bx+PointsR+4]     ; y     | z+128
    fld dword [valeur800]
    fmulp st1,st0                ; 800*y | z+128
    fdivrp st1,st0               ; 800*y/(z+128)
    fadd dword [valeur128]
    mov al,[temp1]
    mov [si+PointsS],al
    inc si
    fistp dword [temp1]
    mov al,[temp1]
    mov [si+PointsS],al

    add bx,4*3
    inc si
    cmp bx,[Cube]
  jb .persp
ret
    

CheckVisible:
  mov cx,[NbFaces]
  mov dx,0
  mov si,Faces
  .loop_visible:
    xor ax,ax
    xor bx,bx
    mov di,[si+2]
    mov al,[di]   ; ax=p2.x
    mov di,[si]
    mov bl,[di]   ; bx=p1.x
    sub ax,bx     ; ax=p2.x-p1.x
    push ax

    xor ax,ax
    mov di,[si]
    mov al,[di+1] ; ax=p1.y
    mov di,[si+4]
    mov bl,[di+1] ; bx=p3.y
    sub ax,bx     ; ax=p1.y-p3.y
    pop bx        ; bx=p2.x-p1.x
    imul ax,bx    ; ax=(p2.x-p1.x) * (p1.y-p3.y)
    push ax

    xor ax,ax
    xor bx,bx
    mov di,[si+2]
    mov al,[di+1] ; ax=p2.y
    mov di,[si]
    mov bl,[di+1] ; bx=p1.y
    sub ax,bx     ; ax=p2.y-p1.y
    push ax

    xor ax,ax
    mov di,[si]
    mov al,[di]   ; ax=p1.x
    mov di,[si+4]
    mov bl,[di]   ; bx=p3.x
    sub ax,bx     ; ax=p1.x-p3.x
    pop bx
    imul ax,bx    ; ax=(p2.y-p1.y) * (p1.x-p3.x)

    pop bx
    mov di,dx
    sub bx,ax     ; bx=Tout

    jns .pas_invisible
      mov [di+Visible],byte 0
      jmp .fin_test
    .pas_invisible:
      mov [di+Visible],byte 1
    .fin_test:

    inc dx
    add si,8
  loop .loop_visible
ret