//-----------------------------------------------------------------------------
//	textures.h header file for texture engine
//-----------------------------------------------------------------------------



//-----------------------------------------------------------------------------
//	structur definitions
//-----------------------------------------------------------------------------

#ifndef		__TEXTURES_H_
#define		__TEXTURES_H_

#include <ddraw.h>
#include <d3d.h>

enum GEMIMAGELOAD
{
	GEMIMAGE_OFFSCREEN			= 1,
	GEMIMAGE_32BIT				= 2,
	GEMIMAGE_16BIT				= 4,
	GEMIMAGE_15BIT				= 8,
	GEMIMAGE_COLORFORMAT		= 16,
	GEMIMAGE_SYSTEMMEMORY		= 32
};

enum GEMTEXTURELOAD
{
	GEMTEXTURE_OVERRIDEFORMAT	= 1,
	GEMTEXTURE_ANYFORMAT		= 2,
	GEMTEXTURE_SYSTEMMEMORY		= 4,
	GEMTEXTURE_MANAGING			= 8,
	GEMTEXTURE_SQUARE			= 16,
	GEMTEXTURE_POW2				= 32
};

enum GEMALPHA
{
	GEMALPHA_CREATE				= 64,
	GEMALPHA_RESIZETEXTURE		= 128,
	GEMALPHA_RESIZEALPHA		= 256
};

enum GEMTEXTUREFORMAT
{
	ARGB8888					= 1,
	ARGB1555,
	RGB555,
	RGB888,
	RGB565
};

//--------------------------------------------------------------------------------
//	function prototypes
//--------------------------------------------------------------------------------
HRESULT LoadImage( TCHAR* name, LPDIRECTDRAWSURFACE7* lplpSurface, LPDIRECT3DDEVICE7 pd3dDevice, 
				   DWORD flags = GEMIMAGE_OFFSCREEN | GEMIMAGE_SYSTEMMEMORY );

HRESULT LoadImage( TCHAR* name, LPDIRECTDRAWSURFACE7* lplpSurface, LPDIRECTDRAW7 pDD, 
				   DWORD flags = GEMIMAGE_OFFSCREEN | GEMIMAGE_SYSTEMMEMORY );

HRESULT LoadTexture( TCHAR* name, LPDIRECTDRAWSURFACE7* lplpTexture, LPDIRECT3DDEVICE7 pd3dDevice,
					 DWORD flags = GEMTEXTURE_SQUARE | GEMTEXTURE_POW2 | GEMTEXTURE_MANAGING, DWORD format = 0 );

HRESULT LoadAlphaChannel( TCHAR* name, LPDIRECTDRAWSURFACE7* lplpTexture, LPDIRECT3DDEVICE7 pd3dDevice, 
						  DWORD flags = GEMALPHA_CREATE | GEMTEXTURE_SQUARE | GEMTEXTURE_POW2 | GEMTEXTURE_MANAGING );

//HRESULT AddTexture( TCHAR* name, DWORD stage = 0 );
//HRESULT UpdateTexture( TCHAR* name, LPDIRECT3DDEVICE7 pd3dDevice );
//HRESULT UpdateAllTextures( LPDIRECT3DDEVICE7 pd3dDevice );
//LPDIRECTDRAWSURFACE7 GetSurface( TCHAR* name );
//HRESULT RemoveTexture( TCHAR* name );
//HRESULT Convert( TCHAR* name, DWORD desireBPP );

#endif
