#ifndef __PARTICLE_H_
#define __PARTICEL_H_

#include <d3d.h>
#include "gemmath.h"

typedef struct _particle
{
	gem_Vector		vVelocity;
	gem_Vector		vInitialPos;
	gem_Vector		vPosition;

	FLOAT			bornTime;
	FLOAT			intensity;
	FLOAT			lifeTime;
	FLOAT			Falloff;
	FLOAT			coeff;

} PARTICLE, *LPPARTICLE;

class ParticleSystem
{
private:

	LPPARTICLE				prtclBuffer;
	DWORD					prtclBufferSize;
	LPDIRECTDRAWSURFACE7	texture;

	DWORD					curNbr;
	DWORD					genNbr;	
	DWORD					curParticle;

	gem_Vector				gravity;

public:

	ParticleSystem( DWORD _size, DWORD = 0, LPDIRECTDRAWSURFACE7 = NULL ); 

	~ParticleSystem()
	{
		delete prtclBuffer;
	}
	
	VOID Init( DWORD gNbr, gem_Vector grv, LPDIRECTDRAWSURFACE7 txt )
	{
		genNbr	= gNbr;
		texture	= txt;
		gravity = grv;
	}

	VOID Restart()
	{
		curNbr		= 0;
		curParticle = 0;
		ZeroMemory( prtclBuffer, prtclBufferSize*sizeof(PARTICLE) );
	}	

	gem_Vector& Gravity()
	{
		return gravity;
	}

	VOID Generate( FLOAT, gem_Vector& );
	VOID Move( FLOAT );
	VOID Render( gem_Matrix&, LPDIRECT3DDEVICE7 );
};


#endif