//----------------------------------------------------------------------------------------------
// weird cube efect, oh yeah i love that !
// by (guess who) yup ol' acid from z51 :)
//----------------------------------------------------------------------------------------------
// this file is part of source code from intertia demo (c)zone51 `2000
//----------------------------------------------------------------------------------------------

#define	 D3D_OVERLOADS
#include "Cube!.h"
#include "gemmath.h"
#include "extrastuff.h"
#include "texture.h"
#include "texturemenager.h"

// here we go with some globals

static	D3DMATRIX				g_matBox[20];
static	D3DMATRIX				matStrip[12];

static	D3DLVERTEX				Flare[4];

static	gem_Vector				flarePos[8];
static	gem_Matrix				mtxFlare[20];

static	D3DLVERTEX				FxPlain[2601];
static	WORD					FxPlainInd[15606];

static	D3DVERTEX				cube[36];
static	D3DLVERTEX				strip[23*6];

static	D3DTLVERTEX				Overground[4];

static	D3DTLVERTEX				PicPlane[4];
static	D3DTLVERTEX				Fade[4];

static	D3DTLVERTEX				CircMask[4];
static	LPDIRECTDRAWSURFACE7	Circ;

static	DWORD					cutscene = 1;

static	DWORD					text;
static	FLOAT					posx;
static	DWORD					text_alpha;

static	DWORD					endscene = 0;
static	DWORD					fade = 0;
static	DWORD					circ = 0;

VOID NewStrip( DWORD which, FLOAT trn )
{
	for( DWORD i = 0 ; i<6 ; i++ )
	{
		strip[i+6*which] = strip[i];
		strip[i+6*which].x += trn;
	}
}


VOID InitCubeFx()
{
	
	CreateCube( cube, 2.0f );

	strip[0] = D3DLVERTEX( D3DVECTOR( -2,  0.25f, 0 ), 0x7fffffff, 0, 0, 0 );
	strip[1] = D3DLVERTEX( D3DVECTOR(  2,  0.25f, 0 ), 0x7fffffff, 0, 1, 0 );
	strip[2] = D3DLVERTEX( D3DVECTOR(  2, -0.25f, 0 ), 0x7fffffff, 0, 1, 1 );

	strip[3] = D3DLVERTEX( D3DVECTOR(  2, -0.25f, 0 ), 0x7fffffff, 0, 1, 1 );
	strip[4] = D3DLVERTEX( D3DVECTOR( -2, -0.25f, 0 ), 0x7fffffff, 0, 0, 1 );
	strip[5] = D3DLVERTEX( D3DVECTOR( -2,  0.25f, 0 ), 0x7fffffff, 0, 0, 0 );

	for( DWORD i = 0 ; i<11 ; i++ )
	{
		NewStrip( i+1, -4.0f*( (FLOAT)i + 1.0f ) );
		NewStrip( i+12, 4.0f*( (FLOAT)i + 1.0f ) );
	}


	gem_Matrix		tmp = RotationMtx( 3.1415f*0.5f, 0, 0 );

	matStrip[0]  = GetD3DMATRIX( TranslationMtx( gem_Vector( 0,  2.25, 2 ) ) );
	matStrip[1]  = GetD3DMATRIX( TranslationMtx( gem_Vector( 0,  2.25,-2 ) ) );
	matStrip[2]  = GetD3DMATRIX( TranslationMtx( gem_Vector( 0, -2.25, 2 ) ) );
	matStrip[3]  = GetD3DMATRIX( TranslationMtx( gem_Vector( 0, -2.25,-2 ) ) );

	matStrip[4]  = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector(  2, 2.25, 0 ) ) );
	matStrip[5]  = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector( -2, 2.25, 0 ) ) );
	matStrip[6]  = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector(  2,-2.25, 0 ) ) );
	matStrip[7]  = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector( -2,-2.25, 0 ) ) );

	tmp = RotationMtx( 0, 0, 3.1415f*0.5f );

	matStrip[8]  = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector( -2.25, 0, 2 ) ) );
	matStrip[9]  = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector(  2.25, 0, 2 ) ) );
	matStrip[10] = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector( -2.25, 0,-2 ) ) );
	matStrip[11] = GetD3DMATRIX( tmp*TranslationMtx( gem_Vector(  2.25, 0,-2 ) ) );
}

// read some textures and do some stuff
HRESULT fxInit_Cube( LPDIRECT3DDEVICE7 pd3dDevice )
{
	LPDIRECTDRAWSURFACE7 surf;

	LoadTexture( "data\\textures\\boxback.jpg", pd3dDevice );	
	LoadTexture( "data\\textures\\board.jpg", pd3dDevice );	
	LoadTexture( "data\\textures\\light3.jpg", pd3dDevice );	
	LoadTexture( "data\\textures\\texturka.bmp", pd3dDevice );	
	LoadTexture( "data\\texts\\napis_12.jpg", pd3dDevice );
	LoadTexture( "data\\texts\\napis_13.jpg", pd3dDevice );

	LoadTexture( "data\\gfx\\theend.jpg", pd3dDevice );

	surf = GetTexture( "data\\textures\\boxback.jpg" );
	LoadAlphaChannel( "data\\textures\\alpha.bmp", &surf, pd3dDevice, 0 );		

	LoadTexture( "data\\textures\\fg_Cube.jpg", pd3dDevice );	
	surf = GetTexture( "data\\textures\\fg_Cube.jpg" );
	LoadAlphaChannel( "data\\textures\\fg_Cube_alpha.bmp", &surf, pd3dDevice, 0 );

	LoadAlphaChannel( "data\\textures\\circle_a.bmp", &Circ, pd3dDevice );

	InitCubeFx();

	D3DLVERTEX			Plain[4];

	Plain[0] = D3DLVERTEX( D3DVECTOR(-20, 20, 1 ), 0x30FFFFFF, 0, 0, 0 );
	Plain[1] = D3DLVERTEX( D3DVECTOR( 20, 20, 1 ), 0x30FFFFFF, 0, 1, 0 );
	Plain[2] = D3DLVERTEX( D3DVECTOR(-20,-20, 1 ), 0x30FFFFFF, 0, 0, 1 );
	Plain[3] = D3DLVERTEX( D3DVECTOR( 20,-20, 1 ), 0x30FFFFFF, 0, 1, 1 );

	Flare[0] = D3DLVERTEX( D3DVECTOR(-3, 3, 0 ), 0x80ffffff, 0, 0, 0 );
	Flare[1] = D3DLVERTEX( D3DVECTOR( 3, 3, 0 ), 0x80ffffff, 0, 1, 0 );
	Flare[2] = D3DLVERTEX( D3DVECTOR(-3,-3, 0 ), 0x80ffffff, 0, 0, 1 );
	Flare[3] = D3DLVERTEX( D3DVECTOR( 3,-3, 0 ), 0x80ffffff, 0, 1, 1 );

	CreatePlain( 50, 50, FxPlain, FxPlainInd, Plain );

	flarePos[0] = gem_Vector( -2.3f,  2.3f, -2.3f );
	flarePos[1] = gem_Vector(  2.3f,  2.3f, -2.3f );
	flarePos[2] = gem_Vector(  2.3f,  2.3f,  2.3f );
	flarePos[3] = gem_Vector( -2.3f,  2.3f,  2.3f );
	flarePos[4] = gem_Vector( -2.3f, -2.3f, -2.3f );
	flarePos[5] = gem_Vector(  2.3f, -2.3f, -2.3f );
	flarePos[6] = gem_Vector(  2.3f, -2.3f,  2.3f );
	flarePos[7] = gem_Vector( -2.3f, -2.3f,  2.3f );

	D3DVECTOR vFar = D3DVECTOR( 0.0f, 0.0f, 0.5f );    
	Overground[0] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.01f, 0.99f );
    Overground[1] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.01f, 0.01f );
    Overground[2] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.99f, 0.99f );
    Overground[3] = D3DTLVERTEX( vFar, 0.5f, 0xFFFFFFFF, 0, 0.99f, 0.01f );	

	D3DVIEWPORT7 vp;
    pd3dDevice->GetViewport(&vp);    
    Overground[0].sy = (FLOAT)vp.dwHeight;
    Overground[2].sy = (FLOAT)vp.dwHeight;
    Overground[2].sx = (FLOAT)vp.dwWidth;
    Overground[3].sx = (FLOAT)vp.dwWidth;	

	CircMask[0] = Overground[0];
	CircMask[1] = Overground[1];
	CircMask[2] = Overground[2];
	CircMask[3] = Overground[3];

	Fade[0] = Overground[0];
	Fade[1] = Overground[1];
	Fade[2] = Overground[2];
	Fade[3] = Overground[3];

	PicPlane[0] = Overground[0];
	PicPlane[1] = Overground[1];
	PicPlane[2] = Overground[2];
	PicPlane[3] = Overground[3];
	
	return S_OK;
}

HRESULT fxFrameMove_Cube( LPDIRECT3DDEVICE7 pd3dDevice, LPSYNCINFO sync )
{

	//********************************************************************

	D3DLIGHT7			light;
	ZeroMemory( &light, sizeof(light) );
	light.dltType		= D3DLIGHT_POINT;
	light.dcvDiffuse.r	= 1.0f;
	light.dcvDiffuse.g	= 1.0f;
	light.dcvDiffuse.b	= 1.0f;
	light.dvPosition.x	= 10.0f;
	light.dvPosition.y	= 0.0f;
	light.dvPosition.z	= 40.0f;
	light.dvAttenuation0= 1.0f;
	light.dvAttenuation1= 0.02f;
	light.dvAttenuation2= 0.0002f;
	light.dvRange		= 40.0f;

	pd3dDevice->SetLight( 0, &light );		

	pd3dDevice->LightEnable( 0, TRUE );	

	D3DMATERIAL7       mtrl;
	ZeroMemory( &mtrl, sizeof(mtrl) );
    mtrl.dcvAmbient.r = 0.3f;
    mtrl.dcvAmbient.g = 0.3f;
    mtrl.dcvAmbient.b = 0.3f;
	mtrl.dcvDiffuse.r = 1.0f;
    mtrl.dcvDiffuse.g = 1.0f;
    mtrl.dcvDiffuse.b = 1.0f;
	mtrl.dcvDiffuse.a = 0.25f;
    pd3dDevice->SetMaterial( &mtrl );

	D3DMATRIX mat;
	mat._11 = mat._22 = mat._33 = mat._44 = 1.0f;
	mat._12 = mat._13 = mat._14 = mat._41 = 0.0f;
	mat._21 = mat._23 = mat._24 = mat._42 = 0.0f;
	mat._31 = mat._32 = mat._34 = mat._43 = 0.0f;

	D3DMATRIX matWorld = mat;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &matWorld );

	// The view matrix defines the position and orientation of the camera.
	// Here, we are just moving it back along the z-axis by 10 units.
	D3DMATRIX matView = mat;
	matView._43 = 10.0f;
    pd3dDevice->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );

	// The projection matrix defines how the 3D scene is "projected" onto the
	// 2D render target (the backbuffer surface). Refer to the docs for more
	// info about projection matrices.
	D3DMATRIX matProj = (D3DMATRIX)ProjectionMtx( 50.0f, 1.0f, 1000.0f, 0.70f );
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );

	pd3dDevice->SetRenderState( D3DRENDERSTATE_AMBIENT, 0xFFFFFFFF );

	//*********************************************************************
	
	FLOAT	x1, y1;
	FLOAT	x2, y2;
	LONG	ind, i, j;
	FLOAT	coeff1, coeff2, coeff;
	FLOAT	a, b;
	FLOAT	_sin, _cos;
	FLOAT	fTimeKey = sync->fTimeKey;		
	
	for( i = 0; i<20 ; i++ )
	{
		g_matBox[i] = (D3DMATRIX)(ScaleMtx( (1.5f+sinf(2*(1+cos((FLOAT)i*3.1415f*0.05))*fTimeKey*0.5f+0.05f*(FLOAT)i)) )*								  
								  RotationMtx( -1.5f*(fTimeKey*0.5f-0.01f*(FLOAT)i), 2.0f*(fTimeKey*0.5f-0.01f*(FLOAT)i), -1.0f*(fTimeKey*0.5f-0.01f*(FLOAT)i) )*
							      TranslationMtx( 0, 0, 4 ));	

		
		mtxFlare[i] = RotationMtx( -1.5f*(fTimeKey*0.5f-0.05f*(FLOAT)i), 2.0f*(fTimeKey*0.5f-0.05f*(FLOAT)i), -1.0f*(fTimeKey*0.5f-0.05f*(FLOAT)i) )*
		 						TranslationMtx( 0, 0, 4 );
			
	}

	g_matBox[0] = (D3DMATRIX)(RotationMtx( -0.75f*fTimeKey, fTimeKey, -0.5f*fTimeKey )*
							      TranslationMtx( 0, 0, 4 ));	


	_sin = (FLOAT)sin( fTimeKey );
	_cos = (FLOAT)cos( fTimeKey );
	a = 6*_sin;
	b = 6*_cos;
	coeff = 30*(2+_sin);
	coeff1 = 1+_sin;
	coeff2 = 1+_cos;
	

	FLOAT	angle1, angle2;	

	for( angle1 = 1, i = 2 ; i<50 ; i++, angle1 += 3.1415f/48.0f )
		for( angle2 = 1, j = 2 ; j<50 ; j++, angle2 += 3.1415f/48.0f )
		{
			ind = i*51 + j;
			x1 = FxPlain[ind].x;
			y1 = FxPlain[ind].y;
			x2 = FxPlain[ind].x - a;
			y2 = FxPlain[ind].y - b;

						
			if( x1*x1 + y1*y1 < 250 )
			{
				FxPlain[ind].z = 200 - 18*sqrtf( 1 - x1*x1/250.0f - y1*y1/250.0f );
			}
			else
				FxPlain[ind].z = 1;

						
			if( x2*x2 + y2*y2 < 200 )
			{
				FxPlain[ind].z = coeff*(FLOAT)sqrt( 1 - x2*x2*0.005 - y2*y2*0.005 );
			}
			else
				FxPlain[ind].z = 1;			
			
			FxPlain[ind].z -= 6.0f*(FLOAT)cos( sqrt( coeff1*x1*x1 + coeff2*y1*y1 ) );		

			//FxPlain[ind].z = 20 - 2*cos( sqrt( coeff1*x1*x1 + coeff2*y1*y1 ) );
			
		}

	

	for( i = 0 ; i<=50 ; i++ )
		for( j = 0 ; j<=50 ; j++ )
		{
			ind = i*51 + j;
			FxPlain[ind].tu = (FLOAT)j*0.05f - _cos*0.25f;
			FxPlain[ind].tv = (FLOAT)i*0.05f - _sin*0.25f;
		}

	for( i = 0 ; i<6*23 ; i+=6 )
	{
		strip[i+0].tu = fTimeKey;
		strip[i+1].tu = fTimeKey + 1.0f;
		strip[i+2].tu = fTimeKey + 1.0f;
		strip[i+3].tu = fTimeKey + 1.0f;
		strip[i+4].tu = fTimeKey;
		strip[i+5].tu = fTimeKey;
	}

	if( fTimeKey < 4.0f )
	{	
		cutscene = 1;
		FLOAT	size = 13 + fTimeKey*130.0f;

		CircMask[0].sx = 320 - size;
		CircMask[0].sy = 240 + size;

		CircMask[1].sx = 320 - size;
		CircMask[1].sy = 240 - size;

		CircMask[2].sx = 320 + size;
		CircMask[2].sy = 240 + size;

		CircMask[3].sx = 320 + size;
		CircMask[3].sy = 240 - size;		
	}
	else
		cutscene = 0;

	if( fTimeKey>18.0 && fTimeKey<26.0f )
	{
		text = 1;
		posx = (fTimeKey - 18.0f)*10.0f;
		text_alpha = (DWORD)(sinf( (fTimeKey - 18.0f)*3.1415f*0.125f )*150.0f);
	}
	else
		text = 0;

	if( fTimeKey > 39.0f )
	{
		endscene = 1;

		DWORD		aph = (fTimeKey - 39.0f)*64.0f;

		if( aph > 255 )
			aph = 255;

		aph = (aph<<24)|0xffffff;

		PicPlane[0].dcColor = aph;
		PicPlane[1].dcColor = aph;
		PicPlane[2].dcColor = aph;
		PicPlane[3].dcColor = aph;
	}

	if( fTimeKey > 45.0f )
	{
		fade = 1;

		DWORD		aph = (fTimeKey - 45.0f)*90.0f;

		if( aph > 255 )
			aph = 255;

		aph = (aph<<24);

		Fade[0].dcColor = aph;
		Fade[1].dcColor = aph;
		Fade[2].dcColor = aph;
		Fade[3].dcColor = aph;
	}

	circ = 0;

	if( fTimeKey >= 13.0f && fTimeKey < 15.0f )
	{	
		circ = 1;
		FLOAT	size = 13 + (fTimeKey - 13.0f)*260.0f;

		CircMask[0].sx = 320 - size;
		CircMask[0].sy = 240 + size;

		CircMask[1].sx = 320 - size;
		CircMask[1].sy = 240 - size;

		CircMask[2].sx = 320 + size;
		CircMask[2].sy = 240 + size;

		CircMask[3].sx = 320 + size;
		CircMask[3].sy = 240 - size;		
	}	
	
	return S_OK;
}

HRESULT fxRender_Cube( LPDIRECT3DDEVICE7 pd3dDevice )
{		
	D3DMATRIX				mat = GetD3DMATRIX( IdentMtx() );	

	pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILENABLE, FALSE );

	if( cutscene )
	{		
		pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND,  D3DBLEND_ZERO );			
		pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE );		

		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILENABLE, TRUE );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILFUNC,   D3DCMP_EQUAL );		

		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILZFAIL, D3DSTENCILOP_KEEP );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILFAIL,  D3DSTENCILOP_KEEP );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILPASS,  D3DSTENCILOP_KEEP );		

		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILREF,      0x5 );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILMASK,     0xffffffff );
		pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILWRITEMASK,0xffffffff );		
	}
	
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &mat );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR );	
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_ANISOTROPIC );	
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_ANISOTROPIC );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_MAXANISOTROPY, 2 );

	pd3dDevice->SetRenderState( D3DRENDERSTATE_WRAP0, FALSE ); 	
	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, D3DZB_USEW );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, TRUE );

	pd3dDevice->BeginScene();

	pd3dDevice->SetTexture( 0, GetTexture( "data\\textures\\boxback.jpg" ) );	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_INVSRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_SRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_CULLMODE, D3DCULL_NONE );
	pd3dDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, D3DFVF_LVERTEX, FxPlain, 2601, FxPlainInd, 15606, NULL );		

	pd3dDevice->Clear( 1UL, NULL, D3DCLEAR_ZBUFFER, 0x00000000, 1.0f, 0L );		

	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, D3DZB_FALSE );	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, FALSE );
	
	pd3dDevice->SetTexture( 0, GetTexture( "data\\textures\\board.jpg" ) );	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, TRUE );		
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE );
	pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2 );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_CULLMODE, D3DCULL_NONE );

	for( LONG j = 0 ; j<15 ; j+=3 )
	{
		pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &g_matBox[j] );
		D3DMATERIAL7       mtrl;
		ZeroMemory( &mtrl, sizeof(mtrl) );
		mtrl.dcvAmbient.r = 1.0f;
		mtrl.dcvAmbient.g = 1.0f;
		mtrl.dcvAmbient.b = 1.0f;
		mtrl.dcvDiffuse.r = 1.0f;
		mtrl.dcvDiffuse.g = 1.0f;
		mtrl.dcvDiffuse.b = 1.0f;
		mtrl.dcvDiffuse.a = 0.25f;
		pd3dDevice->SetMaterial( &mtrl );		
		
		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, D3DFVF_VERTEX, cube, 36, NULL );	
	}	

	pd3dDevice->SetTexture( 0, GetTexture( "data\\textures\\texturka.bmp" ) );

	pd3dDevice->SetRenderState( D3DRENDERSTATE_COLORKEYENABLE, TRUE );
	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_ONE );		
	
	for( LONG i = 0 ; i<12 ; i++ )
	{
		D3DMATRIX	_mat = matStrip[i]*g_matBox[0];

		pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &_mat );		
		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST, D3DFVF_LVERTEX, strip, 23*6, NULL );	
	}
	
	pd3dDevice->SetTexture( 0, GetTexture( "data\\textures\\light3.jpg" ) );

	for( j = 0 ; j<20 ; j++ )
		for( LONG i = 0 ; i<8; i++ )
		{
			D3DMATRIX	_mat = (D3DMATRIX)(ScaleMtx( 0.3f - (FLOAT)j*0.0125f )*
										   TranslationMtx( flarePos[i]*mtxFlare[j] ) );
			
			pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &_mat );		
			pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_LVERTEX, Flare, 4, NULL );
		}
			

	pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_COLORKEYENABLE, FALSE );	

	mat = (D3DMATRIX)IdentMtx();
	pd3dDevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &mat );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_LIGHTING, FALSE );
	pd3dDevice->SetTexture( 0, GetTexture( "data\\textures\\boxback.jpg" ) );		
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZENABLE, D3DZB_USEW );		
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, TRUE );
	pd3dDevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, D3DFVF_LVERTEX, FxPlain, 2601, FxPlainInd, 15606, NULL );		

	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_INVSRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_SRCALPHA );	

	pd3dDevice->SetTexture( 0, GetTexture( "data\\textures\\fg_Cube.jpg" ) );	
	pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, Overground, 4, 0 );
	
	if( text )
	{
		RenderEfxFace( 200 + posx, 100, 382, 132, text_alpha, GetTexture( "data\\texts\\napis_12.jpg" ), pd3dDevice );
		RenderEfxFace( 460 - posx, 370, 302, 122, text_alpha, GetTexture( "data\\texts\\napis_13.jpg" ), pd3dDevice );
	}

	pd3dDevice->Clear( 1UL, NULL, D3DCLEAR_ZBUFFER, 0x00000000, 1.0f, 0L );		

	pd3dDevice->SetRenderState( D3DRENDERSTATE_STENCILENABLE, FALSE );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );	
	pd3dDevice->SetRenderState( D3DRENDERSTATE_SRCBLEND, D3DBLEND_SRCALPHA );
	pd3dDevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA );	

	if( cutscene || circ )
	{
		pd3dDevice->SetTexture( 0, Circ );			
		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, CircMask, 4, 0 );
	}

	if( endscene )
	{
		pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG2 );	
		pd3dDevice->SetTexture( 0, GetTexture( "data\\gfx\\theend.jpg" ) );			
		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, PicPlane, 4, 0 );
		pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1 );
	}

	if( fade )
	{
		pd3dDevice->SetTexture( 0, NULL );			
		pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, D3DFVF_TLVERTEX, Fade, 4, 0 );
	}

	pd3dDevice->SetTexture( 0, NULL );	

	pd3dDevice->EndScene();

	return S_OK;
}

#define SAFE_RELEASE( obj ) \
	 if( obj ) obj->Release()

VOID fxDelete_Cube( LPDIRECT3DDEVICE7 pd3dDevice )
{					
	SAFE_RELEASE( Circ );
}