#include "gemmath.h"

FLOAT RemapEase(FLOAT t, FLOAT a, FLOAT b)
{
	FLOAT 			k;
	FLOAT			s = a + b;

	if (s == 0.0)
		return t;

	if (s > 1.0)
	{
		a = a/s;
		b = b/s;
	}

	k = 1.0/(2.0-a-b);

	if (t < a)
		return ((k/a)*t*t);
	else
	{
		if (t < 1.0-b)
			return (k*(2*t-a));
		else
		{
			t = 1.0-t;
			return (1.0-(k/b)*t*t);
		}
	}
}


FLOAT LensToFOV( FLOAT lens )
{
	DWORD  					i;
	FLOAT 					fov;

	struct 
	{
		FLOAT		lens; 
		FLOAT		fov;
	} lens_table[] = {
						{15.0f,  115.0f}, 
						{20.0f,	 94.28571f}, 
						{24.0f,	 84.0f}, 
						{28.0f,  76.36364f},
						{35.0f,  63.0f},  
						{50.0f,	 48.0f},     
						{85.0f,	 28.0f}, 
						{135.0f, 18.0f},
						{200.0f, 12.0f}
					};

	for( i = 0 ; i < 9 ; i++ )
		if (lens == lens_table[i].lens)
		{			
			fov = lens_table[i].fov;
			break;
		}
		else
			fov = ( 15.0f / lens ) * 160.0f;

  return fov;
}



