/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio.device;

import java.io.InputStream;
import org.komplex.audio.AudioDataConverter;
import org.komplex.audio.AudioException;
import org.komplex.audio.BaseDevice;
import org.komplex.audio.PullAudioSource;
import sun.audio.AudioPlayer;

public class SunAudioDevice
extends BaseDevice {
    protected PullAudioSource source;
    AudioDataConverter ac;
    Input input = new Input();

    public void stop() {
        AudioPlayer.player.stop((InputStream)this.input);
    }

    public String toString() {
        return "JDK 1.1 sun.audio, Audio Out";
    }

    public int setFormat(int n) {
        return super.setFormat(3731);
    }

    public void start() throws AudioException {
        if (this.source == null) {
            throw new AudioException("no audio source");
        }
        AudioPlayer.player.start((InputStream)this.input);
        AudioPlayer.player.setPriority(10);
    }

    public void init(int n) throws AudioException {
        this.setFormat(n);
        this.ac = AudioDataConverter.getConverter(this.getFormat());
    }

    public void setPullSource(PullAudioSource pullAudioSource) {
        this.source = pullAudioSource;
    }

    class Input
    extends InputStream {
        int[] buffer;

        Input() {
            SunAudioDevice.this.getClass();
        }

        public int read() {
            return 255;
        }

        public int read(byte[] byArray, int n, int n2) {
            if (SunAudioDevice.this.source == null) {
                return n2;
            }
            if (this.buffer == null || this.buffer.length < n2) {
                this.buffer = new int[n2];
            }
            int n3 = 0;
            while (n3 < n2) {
                int n4 = SunAudioDevice.this.source.read(this.buffer, 0, n2 - n3);
                if (n4 <= 0) {
                    return n4;
                }
                SunAudioDevice.this.ac.convert(this.buffer, 0, byArray, n3 + n, n4);
                n3 += n4;
            }
            return n3;
        }
    }
}

