/*
 * Decompiled with CFR 0.152.
 */
package org.komplex.audio;

import java.util.Enumeration;
import java.util.Vector;
import org.komplex.audio.AudioOutDevice;

public class AudioOutDeviceFactory {
    Vector v = new Vector();
    Vector disabled = new Vector();
    boolean nosound = false;
    static final String AUDIO_OUT_JDK11 = "org.komplex.audio.device.SunAudioDevice";
    static final String AUDIO_OUT_IE4 = "org.komplex.audio.device.DirectSoundDevice";
    static final String AUDIO_OUT_JS = "org.komplex.audio.device.JavaSoundDevice";

    public void initArgs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("-nosound")) {
                this.nosound = true;
            }
            if (string.equals("-nojs")) {
                this.disabled.addElement(AUDIO_OUT_JS);
            }
            if (string.equals("-nods")) {
                this.disabled.addElement(AUDIO_OUT_IE4);
            }
            if (string.equals("-nosun")) {
                this.disabled.addElement(AUDIO_OUT_JDK11);
            }
            ++n;
        }
    }

    public AudioOutDeviceFactory() {
        this.v.addElement(AUDIO_OUT_IE4);
        this.v.addElement(AUDIO_OUT_JS);
        this.v.addElement(AUDIO_OUT_JDK11);
    }

    public void addDevice(String string) {
        this.v.addElement(string);
    }

    public AudioOutDevice getAudioOutDevice() {
        AudioOutDevice audioOutDevice = null;
        Enumeration enumeration = this.v.elements();
        while (enumeration.hasMoreElements()) {
            audioOutDevice = this.silentLoadAudioOutDevice(enumeration.nextElement().toString());
            if (audioOutDevice == null) continue;
            return audioOutDevice;
        }
        return audioOutDevice;
    }

    static AudioOutDevice loadDevice(String string) {
        Class<?> clazz = null;
        try {
            System.out.println(string);
            clazz = Class.forName(string);
            return (AudioOutDevice)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected AudioOutDevice silentLoadAudioOutDevice(String string) {
        if (this.disabled.contains(string)) {
            System.out.println("disabled: " + string);
            return null;
        }
        AudioOutDevice audioOutDevice = null;
        try {
            audioOutDevice = AudioOutDeviceFactory.loadDevice(string);
        }
        catch (Error error) {
            System.out.println("failed: " + string + " reason:" + error.toString());
        }
        return audioOutDevice;
    }

    public void disableDevice(AudioOutDevice audioOutDevice) {
        String string = audioOutDevice.getClass().getName();
        System.out.print(string);
        this.disabled.addElement(string);
    }
}

