 unit player;
 {(C) Charles Attard. April 1997}
 {Sample source to play modules}

 {$M 8000,0,655360}
 interface
 uses
      SB,SysProc,PlayMODs,Errors_E;

 var
     Nom_1,Err,Path : string[64];
     Cr             : char;
     I,Mode,LastBack,
     X,Y            ,
     CF,Min,Max     : word;
     Data           : MiscData;
     Shrink_Ok      : boolean;

procedure playxm(moduuli:string);
procedure stopxm;

implementation

procedure playxm(moduuli:string);
  begin
       DMASize:=16000;
       InitHardware;
       {Display error if any}
       if Err_Type>0 then
        begin
         writeln(Error_Msg(Err_Type));
         halt(Err_Type);
        end;
       {Search file}
       Load_MODule(moduuli);
       if Err_Type>0 then
        begin
             writeln(Error_Msg(Err_Type));
        end
       else
        begin
         {set output mode}
	 {0,3 8-bit stereo, 16-bit mono
	  1   16-bit stereo
	  2   8-bit mono}
         {returns Min frequency available,
                  Max frequency available}
         Mode:=1;
         Set_Output_Mode(Mode,Min,Max);
         {set desired output frequency,
          returns closest output frequency}
         Set_Output_Freq(44100,CF);
         {enable oversampling}
         Set_LDI(true);
         {set digital amplification using the number of tracks of the
          current module}
         Get_Module_Status(Data);
         Set_Ampl_Num(trunc(42+(Data[5]-3)*144/28));
         {0 allowed}
         {1 forbidden}
         {2 forced}
         Set_Loop_Mode(1);
         {enable digital low-pass filter}
         Set_Filter(true);
         {set filter iterations to 1}
         Set_Iter_Filtre(1);
         {set default panning}
         Set_Default_Pan(42);
         {set fade out delay to 1 ms}
         Set_Fade_Out_Delay(2000);
         {set master volume to maximum}
         Set_Master_Volume(64);

         Start_MODule;
  end;
end;

procedure stopxm;
begin
  Stop_MODule;
  CloseHardware;
end;

end.
