unit doom;

interface
uses routines,playmods,map;

const vidseg = $a000;
      zc = 256;
      xc = 160;
      yc = 100;
      linecut = 145;
      lines = 36;
      gap = 100;
      fgap = 500;

      sinsize = 360;

      skip = 4;

var picseg,doomseg,virseg : word;
    picscr,doomscr,virscr : pointer;
    loop : word;
    x,y,z : integer;
    stab,ctab : array[0..sinsize] of real;
    pal : array[0..255,1..3] of byte;
    palOK : boolean;
    frames : word;
    loppu : boolean;
    slider : word;
    trackstatus : miscdata;
    status : miscdata;
    miinus : word;

procedure do_doom(nosound:boolean);

implementation

procedure do_doom(nosound:boolean);

procedure flipE(soff,doff,lines,src,dest:word); assembler;
asm
  push ds
  mov ax,[dest]
  mov es,ax
  mov ax,[src]
  mov ds,ax
  mov ax,[doff]
  cmp ax,199
  ja @done
  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  mov ax,[soff]
  shl ax,6
  mov si,ax
  shl ax,2
  add si,ax
  mov ax,[lines]
  shl ax,6
  mov cx,ax
  shl ax,2
  add cx,ax
  shr cx,1
@inner:
  cmp di,63999
  ja @done
  movsw
  dec cx
  jne @inner
@done:
  pop ds
end;

procedure clsE(off,lines,segi:word); assembler;
asm
  mov ax,[segi]
  mov es,ax
  mov di,[off]
  mov ax,[lines]
  shl ax,6
  mov cx,ax
  shl ax,2
  add cx,ax
  shr cx,1
  rep stosw
end;

procedure distort(lines,src,dest,dist:word); assembler;
asm
  push ds
  mov ax,[src]
  mov ds,ax
  mov ax,[dest]
  mov es,ax
  xor si,si
  xor di,di
  mov bx,[lines]
@y:
  mov cx,160
  rep movsw

  dec bx
  jne @y
  pop ds
end;

begin
  cls(vidseg);
  randomize;
  getmem(virscr,320*200);
  virseg:=seg(virscr^);
  getmem(doomscr,320*lines);
  doomseg:=seg(doomscr^);
  getmem(picscr,320*linecut);
  picseg:=seg(picscr^);
  loadMAP(virseg,'doom.map');
  flipE(linecut,0,lines,virseg,doomseg);
  flipE(0,0,linecut,virseg,picseg);
  cls(virseg);

  for loop:=0 to sinsize do ctab[loop]:=cos(loop*pi/(sinsize div 2));
  for loop:=0 to sinsize do stab[loop]:=sin(loop*pi/(sinsize div 2));

  loppu:=false;

  miinus:=0;
  cls(vidseg);
  loadPAL('doom.pal');
  slider:=60;
  frames:=0;
  repeat
    inc(frames);
    if nosound then begin
      if frames=gap then miinus:=1;
      if frames=fgap then loppu:=true;
    end;
    if frames=skip then begin
      get_module_status(trackstatus);
      if trackstatus[0]=$31 then miinus:=1;
      if trackstatus[0]=$32 then loppu:=true;
      frames:=0;
    end;
    cls(virseg);
    flipE(0,0,linecut,picseg,virseg);
    flipE(0,linecut+slider,lines,doomseg,virseg);
    if slider>0 then slider:=slider-miinus;
    retrace;
    flip(virseg,vidseg);
  until (keypressed)or(loppu);
  freemem(virscr,320*200);
  freemem(picscr,320*linecut);
  freemem(doomscr,320*lines);
end;

end.
