//
// Tiny Surface class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package tinyptc;



public class Surface
{
    public Surface(int width,int height,Format format)
    {
        // setup data
        _width  = width;
        _height = height;
        _format = format;

        // calculate surface size
        int size = width * height;

        // allocate pixels
        switch (format.bits())
        {
            case 8:  _pixels = new byte[size]; break;
            case 32: _pixels = new int[size];  break;
        }
    }

    public void copy(Console console)
    {
        // load surface pixels to console
        console.load(_pixels,_width,_height,_width*_format.bytes(),_format,_palette);
    }

    public Object lock()
    {
        // lock surface
        return _pixels;
    }

    public void unlock()
    {
    }

    public void palette(int data[])
    {
        // set palette
        _palette = data;

    }

    public int width()
    {
        // get width
        return _width;
    }

    public int height()
    {
        // get height
        return _height;
    }

    public Format format()
    {
        // get format
        return _format;
    }

    // surface data
    private int _width;
    private int _height;
    private Format _format;
    private Object _pixels;
    private int[] _palette = new int[256];
}
