//
// RNI Console class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.rni;

// import classes
import ptc.Key;
import ptc.Area;
import ptc.Mode;
import ptc.Error;
import ptc.Color;
import ptc.Format;
import ptc.Palette;



public class Console implements ptc.base.Console
{
    public Console() throws Error
    {
        // register console
        Error.register(this);

        // create object
        object = create();
    }

    protected void finalize() throws Error
    {
        // unregister console
        Error.unregister(this);

        // close
        close();
        
        // destroy object
        destroy(object);
    }

    public void configure(String file) throws Error
    {
        // configure console
        configure(object,file);
    }

    public boolean option(String option) throws Error
    {
        // console option
        return option(object,option);
    }

    public Mode[] modes() throws Error
    {
        // get console modes
        return modes(object);
    }

    public void open(String title) throws Error
    {
        // open console
        open_1(object,title,0);
    }

    public void open(String title,int pages) throws Error
    {
        // open console
        open_1(object,title,pages);
    }

    public void open(String title,Format format) throws Error
    {
        // open console
        open_2(object,title,format,0);
    }

    public void open(String title,Format format,int pages) throws Error
    {
        // open console
        open_2(object,title,format,pages);
    }

    public void open(String title,int width,int height,Format format) throws Error
    {
        // open console
        open_3(object,title,width,height,format,0);
    }
    
    public void open(String title,int width,int height,Format format,int pages) throws Error
    {
        // open console
        open_3(object,title,width,height,format,pages);
    }

    public void open(String title,Mode mode) throws Error
    {
        // open console
        open_4(object,title,mode,0);
    }

    public void open(String title,Mode mode,int pages) throws Error
    {
        // open console
        open_4(object,title,mode,pages);
    }

    public void close() throws Error
    {
        // close console
        close(object);
    }

    public void flush() throws Error
    {
        // flush console
        flush(object);
    }

    public void finish() throws Error
    {
        // finish console
        finish(object);
    }

    public void update() throws Error
    {
        // update console
        update_1(object);
    }

    public void update(Area area) throws Error
    {
        // update console area
        update_2(object,area);
    }

    public boolean key() throws Error
    {
        // check for key press
        return key(object);
    }

    public Key read() throws Error
    {
        // read key press
        return read(object);
    }

    public void copy(ptc.base.Surface surface) throws Error
    {
        // copy console to surface
        copy_1(object,surface);
    }

    public void copy(ptc.base.Surface surface,Area source,Area destination) throws Error
    {
        // copy console area to surface area
        copy_2(object,surface,source,destination);
    }

    public Object lock() throws Error
    {
        // lock console
        return lock(object);
    }

    public void unlock() throws Error
    {
        // unlock console
        unlock(object);
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // load pixels to console
        load_1(object,pixels,width,height,pitch,format,palette);
    }

    public void load(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // load pixels to console area
        load_2(object,pixels,width,height,pitch,format,palette,source,destination);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error
    {
        // save console pixels
        save_1(object,pixels,width,height,pitch,format,palette);
    }

    public void save(Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error
    {
        // save console area pixels
        save_2(object,pixels,width,height,pitch,format,palette,source,destination);
    }

    public void clear() throws Error
    {
        // clear console
        clear_1(object);
    }

    public void clear(Color color) throws Error
    {
        // clear console area
        clear_2(object,color);
    }

    public void clear(Color color,Area area) throws Error
    {
        // clear console color area
        clear_3(object,color,area);
    }

    public void palette(Palette palette) throws Error
    {
        // set console palette
        palette_1(object,palette);
    }

    public Palette palette() throws Error
    {
        // get console palette
        return palette_2(object);
    }

    public void clip(Area area) throws Error
    {
        // set console clip area
        clip_1(object,area);
    }

    public int width() throws Error
    {
        // get console width
        return width(object);
    }

    public int height() throws Error
    {
        // get console height
        return height(object);
    }

    public int pages() throws Error
    {
        // get console pages
        return pages(object);
    }

    public int pitch() throws Error
    {
        // get console pitch
        return pitch(object);
    }

    public Area area() throws Error
    {
        // get console area
        return area(object);
    }

    public Area clip() throws Error
    {
        // get console clip
        return clip_2(object);
    }

    public Format format() throws Error
    {
        // get console format
        return format(object);
    }

    public String name() throws Error
    {
        // get console name
        return name(object);
    }

    public String title() throws Error
    {
        // get console title
        return title(object);
    }

    public String information() throws Error
    {
        // get console information
        return information(object);
    }

    // object handle
    private long object;

    // native methods
    private native long create() throws Error;
    private native void destroy(long object) throws Error;
    private native void configure(long object,String file) throws Error;
    private native boolean option(long object,String option) throws Error;
    private native Mode[] modes(long object) throws Error;
    private native void open_1(long object,String title,int pages) throws Error;
    private native void open_2(long object,String title,Format format,int pages) throws Error;
    private native void open_3(long object,String title,int width,int height,Format format,int pages) throws Error;
    private native void open_4(long object,String title,Mode mode,int pages) throws Error;
    private native void close(long object) throws Error;
    private native void flush(long object) throws Error;
    private native void finish(long object) throws Error;
    private native void update_1(long object) throws Error;
    private native void update_2(long object,Area area) throws Error;
    private native boolean key(long object) throws Error;
    private native Key read(long object) throws Error;
    private native void copy_1(long object,ptc.base.Surface surface) throws Error;
    private native void copy_2(long object,ptc.base.Surface surface,Area source,Area destination) throws Error;
    private native Object lock(long object) throws Error;
    private native void unlock(long object) throws Error;
    private native void load_1(long object,Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    private native void load_2(long object,Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;
    private native void save_1(long object,Object pixels,int width,int height,int pitch,Format format,Palette palette) throws Error;
    private native void save_2(long object,Object pixels,int width,int height,int pitch,Format format,Palette palette,Area source,Area destination) throws Error;
    private native void clear_1(long object) throws Error;
    private native void clear_2(long object,Color color) throws Error;
    private native void clear_3(long object,Color color,Area area) throws Error;
    private native void palette_1(long object,Palette palette) throws Error;
    private native Palette palette_2(long object) throws Error;
    private native void clip_1(long object,Area area) throws Error;
    private native int width(long object) throws Error;
    private native int height(long object) throws Error;
    private native int pages(long object) throws Error;
    private native int pitch(long object) throws Error;
    private native Area area(long object) throws Error;
    private native Area clip_2(long object) throws Error;
    private native Format format(long object) throws Error;
    private native String name(long object) throws Error;
    private native String title(long object) throws Error;
    private native String information(long object) throws Error;
}
