//
// Java Timer class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// class imports
import ptc.Error;



public class Timer implements ptc.base.Timer
{
    public Timer() throws Error
    {
        // defaults
        old = 0.0;
        time = 0.0;
        start = 0.0;
        current = 0.0;
        running = false;
    }

    public Timer(double time) throws Error
    {
        // defaults
        old = 0.0;
        time = 0.0;
        start = 0.0;
        current = 0.0;
        running = false;

        // set time
        set(time);
    }
    
    public void set(double time) throws Error
    {
        // set time
        current = time;
        start = clock();
        this.time = start + time;
        old = time - delta();
    }

    public void start() throws Error
    {
        // check if not running
        if (!running)
        {
            // set start time
            start = clock();

            // set old time
            old = clock();

            // timer is running
            running = true;
        }
    }

    public void stop() throws Error
    {
        // timer is not running
        running = false;
    }

    public double time() throws Error
    {
        // check if running
        if (running)
        {
            // get current clock time
            final double time = clock();

            // assign if time has advanced
            if (time>this.time) this.time = time;

            // calculate current time
            current = time - start;
        }

        // get current time
        return current;
    }

    public double delta() throws Error
    {
        // check if running
        if (running)
        {
            // get current clock time
            final double time = clock();

            // calculate delta
            double delta = time - old;

            // update old time
            old = time;

            // force positive delta
            if (delta<0.0) delta = 0.0; 

            // get delta
            return delta;
        }
        else
        {
            // not running
            return 0.0;
        }
    }

    public double resolution() throws Error
    {
        // get timer resolution
        return 1.0 / 1000.0;
    }
    
    private double clock()
    {
        // todo: get clock time
        return (double) System.currentTimeMillis() / 1000.0;
    }

    public Timer copy()
    {
        try
        {
            // clone timer object
            return (Timer) clone();
        }
        catch (CloneNotSupportedException e)
        {
            // failure
            return null;
        }
    }

    // timer data
    private double old;
    private double time;
    private double start;
    private double current;
    private boolean running;
}
