//
// Java Applet class for OpenPTC 1.0 Java Implementation
// Copyright (c) 1999 Glenn Fiedler (ptc@gaffer.org)
// This source code is licensed under the GNU LGPL
// See http://www.gnu.org/copyleft/lgpl.html for details
//

// package name
package ptc.java;

// import classes
import ptc.Error;
import java.awt.Color;
import java.awt.Graphics;



public abstract class Applet extends java.applet.Applet implements Runnable
{
    // abstract ptc applet methods
    public abstract ptc.base.Console create() throws Error;
    public abstract void run(ptc.base.Console console) throws Error;

    public void init()
    {
        // set black foreground
        setForeground(Color.black);

        // set black background
        setBackground(Color.black);
    }

    public void start()
    {
        // check thread
        if (thread==null)
        {
            // create thread
            thread = new Thread(this);

            // start thread
            thread.start();
        }
    }

    public void run()
    {
        try
        {
            // user create console
            console = create();

            // user run
            run(console);
        }
        catch (Error error)
        {
            // report error
            error.report();
        }
    }

    public void stop()
    {
        // check thread is valid and alive
        if (thread!=null && thread.isAlive())
        {
            // stop thread
            thread.stop();
        }

        // null thread
        thread = null;
    }

    /*
    public synchronized void repaint()
    {
        // paint window
    }

    public synchronized void repaint(int x,int y,int width,int height)
    {
        // paint window
    }

    public synchronized void repaint(long tm)
    {
        // paint window
    }

    public synchronized void repaint(long tm,int x,int y,int width,int height)
    {
        // paint window
    }
    */

    public synchronized void update(Graphics graphics)
    {
        // paint console
        paint(graphics);
    }

    public synchronized void paint(Graphics graphics)
    {
        try
        {
            // update console
            console.update();
        }
        catch (Error error)
        {
            // update error
        }
        /*
        // check console
        if (console!=null)
        {
            // paint console
            console.paint(graphics);
        }
        */
    }
    
    public synchronized void paintAll(Graphics graphics)
    {
        // paint console
        paint(graphics);
    }

    // applet data
    private Thread thread;
    private ptc.base.Console console;
}
